/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model;

import com.mongodb.Function;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.search.FieldSearchPath;
import com.mongodb.client.model.search.SearchPath;
import java.util.Iterator;
import org.bson.BsonArray;
import org.bson.BsonString;
import org.bson.BsonValue;

public final class Util {
    public static final String SEARCH_PATH_VALUE_KEY = "value";

    public static BsonValue combineToBsonValue(Iterator<? extends SearchPath> iterator, boolean bl) {
        Function<SearchPath, BsonValue> function = bl ? searchPath -> {
            if (searchPath instanceof FieldSearchPath) {
                return new BsonString(((FieldSearchPath)searchPath).toValue());
            }
            return searchPath.toBsonValue();
        } : SearchPath::toBsonValue;
        BsonValue bsonValue = function.apply(iterator.next());
        if (iterator.hasNext()) {
            BsonArray bsonArray = new BsonArray();
            bsonArray.add(bsonValue);
            while (iterator.hasNext()) {
                bsonArray.add(function.apply(iterator.next()));
            }
            return bsonArray;
        }
        return bsonValue;
    }

    public static boolean sizeAtLeast(Iterable<?> iterable, int n) {
        int n2;
        Iterator<?> iterator = iterable.iterator();
        for (n2 = 0; n2 < n && iterator.hasNext(); ++n2) {
            iterator.next();
        }
        return n2 >= n;
    }

    private Util() {
        throw Assertions.fail();
    }
}

