/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model.bulk;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.client.model.bulk.AbstractClientUpdateOptions;
import com.mongodb.internal.client.model.bulk.ClientWriteModel;
import com.mongodb.lang.Nullable;
import java.util.Optional;
import org.bson.conversions.Bson;

public abstract class AbstractClientUpdateModel<O extends AbstractClientUpdateOptions>
implements ClientWriteModel {
    private final Bson filter;
    @Nullable
    private final Bson update;
    @Nullable
    private final Iterable<? extends Bson> updatePipeline;
    private final O options;

    AbstractClientUpdateModel(Bson bson, @Nullable Bson bson2, @Nullable Iterable<? extends Bson> iterable, O o) {
        this.filter = bson;
        Assertions.assertTrue(bson2 == null ^ iterable == null);
        this.update = bson2;
        this.updatePipeline = iterable;
        this.options = o;
    }

    public final Bson getFilter() {
        return this.filter;
    }

    public final Optional<Bson> getUpdate() {
        return Optional.ofNullable(this.update);
    }

    public final Optional<Iterable<? extends Bson>> getUpdatePipeline() {
        return Optional.ofNullable(this.updatePipeline);
    }

    public final O getOptions() {
        return this.options;
    }
}

