/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model.bulk;

import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientDeleteResult;
import com.mongodb.client.model.bulk.ClientInsertOneResult;
import com.mongodb.client.model.bulk.ClientUpdateResult;
import com.mongodb.internal.client.model.bulk.AcknowledgedSummaryClientBulkWriteResult;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class AcknowledgedVerboseClientBulkWriteResult
implements ClientBulkWriteResult {
    private final AcknowledgedSummaryClientBulkWriteResult summaryResults;
    private final VerboseResults verboseResults;

    public AcknowledgedVerboseClientBulkWriteResult(AcknowledgedSummaryClientBulkWriteResult acknowledgedSummaryClientBulkWriteResult, Map<Integer, ClientInsertOneResult> map, Map<Integer, ClientUpdateResult> map2, Map<Integer, ClientDeleteResult> map3) {
        this.summaryResults = acknowledgedSummaryClientBulkWriteResult;
        this.verboseResults = new VerboseResults(map, map2, map3);
    }

    @Override
    public boolean isAcknowledged() {
        return true;
    }

    @Override
    public long getInsertedCount() {
        return this.summaryResults.getInsertedCount();
    }

    @Override
    public long getUpsertedCount() {
        return this.summaryResults.getUpsertedCount();
    }

    @Override
    public long getMatchedCount() {
        return this.summaryResults.getMatchedCount();
    }

    @Override
    public long getModifiedCount() {
        return this.summaryResults.getModifiedCount();
    }

    @Override
    public long getDeletedCount() {
        return this.summaryResults.getDeletedCount();
    }

    @Override
    public Optional<ClientBulkWriteResult.VerboseResults> getVerboseResults() {
        return Optional.of(this.verboseResults);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AcknowledgedVerboseClientBulkWriteResult acknowledgedVerboseClientBulkWriteResult = (AcknowledgedVerboseClientBulkWriteResult)object;
        return Objects.equals(this.summaryResults, acknowledgedVerboseClientBulkWriteResult.summaryResults) && Objects.equals(this.verboseResults, acknowledgedVerboseClientBulkWriteResult.verboseResults);
    }

    public int hashCode() {
        return Objects.hash(this.summaryResults, this.verboseResults);
    }

    public String toString() {
        return "AcknowledgedVerboseClientBulkWriteResult{insertedCount=" + this.summaryResults.getInsertedCount() + ", upsertedCount=" + this.summaryResults.getUpsertedCount() + ", matchedCount=" + this.summaryResults.getMatchedCount() + ", modifiedCount=" + this.summaryResults.getModifiedCount() + ", deletedCount=" + this.summaryResults.getDeletedCount() + ", insertResults=" + this.verboseResults.insertResults + ", updateResults=" + this.verboseResults.updateResults + ", deleteResults=" + this.verboseResults.deleteResults + '}';
    }

    private static final class VerboseResults
    implements ClientBulkWriteResult.VerboseResults {
        private final Map<Integer, ClientInsertOneResult> insertResults;
        private final Map<Integer, ClientUpdateResult> updateResults;
        private final Map<Integer, ClientDeleteResult> deleteResults;

        VerboseResults(Map<Integer, ClientInsertOneResult> map, Map<Integer, ClientUpdateResult> map2, Map<Integer, ClientDeleteResult> map3) {
            this.insertResults = map;
            this.updateResults = map2;
            this.deleteResults = map3;
        }

        @Override
        public Map<Integer, ClientInsertOneResult> getInsertResults() {
            return this.insertResults;
        }

        @Override
        public Map<Integer, ClientUpdateResult> getUpdateResults() {
            return this.updateResults;
        }

        @Override
        public Map<Integer, ClientDeleteResult> getDeleteResults() {
            return this.deleteResults;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            VerboseResults verboseResults = (VerboseResults)object;
            return Objects.equals(this.insertResults, verboseResults.insertResults) && Objects.equals(this.updateResults, verboseResults.updateResults) && Objects.equals(this.deleteResults, verboseResults.deleteResults);
        }

        public int hashCode() {
            return Objects.hash(this.insertResults, this.updateResults, this.deleteResults);
        }

        public String toString() {
            return "AcknowledgedVerboseClientBulkWriteResult.VerboseResults{insertResults=" + this.insertResults + ", updateResults=" + this.updateResults + ", deleteResults=" + this.deleteResults + '}';
        }
    }
}

