/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model.bulk;

import com.mongodb.client.model.bulk.ClientUpdateResult;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.bson.BsonValue;

public final class ConcreteClientUpdateResult
implements ClientUpdateResult {
    private final long matchedCount;
    private final long modifiedCount;
    @Nullable
    private final BsonValue upsertedId;

    public ConcreteClientUpdateResult(long l, long l2, @Nullable BsonValue bsonValue) {
        this.matchedCount = l;
        this.modifiedCount = l2;
        this.upsertedId = bsonValue;
    }

    @Override
    public long getMatchedCount() {
        return this.matchedCount;
    }

    @Override
    public long getModifiedCount() {
        return this.modifiedCount;
    }

    @Override
    public Optional<BsonValue> getUpsertedId() {
        return Optional.ofNullable(this.upsertedId);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConcreteClientUpdateResult concreteClientUpdateResult = (ConcreteClientUpdateResult)object;
        return this.matchedCount == concreteClientUpdateResult.matchedCount && this.modifiedCount == concreteClientUpdateResult.modifiedCount && Objects.equals(this.upsertedId, concreteClientUpdateResult.upsertedId);
    }

    public int hashCode() {
        return Objects.hash(this.matchedCount, this.modifiedCount, this.upsertedId);
    }

    public String toString() {
        return "ClientUpdateResult{matchedCount=" + this.matchedCount + ", modifiedCount=" + this.modifiedCount + ", upsertedId=" + this.upsertedId + '}';
    }
}

