/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.vault;

import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RangeOptions;
import com.mongodb.internal.crypt.capi.MongoExplicitEncryptOptions;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonValue;

public final class EncryptOptionsHelper {
    public static MongoExplicitEncryptOptions asMongoExplicitEncryptOptions(EncryptOptions encryptOptions) {
        RangeOptions rangeOptions;
        MongoExplicitEncryptOptions.Builder builder = MongoExplicitEncryptOptions.builder().algorithm(encryptOptions.getAlgorithm());
        if (encryptOptions.getKeyId() != null) {
            builder.keyId(encryptOptions.getKeyId());
        }
        if (encryptOptions.getKeyAltName() != null) {
            builder.keyAltName(encryptOptions.getKeyAltName());
        }
        if (encryptOptions.getContentionFactor() != null) {
            builder.contentionFactor(encryptOptions.getContentionFactor());
        }
        if (encryptOptions.getQueryType() != null) {
            builder.queryType(encryptOptions.getQueryType());
        }
        if ((rangeOptions = encryptOptions.getRangeOptions()) != null) {
            Integer n;
            Integer n2;
            Long l;
            BsonValue bsonValue;
            BsonDocument bsonDocument = new BsonDocument();
            BsonValue bsonValue2 = rangeOptions.getMin();
            if (bsonValue2 != null) {
                bsonDocument.put("min", bsonValue2);
            }
            if ((bsonValue = rangeOptions.getMax()) != null) {
                bsonDocument.put("max", bsonValue);
            }
            if ((l = rangeOptions.getSparsity()) != null) {
                bsonDocument.put("sparsity", new BsonInt64(l));
            }
            if ((n2 = rangeOptions.getTrimFactor()) != null) {
                bsonDocument.put("trimFactor", new BsonInt32(n2));
            }
            if ((n = rangeOptions.getPrecision()) != null) {
                bsonDocument.put("precision", new BsonInt32(n));
            }
            builder.rangeOptions(bsonDocument);
        }
        return builder.build();
    }

    private EncryptOptionsHelper() {
    }
}

