/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.connection.BaseCluster;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.ClusterableServerFactory;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bson.types.ObjectId;

public abstract class AbstractMultiServerCluster
extends BaseCluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private ClusterType clusterType;
    private String replicaSetName;
    private ObjectId maxElectionId;
    private Integer maxSetVersion;
    private final ConcurrentMap<ServerAddress, ServerTuple> addressToServerTupleMap = new ConcurrentHashMap<ServerAddress, ServerTuple>();

    AbstractMultiServerCluster(ClusterId clusterId, ClusterSettings clusterSettings, ClusterableServerFactory clusterableServerFactory) {
        super(clusterId, clusterSettings, clusterableServerFactory);
        Assertions.isTrue("connection mode is multiple", clusterSettings.getMode() == ClusterConnectionMode.MULTIPLE);
        this.clusterType = clusterSettings.getRequiredClusterType();
        this.replicaSetName = clusterSettings.getRequiredReplicaSetName();
    }

    ClusterType getClusterType() {
        return this.clusterType;
    }

    @Nullable
    MongoException getSrvResolutionException() {
        return null;
    }

    protected void initialize(Collection<ServerAddress> collection) {
        ClusterDescription clusterDescription = this.getCurrentDescription();
        this.withLock(() -> {
            for (ServerAddress serverAddress : collection) {
                this.addServer(serverAddress);
            }
            ClusterDescription clusterDescription2 = this.updateDescription();
            this.fireChangeEvent(clusterDescription2, clusterDescription);
        });
    }

    @Override
    protected void connect() {
        for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
            serverTuple.server.connect();
        }
    }

    @Override
    public void close() {
        this.withLock(() -> {
            if (!this.isClosed()) {
                for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
                    serverTuple.server.close();
                }
            }
            super.close();
        });
    }

    @Override
    public Cluster.ServersSnapshot getServersSnapshot(Timeout timeout, TimeoutContext timeoutContext) {
        Assertions.isTrue("is open", !this.isClosed());
        HashMap<ServerAddress, ServerTuple> hashMap = new HashMap<ServerAddress, ServerTuple>(this.addressToServerTupleMap);
        return serverAddress -> {
            ServerTuple serverTuple = (ServerTuple)hashMap.get(serverAddress);
            return serverTuple == null ? null : serverTuple.server;
        };
    }

    void onChange(Collection<ServerAddress> collection) {
        this.withLock(() -> {
            Object object2;
            if (this.isClosed()) {
                return;
            }
            for (Object object2 : collection) {
                this.addServer((ServerAddress)object2);
            }
            Object object3 = this.addressToServerTupleMap.values().iterator();
            while (object3.hasNext()) {
                object2 = (ServerTuple)object3.next();
                if (collection.contains(((ServerTuple)object2).description.getAddress())) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("Removing %s from client view of cluster.", ((ServerTuple)object2).description.getAddress()));
                }
                object3.remove();
                ((ServerTuple)object2).server.close();
            }
            object3 = this.getCurrentDescription();
            object2 = this.updateDescription();
            this.fireChangeEvent((ClusterDescription)object2, (ClusterDescription)object3);
        });
    }

    @Override
    public void onChange(ServerDescriptionChangedEvent serverDescriptionChangedEvent) {
        this.withLock(() -> {
            ServerTuple serverTuple;
            if (this.isClosed()) {
                return;
            }
            ServerDescription serverDescription = serverDescriptionChangedEvent.getNewDescription();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Handling description changed event for server %s with description %s", serverDescription.getAddress(), serverDescription));
            }
            if ((serverTuple = (ServerTuple)this.addressToServerTupleMap.get(serverDescription.getAddress())) == null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace(String.format("Ignoring description changed event for removed server %s", serverDescription.getAddress()));
                }
                return;
            }
            boolean bl = true;
            if (serverDescription.isOk()) {
                if (this.clusterType == ClusterType.UNKNOWN && serverDescription.getType() != ServerType.REPLICA_SET_GHOST) {
                    this.clusterType = serverDescription.getClusterType();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info(String.format("Discovered cluster type of %s", new Object[]{this.clusterType}));
                    }
                }
                switch (this.clusterType) {
                    case REPLICA_SET: {
                        bl = this.handleReplicaSetMemberChanged(serverDescription);
                        break;
                    }
                    case SHARDED: {
                        bl = this.handleShardRouterChanged(serverDescription);
                        break;
                    }
                    case STANDALONE: {
                        bl = this.handleStandAloneChanged(serverDescription);
                        break;
                    }
                }
            }
            ClusterDescription clusterDescription = null;
            ClusterDescription clusterDescription2 = null;
            if (bl) {
                serverTuple.description = serverDescription;
                clusterDescription = this.getCurrentDescription();
                clusterDescription2 = this.updateDescription();
            }
            if (bl) {
                this.fireChangeEvent(clusterDescription2, clusterDescription);
            }
        });
    }

    private boolean handleReplicaSetMemberChanged(ServerDescription serverDescription) {
        if (!serverDescription.isReplicaSetMember()) {
            LOGGER.error(String.format("Expecting replica set member, but found a %s.  Removing %s from client view of cluster.", new Object[]{serverDescription.getType(), serverDescription.getAddress()}));
            this.removeServer(serverDescription.getAddress());
            return true;
        }
        if (serverDescription.getType() == ServerType.REPLICA_SET_GHOST) {
            LOGGER.info(String.format("Server %s does not appear to be a member of an initiated replica set.", serverDescription.getAddress()));
            return true;
        }
        if (this.replicaSetName == null) {
            this.replicaSetName = Assertions.assertNotNull(serverDescription.getSetName());
        }
        if (!this.replicaSetName.equals(serverDescription.getSetName())) {
            LOGGER.error(String.format("Expecting replica set member from set '%s', but found one from set '%s'.  Removing %s from client view of cluster.", this.replicaSetName, serverDescription.getSetName(), serverDescription.getAddress()));
            this.removeServer(serverDescription.getAddress());
            return true;
        }
        this.ensureServers(serverDescription);
        if (serverDescription.getCanonicalAddress() != null && !serverDescription.getAddress().equals(new ServerAddress(serverDescription.getCanonicalAddress())) && !serverDescription.isPrimary()) {
            LOGGER.info(String.format("Canonical address %s does not match server address.  Removing %s from client view of cluster", serverDescription.getCanonicalAddress(), serverDescription.getAddress()));
            this.removeServer(serverDescription.getAddress());
            return true;
        }
        if (!serverDescription.isPrimary()) {
            return true;
        }
        if (this.isStalePrimary(serverDescription)) {
            this.invalidatePotentialPrimary(serverDescription);
            return false;
        }
        this.maxElectionId = AbstractMultiServerCluster.nullSafeMax(serverDescription.getElectionId(), this.maxElectionId);
        this.maxSetVersion = AbstractMultiServerCluster.nullSafeMax(serverDescription.getSetVersion(), this.maxSetVersion);
        this.invalidateOldPrimaries(serverDescription.getAddress());
        if (this.isNotAlreadyPrimary(serverDescription.getAddress())) {
            LOGGER.info(String.format("Discovered replica set primary %s with max election id %s and max set version %d", serverDescription.getAddress(), serverDescription.getElectionId(), serverDescription.getSetVersion()));
        }
        return true;
    }

    private boolean isStalePrimary(ServerDescription serverDescription) {
        ObjectId objectId = serverDescription.getElectionId();
        Integer n = serverDescription.getSetVersion();
        if (serverDescription.getMaxWireVersion() >= 17) {
            return AbstractMultiServerCluster.nullSafeCompareTo(objectId, this.maxElectionId) < 0 || AbstractMultiServerCluster.nullSafeCompareTo(objectId, this.maxElectionId) == 0 && AbstractMultiServerCluster.nullSafeCompareTo(n, this.maxSetVersion) < 0;
        }
        return n != null && objectId != null && (AbstractMultiServerCluster.nullSafeCompareTo(n, this.maxSetVersion) < 0 || AbstractMultiServerCluster.nullSafeCompareTo(n, this.maxSetVersion) == 0 && AbstractMultiServerCluster.nullSafeCompareTo(objectId, this.maxElectionId) < 0);
    }

    private void invalidatePotentialPrimary(ServerDescription serverDescription) {
        LOGGER.info(String.format("Invalidating potential primary %s whose (set version, election id) tuple of (%d, %s) is less than one already seen of (%d, %s)", serverDescription.getAddress(), serverDescription.getSetVersion(), serverDescription.getElectionId(), this.maxSetVersion, this.maxElectionId));
        ((ServerTuple)this.addressToServerTupleMap.get(serverDescription.getAddress())).server.resetToConnecting();
    }

    private static <T extends Comparable<T>> int nullSafeCompareTo(@Nullable T t, @Nullable T t2) {
        if (t == null) {
            return t2 == null ? 0 : -1;
        }
        if (t2 == null) {
            return 1;
        }
        return t.compareTo(t2);
    }

    @Nullable
    private static <T extends Comparable<T>> T nullSafeMax(@Nullable T t, @Nullable T t2) {
        if (t == null) {
            return t2;
        }
        if (t2 == null) {
            return t;
        }
        return t.compareTo(t2) >= 0 ? t : t2;
    }

    private boolean isNotAlreadyPrimary(ServerAddress serverAddress) {
        ServerTuple serverTuple = (ServerTuple)this.addressToServerTupleMap.get(serverAddress);
        return serverTuple == null || !serverTuple.description.isPrimary();
    }

    private boolean handleShardRouterChanged(ServerDescription serverDescription) {
        if (!serverDescription.isShardRouter()) {
            LOGGER.error(String.format("Expecting a %s, but found a %s.  Removing %s from client view of cluster.", new Object[]{ServerType.SHARD_ROUTER, serverDescription.getType(), serverDescription.getAddress()}));
            this.removeServer(serverDescription.getAddress());
        }
        return true;
    }

    private boolean handleStandAloneChanged(ServerDescription serverDescription) {
        if (this.getSettings().getHosts().size() > 1) {
            LOGGER.error(String.format("Expecting a single %s, but found more than one.  Removing %s from client view of cluster.", new Object[]{ServerType.STANDALONE, serverDescription.getAddress()}));
            this.clusterType = ClusterType.UNKNOWN;
            this.removeServer(serverDescription.getAddress());
        }
        return true;
    }

    private void addServer(ServerAddress serverAddress) {
        if (!this.addressToServerTupleMap.containsKey(serverAddress)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Adding discovered server %s to client view of cluster", serverAddress));
            }
            ClusterableServer clusterableServer = this.createServer(serverAddress);
            this.addressToServerTupleMap.put(serverAddress, new ServerTuple(clusterableServer, this.getConnectingServerDescription(serverAddress)));
        }
    }

    private void removeServer(ServerAddress serverAddress) {
        ServerTuple serverTuple = (ServerTuple)this.addressToServerTupleMap.remove(serverAddress);
        if (serverTuple != null) {
            serverTuple.server.close();
        }
    }

    private void invalidateOldPrimaries(ServerAddress serverAddress) {
        for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
            if (serverTuple.description.getAddress().equals(serverAddress) || !serverTuple.description.isPrimary()) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Rediscovering type of existing primary %s", serverTuple.description.getAddress()));
            }
            serverTuple.server.invalidate();
        }
    }

    private ServerDescription getConnectingServerDescription(ServerAddress serverAddress) {
        return ServerDescription.builder().state(ServerConnectionState.CONNECTING).address(serverAddress).build();
    }

    private ClusterDescription updateDescription() {
        ClusterDescription clusterDescription = new ClusterDescription(ClusterConnectionMode.MULTIPLE, this.clusterType, this.getSrvResolutionException(), this.getNewServerDescriptionList(), this.getSettings(), this.getServerFactory().getSettings());
        this.updateDescription(clusterDescription);
        return clusterDescription;
    }

    private List<ServerDescription> getNewServerDescriptionList() {
        ArrayList<ServerDescription> arrayList = new ArrayList<ServerDescription>();
        for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
            arrayList.add(serverTuple.description);
        }
        return arrayList;
    }

    private void ensureServers(ServerDescription serverDescription) {
        if (serverDescription.isPrimary() || !this.hasPrimary()) {
            this.addNewHosts(serverDescription.getHosts());
            this.addNewHosts(serverDescription.getPassives());
            this.addNewHosts(serverDescription.getArbiters());
        }
        if (serverDescription.isPrimary()) {
            this.removeExtraHosts(serverDescription);
        }
    }

    private boolean hasPrimary() {
        for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
            if (!serverTuple.description.isPrimary()) continue;
            return true;
        }
        return false;
    }

    private void addNewHosts(Set<String> set) {
        for (String string : set) {
            this.addServer(new ServerAddress(string));
        }
    }

    private void removeExtraHosts(ServerDescription serverDescription) {
        Set<ServerAddress> set = this.getAllServerAddresses(serverDescription);
        Iterator iterator = this.addressToServerTupleMap.values().iterator();
        while (iterator.hasNext()) {
            ServerTuple serverTuple = (ServerTuple)iterator.next();
            if (set.contains(serverTuple.description.getAddress())) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Server %s is no longer a member of the replica set.  Removing from client view of cluster.", serverTuple.description.getAddress()));
            }
            iterator.remove();
            serverTuple.server.close();
        }
    }

    private Set<ServerAddress> getAllServerAddresses(ServerDescription serverDescription) {
        HashSet<ServerAddress> hashSet = new HashSet<ServerAddress>();
        this.addHostsToSet(serverDescription.getHosts(), hashSet);
        this.addHostsToSet(serverDescription.getPassives(), hashSet);
        this.addHostsToSet(serverDescription.getArbiters(), hashSet);
        return hashSet;
    }

    private void addHostsToSet(Set<String> set, Set<ServerAddress> set2) {
        for (String string : set) {
            set2.add(new ServerAddress(string));
        }
    }

    private static final class ServerTuple {
        private final ClusterableServer server;
        private ServerDescription description;

        private ServerTuple(ClusterableServer clusterableServer, ServerDescription serverDescription) {
            this.server = clusterableServer;
            this.description = serverDescription;
        }
    }
}

