/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoSocketReadException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.MongoSocketWriteTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.internal.connection.ExtendedAsynchronousByteChannel;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.connection.Stream;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.ByteBuf;

public abstract class AsynchronousChannelStream
implements Stream {
    private final ServerAddress serverAddress;
    private final SocketSettings settings;
    private final PowerOfTwoBufferPool bufferProvider;
    private final AtomicReference<ExtendedAsynchronousByteChannel> channel;
    private volatile boolean isClosed;

    public AsynchronousChannelStream(ServerAddress serverAddress, SocketSettings socketSettings, PowerOfTwoBufferPool powerOfTwoBufferPool) {
        this.serverAddress = serverAddress;
        this.settings = socketSettings;
        this.bufferProvider = powerOfTwoBufferPool;
        this.channel = new AtomicReference();
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public SocketSettings getSettings() {
        return this.settings;
    }

    public PowerOfTwoBufferPool getBufferProvider() {
        return this.bufferProvider;
    }

    public ExtendedAsynchronousByteChannel getChannel() {
        return this.channel.get();
    }

    protected void setChannel(ExtendedAsynchronousByteChannel extendedAsynchronousByteChannel) {
        if (this.isClosed) {
            this.closeChannel(extendedAsynchronousByteChannel);
        } else {
            Assertions.assertTrue(this.channel.compareAndSet(null, extendedAsynchronousByteChannel));
            if (this.isClosed) {
                this.closeChannel(this.channel.getAndSet(null));
            }
        }
    }

    @Override
    public void writeAsync(List<ByteBuf> list, final OperationContext operationContext, final AsyncCompletionHandler<Void> asyncCompletionHandler) {
        final AsyncWritableByteChannelAdapter asyncWritableByteChannelAdapter = new AsyncWritableByteChannelAdapter();
        final Iterator<ByteBuf> iterator = list.iterator();
        this.pipeOneBuffer(asyncWritableByteChannelAdapter, iterator.next(), operationContext, new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(@Nullable Void void_) {
                if (iterator.hasNext()) {
                    AsynchronousChannelStream.this.pipeOneBuffer(asyncWritableByteChannelAdapter, (ByteBuf)iterator.next(), operationContext, this);
                } else {
                    asyncCompletionHandler.completed(null);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                asyncCompletionHandler.failed(throwable);
            }
        });
    }

    @Override
    public void readAsync(int n, OperationContext operationContext, AsyncCompletionHandler<ByteBuf> asyncCompletionHandler) {
        ByteBuf byteBuf = this.bufferProvider.getBuffer(n);
        long l = operationContext.getTimeoutContext().getReadTimeoutMS();
        this.getChannel().read(byteBuf.asNIO(), l, TimeUnit.MILLISECONDS, null, new BasicCompletionHandler(byteBuf, operationContext, asyncCompletionHandler));
    }

    @Override
    public void open(OperationContext operationContext) throws IOException {
        FutureAsyncCompletionHandler<Void> futureAsyncCompletionHandler = new FutureAsyncCompletionHandler<Void>();
        this.openAsync(operationContext, futureAsyncCompletionHandler);
        futureAsyncCompletionHandler.getOpen();
    }

    @Override
    public void write(List<ByteBuf> list, OperationContext operationContext) throws IOException {
        FutureAsyncCompletionHandler<Void> futureAsyncCompletionHandler = new FutureAsyncCompletionHandler<Void>();
        this.writeAsync(list, operationContext, futureAsyncCompletionHandler);
        futureAsyncCompletionHandler.getWrite();
    }

    @Override
    public ByteBuf read(int n, OperationContext operationContext) throws IOException {
        FutureAsyncCompletionHandler<ByteBuf> futureAsyncCompletionHandler = new FutureAsyncCompletionHandler<ByteBuf>();
        this.readAsync(n, operationContext, futureAsyncCompletionHandler);
        return futureAsyncCompletionHandler.getRead();
    }

    @Override
    public ServerAddress getAddress() {
        return this.serverAddress;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.closeChannel(this.channel.getAndSet(null));
    }

    private void closeChannel(@Nullable ExtendedAsynchronousByteChannel extendedAsynchronousByteChannel) {
        try {
            if (extendedAsynchronousByteChannel != null) {
                extendedAsynchronousByteChannel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public ByteBuf getBuffer(int n) {
        return this.bufferProvider.getBuffer(n);
    }

    private void pipeOneBuffer(final AsyncWritableByteChannelAdapter asyncWritableByteChannelAdapter, final ByteBuf byteBuf, final OperationContext operationContext, final AsyncCompletionHandler<Void> asyncCompletionHandler) {
        asyncWritableByteChannelAdapter.write(byteBuf.asNIO(), operationContext, new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(@Nullable Void void_) {
                if (byteBuf.hasRemaining()) {
                    asyncWritableByteChannelAdapter.write(byteBuf.asNIO(), operationContext, this);
                } else {
                    asyncCompletionHandler.completed(null);
                }
            }

            @Override
            public void failed(Throwable throwable) {
                asyncCompletionHandler.failed(throwable);
            }
        });
    }

    private class AsyncWritableByteChannelAdapter {
        private AsyncWritableByteChannelAdapter() {
        }

        void write(ByteBuffer byteBuffer, OperationContext operationContext, AsyncCompletionHandler<Void> asyncCompletionHandler) {
            AsynchronousChannelStream.this.getChannel().write(byteBuffer, operationContext.getTimeoutContext().getWriteTimeoutMS(), TimeUnit.MILLISECONDS, null, new WriteCompletionHandler(asyncCompletionHandler));
        }

        private class WriteCompletionHandler
        extends BaseCompletionHandler<Void, Integer, Object> {
            WriteCompletionHandler(AsyncCompletionHandler<Void> asyncCompletionHandler) {
                super(asyncCompletionHandler);
            }

            @Override
            public void completed(Integer n, Object object) {
                AsyncCompletionHandler<Object> asyncCompletionHandler = this.getHandlerAndClear();
                asyncCompletionHandler.completed(null);
            }

            @Override
            public void failed(Throwable throwable, Object object) {
                AsyncCompletionHandler asyncCompletionHandler = this.getHandlerAndClear();
                if (throwable instanceof InterruptedByTimeoutException) {
                    asyncCompletionHandler.failed(new MongoSocketWriteTimeoutException("Timeout while writing message", AsynchronousChannelStream.this.serverAddress, throwable));
                } else {
                    asyncCompletionHandler.failed(throwable);
                }
            }
        }
    }

    private final class BasicCompletionHandler
    extends BaseCompletionHandler<ByteBuf, Integer, Void> {
        private final AtomicReference<ByteBuf> byteBufReference;
        private final OperationContext operationContext;

        private BasicCompletionHandler(ByteBuf byteBuf, OperationContext operationContext, AsyncCompletionHandler<ByteBuf> asyncCompletionHandler) {
            super(asyncCompletionHandler);
            this.byteBufReference = new AtomicReference<ByteBuf>(byteBuf);
            this.operationContext = operationContext;
        }

        @Override
        public void completed(Integer n, Void void_) {
            AsyncCompletionHandler<ByteBuf> asyncCompletionHandler = this.getHandlerAndClear();
            ByteBuf byteBuf = this.byteBufReference.getAndSet(null);
            if (n == -1) {
                byteBuf.release();
                asyncCompletionHandler.failed(new MongoSocketReadException("Prematurely reached end of stream", AsynchronousChannelStream.this.serverAddress));
            } else if (!byteBuf.hasRemaining()) {
                byteBuf.flip();
                asyncCompletionHandler.completed(byteBuf);
            } else {
                AsynchronousChannelStream.this.getChannel().read(byteBuf.asNIO(), this.operationContext.getTimeoutContext().getReadTimeoutMS(), TimeUnit.MILLISECONDS, null, new BasicCompletionHandler(byteBuf, this.operationContext, asyncCompletionHandler));
            }
        }

        @Override
        public void failed(Throwable throwable, Void void_) {
            AsyncCompletionHandler asyncCompletionHandler = this.getHandlerAndClear();
            ByteBuf byteBuf = this.byteBufReference.getAndSet(null);
            byteBuf.release();
            if (throwable instanceof InterruptedByTimeoutException) {
                asyncCompletionHandler.failed(new MongoSocketReadTimeoutException("Timeout while receiving message", AsynchronousChannelStream.this.serverAddress, throwable));
            } else {
                asyncCompletionHandler.failed(throwable);
            }
        }
    }

    static class FutureAsyncCompletionHandler<T>
    implements AsyncCompletionHandler<T> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile T result;
        private volatile Throwable error;

        FutureAsyncCompletionHandler() {
        }

        @Override
        public void completed(@Nullable T t) {
            this.result = t;
            this.latch.countDown();
        }

        @Override
        public void failed(Throwable throwable) {
            this.error = throwable;
            this.latch.countDown();
        }

        void getOpen() throws IOException {
            this.get("Opening");
        }

        void getWrite() throws IOException {
            this.get("Writing to");
        }

        T getRead() throws IOException {
            return this.get("Reading from");
        }

        private T get(String string) throws IOException {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                throw InterruptionUtil.interruptAndCreateMongoInterruptedException(string + " the AsynchronousSocketChannelStream failed", interruptedException);
            }
            if (this.error != null) {
                if (this.error instanceof IOException) {
                    throw (IOException)this.error;
                }
                if (this.error instanceof MongoException) {
                    throw (MongoException)this.error;
                }
                throw new MongoInternalException(string + " the TlsChannelStream failed", this.error);
            }
            return this.result;
        }
    }

    private static abstract class BaseCompletionHandler<T, V, A>
    implements CompletionHandler<V, A> {
        private final AtomicReference<AsyncCompletionHandler<T>> handlerReference;

        BaseCompletionHandler(AsyncCompletionHandler<T> asyncCompletionHandler) {
            this.handlerReference = new AtomicReference<AsyncCompletionHandler<T>>(asyncCompletionHandler);
        }

        AsyncCompletionHandler<T> getHandlerAndClear() {
            return this.handlerReference.getAndSet(null);
        }
    }
}

