/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterId;
import com.mongodb.event.ClusterClosedEvent;
import com.mongodb.event.ClusterDescriptionChangedEvent;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.ClusterOpeningEvent;
import com.mongodb.event.ServerClosedEvent;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.event.ServerHeartbeatFailedEvent;
import com.mongodb.event.ServerHeartbeatStartedEvent;
import com.mongodb.event.ServerHeartbeatSucceededEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerMonitorListener;
import com.mongodb.event.ServerOpeningEvent;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Supplier;

@ThreadSafe
final class AsynchronousClusterEventListener
implements ClusterListener,
ServerListener,
ServerMonitorListener {
    private final BlockingQueue<Supplier<Boolean>> eventPublishers = new LinkedBlockingQueue<Supplier<Boolean>>();
    private final ClusterListener clusterListener;
    private final ServerListener serverListener;
    private final ServerMonitorListener serverMonitorListener;
    private final Thread publishingThread;

    static AsynchronousClusterEventListener startNew(ClusterId clusterId, ClusterListener clusterListener, ServerListener serverListener, ServerMonitorListener serverMonitorListener) {
        AsynchronousClusterEventListener asynchronousClusterEventListener = new AsynchronousClusterEventListener(clusterId, clusterListener, serverListener, serverMonitorListener);
        asynchronousClusterEventListener.publishingThread.start();
        return asynchronousClusterEventListener;
    }

    private AsynchronousClusterEventListener(ClusterId clusterId, ClusterListener clusterListener, ServerListener serverListener, ServerMonitorListener serverMonitorListener) {
        this.clusterListener = Assertions.notNull("clusterListener", clusterListener);
        this.serverListener = Assertions.notNull("serverListener", serverListener);
        this.serverMonitorListener = Assertions.notNull("serverMonitorListener", serverMonitorListener);
        this.publishingThread = new Thread(this::publishEvents, "cluster-event-publisher-" + clusterId.getValue());
        this.publishingThread.setDaemon(true);
    }

    Thread getPublishingThread() {
        return this.publishingThread;
    }

    @Override
    public void clusterOpening(ClusterOpeningEvent clusterOpeningEvent) {
        this.addClusterEventInvocation(clusterListener -> clusterListener.clusterOpening(clusterOpeningEvent), false);
    }

    @Override
    public void clusterClosed(ClusterClosedEvent clusterClosedEvent) {
        this.addClusterEventInvocation(clusterListener -> clusterListener.clusterClosed(clusterClosedEvent), true);
    }

    @Override
    public void clusterDescriptionChanged(ClusterDescriptionChangedEvent clusterDescriptionChangedEvent) {
        this.addClusterEventInvocation(clusterListener -> clusterListener.clusterDescriptionChanged(clusterDescriptionChangedEvent), false);
    }

    @Override
    public void serverOpening(ServerOpeningEvent serverOpeningEvent) {
        this.addServerEventInvocation(serverListener -> serverListener.serverOpening(serverOpeningEvent));
    }

    @Override
    public void serverClosed(ServerClosedEvent serverClosedEvent) {
        this.addServerEventInvocation(serverListener -> serverListener.serverClosed(serverClosedEvent));
    }

    @Override
    public void serverDescriptionChanged(ServerDescriptionChangedEvent serverDescriptionChangedEvent) {
        this.addServerEventInvocation(serverListener -> serverListener.serverDescriptionChanged(serverDescriptionChangedEvent));
    }

    @Override
    public void serverHearbeatStarted(ServerHeartbeatStartedEvent serverHeartbeatStartedEvent) {
        this.addServerMonitorEventInvocation(serverMonitorListener -> serverMonitorListener.serverHearbeatStarted(serverHeartbeatStartedEvent));
    }

    @Override
    public void serverHeartbeatSucceeded(ServerHeartbeatSucceededEvent serverHeartbeatSucceededEvent) {
        this.addServerMonitorEventInvocation(serverMonitorListener -> serverMonitorListener.serverHeartbeatSucceeded(serverHeartbeatSucceededEvent));
    }

    @Override
    public void serverHeartbeatFailed(ServerHeartbeatFailedEvent serverHeartbeatFailedEvent) {
        this.addServerMonitorEventInvocation(serverMonitorListener -> serverMonitorListener.serverHeartbeatFailed(serverHeartbeatFailedEvent));
    }

    private void addClusterEventInvocation(VoidFunction<ClusterListener> voidFunction, boolean bl) {
        this.addEvent(() -> {
            voidFunction.apply(this.clusterListener);
            return bl;
        });
    }

    private void addServerEventInvocation(VoidFunction<ServerListener> voidFunction) {
        this.addEvent(() -> {
            voidFunction.apply(this.serverListener);
            return false;
        });
    }

    private void addServerMonitorEventInvocation(VoidFunction<ServerMonitorListener> voidFunction) {
        this.addEvent(() -> {
            voidFunction.apply(this.serverMonitorListener);
            return false;
        });
    }

    private void addEvent(Supplier<Boolean> supplier) {
        if (!this.publishingThread.isAlive()) {
            return;
        }
        this.eventPublishers.add(supplier);
    }

    private void publishEvents() {
        while (true) {
            try {
                Supplier<Boolean> supplier;
                boolean bl;
                while (!(bl = (supplier = this.eventPublishers.take()).get().booleanValue())) {
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    @FunctionalInterface
    private static interface VoidFunction<T> {
        public void apply(T var1);
    }
}

