/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoSocketException;
import com.mongodb.MongoSocketOpenException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.internal.connection.AsynchronousChannelStream;
import com.mongodb.internal.connection.ExtendedAsynchronousByteChannel;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class AsynchronousSocketChannelStream
extends AsynchronousChannelStream {
    private final ServerAddress serverAddress;
    private final InetAddressResolver inetAddressResolver;
    private final SocketSettings settings;
    @Nullable
    private final AsynchronousChannelGroup group;

    AsynchronousSocketChannelStream(ServerAddress serverAddress, InetAddressResolver inetAddressResolver, SocketSettings socketSettings, PowerOfTwoBufferPool powerOfTwoBufferPool) {
        this(serverAddress, inetAddressResolver, socketSettings, powerOfTwoBufferPool, null);
    }

    public AsynchronousSocketChannelStream(ServerAddress serverAddress, InetAddressResolver inetAddressResolver, SocketSettings socketSettings, PowerOfTwoBufferPool powerOfTwoBufferPool, @Nullable AsynchronousChannelGroup asynchronousChannelGroup) {
        super(serverAddress, socketSettings, powerOfTwoBufferPool);
        this.serverAddress = serverAddress;
        this.inetAddressResolver = inetAddressResolver;
        this.settings = socketSettings;
        this.group = asynchronousChannelGroup;
    }

    @Override
    public void openAsync(OperationContext operationContext, AsyncCompletionHandler<Void> asyncCompletionHandler) {
        LinkedList<SocketAddress> linkedList;
        Assertions.isTrue("unopened", this.getChannel() == null);
        try {
            linkedList = new LinkedList<SocketAddress>(ServerAddressHelper.getSocketAddresses(this.serverAddress, this.inetAddressResolver));
        }
        catch (Throwable throwable) {
            asyncCompletionHandler.failed(throwable);
            return;
        }
        this.initializeSocketChannel(asyncCompletionHandler, linkedList);
    }

    private void initializeSocketChannel(AsyncCompletionHandler<Void> asyncCompletionHandler, Queue<SocketAddress> queue) {
        if (queue.isEmpty()) {
            asyncCompletionHandler.failed(new MongoSocketException("Exception opening socket", this.serverAddress));
        } else {
            SocketAddress socketAddress = queue.poll();
            try {
                AsynchronousSocketChannel asynchronousSocketChannel = this.group == null ? AsynchronousSocketChannel.open() : AsynchronousSocketChannel.open(this.group);
                asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
                if (this.settings.getReceiveBufferSize() > 0) {
                    asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.settings.getReceiveBufferSize());
                }
                if (this.settings.getSendBufferSize() > 0) {
                    asynchronousSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.settings.getSendBufferSize());
                }
                asynchronousSocketChannel.connect(socketAddress, null, new OpenCompletionHandler(asyncCompletionHandler, queue, asynchronousSocketChannel));
            }
            catch (IOException iOException) {
                asyncCompletionHandler.failed(new MongoSocketOpenException("Exception opening socket", this.serverAddress, (Throwable)iOException));
            }
            catch (Throwable throwable) {
                asyncCompletionHandler.failed(throwable);
            }
        }
    }

    private class OpenCompletionHandler
    implements CompletionHandler<Void, Object> {
        private final AtomicReference<AsyncCompletionHandler<Void>> handlerReference;
        private final Queue<SocketAddress> socketAddressQueue;
        private final AsynchronousSocketChannel attemptConnectionChannel;

        OpenCompletionHandler(AsyncCompletionHandler<Void> asyncCompletionHandler, Queue<SocketAddress> queue, AsynchronousSocketChannel asynchronousSocketChannel) {
            this.handlerReference = new AtomicReference<AsyncCompletionHandler<Void>>(asyncCompletionHandler);
            this.socketAddressQueue = queue;
            this.attemptConnectionChannel = asynchronousSocketChannel;
        }

        @Override
        public void completed(Void void_, Object object) {
            AsynchronousSocketChannelStream.this.setChannel(new AsynchronousSocketChannelAdapter(this.attemptConnectionChannel));
            ((AsyncCompletionHandler)this.handlerReference.getAndSet(null)).completed(null);
        }

        @Override
        public void failed(Throwable throwable, Object object) {
            AsyncCompletionHandler asyncCompletionHandler = this.handlerReference.getAndSet(null);
            if (this.socketAddressQueue.isEmpty()) {
                if (throwable instanceof IOException) {
                    asyncCompletionHandler.failed(new MongoSocketOpenException("Exception opening socket", AsynchronousSocketChannelStream.this.getAddress(), throwable));
                } else {
                    asyncCompletionHandler.failed(throwable);
                }
            } else {
                AsynchronousSocketChannelStream.this.initializeSocketChannel(asyncCompletionHandler, this.socketAddressQueue);
            }
        }
    }

    private static final class AsynchronousSocketChannelAdapter
    implements ExtendedAsynchronousByteChannel {
        private final AsynchronousSocketChannel channel;

        private AsynchronousSocketChannelAdapter(AsynchronousSocketChannel asynchronousSocketChannel) {
            this.channel = asynchronousSocketChannel;
        }

        @Override
        public <A> void read(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, @Nullable A a, CompletionHandler<Integer, ? super A> completionHandler) {
            this.channel.read(byteBuffer, l, timeUnit, a, completionHandler);
        }

        @Override
        public <A> void read(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, @Nullable A a, CompletionHandler<Long, ? super A> completionHandler) {
            this.channel.read(byteBufferArray, n, n2, l, timeUnit, a, completionHandler);
        }

        @Override
        public <A> void write(ByteBuffer byteBuffer, long l, TimeUnit timeUnit, A a, CompletionHandler<Integer, ? super A> completionHandler) {
            this.channel.write(byteBuffer, l, timeUnit, a, completionHandler);
        }

        @Override
        public <A> void write(ByteBuffer[] byteBufferArray, int n, int n2, long l, TimeUnit timeUnit, A a, CompletionHandler<Long, ? super A> completionHandler) {
            this.channel.write(byteBufferArray, n, n2, l, timeUnit, a, completionHandler);
        }

        @Override
        public <A> void read(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
            this.channel.read(byteBuffer, a, completionHandler);
        }

        @Override
        public Future<Integer> read(ByteBuffer byteBuffer) {
            return this.channel.read(byteBuffer);
        }

        @Override
        public <A> void write(ByteBuffer byteBuffer, A a, CompletionHandler<Integer, ? super A> completionHandler) {
            this.channel.write(byteBuffer, a, completionHandler);
        }

        @Override
        public Future<Integer> write(ByteBuffer byteBuffer) {
            return this.channel.write(byteBuffer);
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

