/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.AsynchronousSocketChannelStream;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.connection.Stream;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;
import java.nio.channels.AsynchronousChannelGroup;

public class AsynchronousSocketChannelStreamFactory
implements StreamFactory {
    private final PowerOfTwoBufferPool bufferProvider = PowerOfTwoBufferPool.DEFAULT;
    private final SocketSettings settings;
    private final InetAddressResolver inetAddressResolver;
    @Nullable
    private final AsynchronousChannelGroup group;

    public AsynchronousSocketChannelStreamFactory(InetAddressResolver inetAddressResolver, SocketSettings socketSettings, SslSettings sslSettings) {
        this(inetAddressResolver, socketSettings, sslSettings, null);
    }

    AsynchronousSocketChannelStreamFactory(InetAddressResolver inetAddressResolver, SocketSettings socketSettings, SslSettings sslSettings, @Nullable AsynchronousChannelGroup asynchronousChannelGroup) {
        Assertions.assertFalse(sslSettings.isEnabled());
        this.inetAddressResolver = inetAddressResolver;
        this.settings = Assertions.notNull("settings", socketSettings);
        this.group = asynchronousChannelGroup;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        return new AsynchronousSocketChannelStream(serverAddress, this.inetAddressResolver, this.settings, this.bufferProvider, this.group);
    }
}

