/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCredential;
import com.mongodb.MongoInternalException;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;

public abstract class Authenticator {
    private final MongoCredentialWithCache credential;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ServerApi serverApi;

    Authenticator(@NonNull MongoCredentialWithCache mongoCredentialWithCache, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this.credential = mongoCredentialWithCache;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
    }

    public static boolean shouldAuthenticate(@Nullable Authenticator authenticator, ConnectionDescription connectionDescription) {
        return authenticator != null && connectionDescription.getServerType() != ServerType.REPLICA_SET_ARBITER;
    }

    @NonNull
    MongoCredentialWithCache getMongoCredentialWithCache() {
        return this.credential;
    }

    @NonNull
    MongoCredential getMongoCredential() {
        return this.credential.getCredential();
    }

    ClusterConnectionMode getClusterConnectionMode() {
        return this.clusterConnectionMode;
    }

    @Nullable
    ServerApi getServerApi() {
        return this.serverApi;
    }

    @NonNull
    String getUserNameNonNull() {
        String string = this.credential.getCredential().getUserName();
        if (string == null) {
            throw new MongoInternalException("User name can not be null");
        }
        return string;
    }

    @NonNull
    char[] getPasswordNonNull() {
        char[] cArray = this.credential.getCredential().getPassword();
        if (cArray == null) {
            throw new MongoInternalException("Password can not be null");
        }
        return cArray;
    }

    @NonNull
    <T> T getNonNullMechanismProperty(String string, @Nullable T t) {
        T t2 = this.credential.getCredential().getMechanismProperty(string, t);
        if (t2 == null) {
            throw new MongoInternalException("Mechanism property can not be null");
        }
        return t2;
    }

    abstract void authenticate(InternalConnection var1, ConnectionDescription var2, OperationContext var3);

    abstract void authenticateAsync(InternalConnection var1, ConnectionDescription var2, OperationContext var3, SingleResultCallback<Void> var4);

    public void reauthenticate(InternalConnection internalConnection, OperationContext operationContext) {
        this.authenticate(internalConnection, internalConnection.getDescription(), operationContext);
    }

    public void reauthenticateAsync(InternalConnection internalConnection, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback2) {
        AsyncRunnable.beginAsync().thenRun(singleResultCallback -> this.authenticateAsync(internalConnection, internalConnection.getDescription(), operationContext, singleResultCallback)).finish(singleResultCallback2);
    }
}

