/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.lang.Nullable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslException;

final class AuthorizationHeader {
    private static final String AWS4_HMAC_SHA256 = "AWS4-HMAC-SHA256";
    private static final String SERVICE = "sts";
    private final String host;
    private final String timestamp;
    private final String signature;
    private final String sessionToken;
    private final String authorizationHeader;
    private final byte[] nonce;
    private final Map<String, String> requestHeaders;
    private final String body;

    private AuthorizationHeader(Builder builder) throws SaslException {
        this.sessionToken = builder.sessionToken;
        this.host = builder.host;
        this.timestamp = builder.timestamp;
        this.nonce = builder.nonce;
        this.body = "Action=GetCallerIdentity&Version=2011-06-15";
        this.requestHeaders = this.getRequestHeaders();
        String string = AuthorizationHeader.createCanonicalRequest("POST", "", this.body, this.requestHeaders);
        String string2 = AuthorizationHeader.createStringToSign(AuthorizationHeader.hash(string), this.getTimestamp(), this.getCredentialScope());
        this.signature = AuthorizationHeader.calculateSignature(string2, builder.secretKey, this.getDate(), AuthorizationHeader.getRegion(this.host), SERVICE);
        this.authorizationHeader = String.format("%s Credential=%s/%s, SignedHeaders=%s, Signature=%s", AWS4_HMAC_SHA256, builder.accessKeyID, this.getCredentialScope(), AuthorizationHeader.getSignedHeaders(this.requestHeaders), this.getSignature());
    }

    static String createCanonicalRequest(String string, String string2, String string3, Map<String, String> map) throws SaslException {
        String string4 = AuthorizationHeader.getCanonicalHeaders(map);
        String string5 = AuthorizationHeader.getSignedHeaders(map);
        List<String> list = Arrays.asList(string, "/", string2, string4, string5, AuthorizationHeader.hash(string3));
        return String.join((CharSequence)"\n", list);
    }

    static String createStringToSign(String string, String string2, String string3) {
        List<String> list = Arrays.asList(AWS4_HMAC_SHA256, string2, string3, string);
        return String.join((CharSequence)"\n", list);
    }

    static String calculateSignature(String string, String string2, String string3, String string4, String string5) throws SaslException {
        byte[] byArray = AuthorizationHeader.hmac(AuthorizationHeader.decodeUTF8("AWS4" + string2), AuthorizationHeader.decodeUTF8(string3));
        byte[] byArray2 = AuthorizationHeader.hmac(byArray, AuthorizationHeader.decodeUTF8(string4));
        byte[] byArray3 = AuthorizationHeader.hmac(byArray2, AuthorizationHeader.decodeUTF8(string5));
        byte[] byArray4 = AuthorizationHeader.hmac(byArray3, AuthorizationHeader.decodeUTF8("aws4_request"));
        return AuthorizationHeader.hexEncode(AuthorizationHeader.hmac(byArray4, AuthorizationHeader.decodeUTF8(string)));
    }

    private Map<String, String> getRequestHeaders() {
        if (this.requestHeaders != null) {
            return this.requestHeaders;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Content-Type", "application/x-www-form-urlencoded");
        hashMap.put("Content-Length", String.valueOf(this.body.length()));
        hashMap.put("Host", this.host);
        hashMap.put("X-Amz-Date", this.timestamp);
        hashMap.put("X-MongoDB-Server-Nonce", Base64.getEncoder().encodeToString(this.nonce));
        hashMap.put("X-MongoDB-GS2-CB-Flag", "n");
        if (this.sessionToken != null) {
            hashMap.put("X-Amz-Security-Token", this.sessionToken);
        }
        return hashMap;
    }

    private String getCredentialScope() throws SaslException {
        return String.format("%s/%s/%s/aws4_request", this.getDate(), AuthorizationHeader.getRegion(this.host), SERVICE);
    }

    static String getSignedHeaders(Map<String, String> map) {
        return map.keySet().stream().map(String::toLowerCase).sorted().collect(Collectors.joining(";"));
    }

    static String getCanonicalHeaders(Map<String, String> map) {
        return map.entrySet().stream().map(entry -> String.format("%s:%s\n", ((String)entry.getKey()).toLowerCase(), ((String)entry.getValue()).trim().replaceAll(" +", " "))).sorted().collect(Collectors.joining(""));
    }

    static String getRegion(String string) throws SaslException {
        String string2 = "(\\w)+(-\\w)*";
        if (string.equals("sts.amazonaws.com") || string.matches(String.format("%s", string2))) {
            return "us-east-1";
        }
        if (string.matches(String.format("%s(.%s)+", string2, string2))) {
            return string.split("\\.")[1];
        }
        throw new SaslException("Invalid host");
    }

    String getSignature() {
        return this.signature;
    }

    String getTimestamp() {
        return this.timestamp;
    }

    private String getDate() {
        return this.getTimestamp().substring(0, "YYYYMMDD".length());
    }

    static String hash(String string) throws SaslException {
        return AuthorizationHeader.hexEncode(AuthorizationHeader.sha256(string)).toLowerCase();
    }

    private static String hexEncode(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString();
    }

    private static byte[] decodeUTF8(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] hmac(byte[] byArray, byte[] byArray2) throws SaslException {
        byte[] byArray3;
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacSHA256");
            mac.init(secretKeySpec);
            byArray3 = mac.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new SaslException(exception.getMessage());
        }
        return byArray3;
    }

    private static byte[] sha256(String string) throws SaslException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException(noSuchAlgorithmException.getMessage());
        }
        return messageDigest.digest(string.getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return this.authorizationHeader;
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private String accessKeyID;
        private String secretKey;
        private String sessionToken;
        private String host;
        private String timestamp;
        private byte[] nonce;

        private Builder() {
        }

        Builder setAccessKeyID(String string) {
            this.accessKeyID = string;
            return this;
        }

        Builder setSecretKey(String string) {
            this.secretKey = string;
            return this;
        }

        Builder setSessionToken(@Nullable String string) {
            this.sessionToken = string;
            return this;
        }

        Builder setHost(String string) {
            this.host = string;
            return this;
        }

        Builder setTimestamp(String string) {
            this.timestamp = string;
            return this;
        }

        Builder setNonce(byte[] byArray) {
            this.nonce = byArray;
            return this;
        }

        AuthorizationHeader build() throws SaslException {
            return new AuthorizationHeader(this);
        }
    }
}

