/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.AwsCredential;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.internal.authentication.AwsCredentialHelper;
import com.mongodb.internal.connection.AuthorizationHeader;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.SaslAuthenticator;
import com.mongodb.lang.Nullable;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.RawBsonDocument;

public class AwsAuthenticator
extends SaslAuthenticator {
    private static final String MONGODB_AWS_MECHANISM_NAME = "MONGODB-AWS";
    private static final int RANDOM_LENGTH = 32;

    public AwsAuthenticator(MongoCredentialWithCache mongoCredentialWithCache, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(mongoCredentialWithCache, clusterConnectionMode, serverApi);
        if (this.getMongoCredential().getAuthenticationMechanism() != AuthenticationMechanism.MONGODB_AWS) {
            throw new MongoException("Incorrect mechanism: " + this.getMongoCredential().getMechanism());
        }
    }

    @Override
    public String getMechanismName() {
        return MONGODB_AWS_MECHANISM_NAME;
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        return new AwsSaslClient(this.getMongoCredential());
    }

    private static class AwsSaslClient
    extends SaslAuthenticator.SaslClientImpl {
        private final byte[] clientNonce = new byte[32];
        private int step = -1;

        AwsSaslClient(MongoCredential mongoCredential) {
            super(mongoCredential);
        }

        @Override
        public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
            ++this.step;
            if (this.step == 0) {
                return this.computeClientFirstMessage();
            }
            if (this.step == 1) {
                return this.computeClientFinalMessage(byArray);
            }
            throw new SaslException(String.format("Too many steps involved in the %s negotiation.", this.getMechanismName()));
        }

        @Override
        public boolean isComplete() {
            return this.step == 1;
        }

        private byte[] computeClientFirstMessage() {
            new SecureRandom().nextBytes(this.clientNonce);
            BsonDocument bsonDocument = new BsonDocument().append("r", new BsonBinary(this.clientNonce)).append("p", new BsonInt32(110));
            return SaslAuthenticator.toBson(bsonDocument);
        }

        private byte[] computeClientFinalMessage(byte[] byArray) throws SaslException {
            RawBsonDocument rawBsonDocument = new RawBsonDocument(byArray);
            String string = rawBsonDocument.getString("h").getValue();
            byte[] byArray2 = rawBsonDocument.getBinary("s").getData();
            if (byArray2.length != 64) {
                throw new SaslException(String.format("Server nonce must be %d bytes", 64));
            }
            if (!Arrays.equals(Arrays.copyOf(byArray2, 32), this.clientNonce)) {
                throw new SaslException(String.format("The first %d bytes of the server nonce must be the client nonce", 32));
            }
            String string2 = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneId.of("UTC")).format(Instant.now());
            AwsCredential awsCredential = this.createAwsCredential();
            String string3 = awsCredential.getSessionToken();
            AuthorizationHeader authorizationHeader = AuthorizationHeader.builder().setAccessKeyID(awsCredential.getAccessKeyId()).setSecretKey(awsCredential.getSecretAccessKey()).setSessionToken(string3).setHost(string).setNonce(byArray2).setTimestamp(string2).build();
            BsonDocument bsonDocument = new BsonDocument().append("a", new BsonString(authorizationHeader.toString())).append("d", new BsonString(authorizationHeader.getTimestamp()));
            if (string3 != null) {
                bsonDocument.append("t", new BsonString(string3));
            }
            return SaslAuthenticator.toBson(bsonDocument);
        }

        private AwsCredential createAwsCredential() {
            AwsCredential awsCredential;
            MongoCredential mongoCredential = this.getCredential();
            if (mongoCredential.getUserName() != null) {
                if (mongoCredential.getPassword() == null) {
                    throw new MongoClientException("secretAccessKey is required for AWS credential");
                }
                awsCredential = new AwsCredential(Assertions.assertNotNull(mongoCredential.getUserName()), new String(Assertions.assertNotNull(mongoCredential.getPassword())), mongoCredential.getMechanismProperty("AWS_SESSION_TOKEN", null));
            } else if (mongoCredential.getMechanismProperty("AWS_CREDENTIAL_PROVIDER", null) != null) {
                Supplier supplier = Assertions.assertNotNull(mongoCredential.getMechanismProperty("AWS_CREDENTIAL_PROVIDER", null));
                awsCredential = (AwsCredential)supplier.get();
                if (awsCredential == null) {
                    throw new MongoClientException("AWS_CREDENTIAL_PROVIDER_KEY must return an AwsCredential instance");
                }
            } else {
                awsCredential = AwsCredentialHelper.obtainFromEnvironment();
                if (awsCredential == null) {
                    throw new MongoClientException("Unable to obtain AWS credential from the environment");
                }
            }
            return awsCredential;
        }
    }
}

