/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoIncompatibleDriverException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.UnixServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.event.ClusterClosedEvent;
import com.mongodb.event.ClusterDescriptionChangedEvent;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.ClusterOpeningEvent;
import com.mongodb.internal.Locks;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.ClusterableServerFactory;
import com.mongodb.internal.connection.EventHelper;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ServerTuple;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.logging.LogMessage;
import com.mongodb.internal.logging.StructuredLogger;
import com.mongodb.internal.selector.AtMostTwoRandomServerSelector;
import com.mongodb.internal.selector.LatencyMinimizingServerSelector;
import com.mongodb.internal.selector.MinimumOperationCountServerSelector;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.CompositeServerSelector;
import com.mongodb.selector.ServerSelector;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class BaseCluster
implements Cluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private static final StructuredLogger STRUCTURED_LOGGER = new StructuredLogger("cluster");
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicReference<CountDownLatch> phase = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private final ClusterableServerFactory serverFactory;
    private final ClusterId clusterId;
    private final ClusterSettings settings;
    private final ClusterListener clusterListener;
    private final Deque<ServerSelectionRequest> waitQueue = new ConcurrentLinkedDeque<ServerSelectionRequest>();
    private final ClusterClock clusterClock = new ClusterClock();
    private Thread waitQueueHandler;
    private volatile boolean isClosed;
    private volatile ClusterDescription description;

    BaseCluster(ClusterId clusterId, ClusterSettings clusterSettings, ClusterableServerFactory clusterableServerFactory) {
        this.clusterId = Assertions.notNull("clusterId", clusterId);
        this.settings = Assertions.notNull("settings", clusterSettings);
        this.serverFactory = Assertions.notNull("serverFactory", clusterableServerFactory);
        this.clusterListener = EventListenerHelper.singleClusterListener(clusterSettings);
        this.clusterListener.clusterOpening(new ClusterOpeningEvent(clusterId));
        this.description = new ClusterDescription(clusterSettings.getMode(), ClusterType.UNKNOWN, Collections.emptyList(), clusterSettings, clusterableServerFactory.getSettings());
    }

    @Override
    public ClusterClock getClock() {
        return this.clusterClock;
    }

    @Override
    public ServerTuple selectServer(ServerSelector serverSelector, OperationContext operationContext) {
        Assertions.isTrue("open", !this.isClosed());
        OperationContext.ServerDeprioritization serverDeprioritization = operationContext.getServerDeprioritization();
        boolean bl = false;
        Timeout timeout = operationContext.getTimeoutContext().computeServerSelectionTimeout();
        BaseCluster.logServerSelectionStarted(this.clusterId, operationContext.getId(), serverSelector, this.description);
        while (true) {
            Object object;
            CountDownLatch countDownLatch = this.phase.get();
            ClusterDescription clusterDescription = this.description;
            ServerTuple serverTuple = this.createCompleteSelectorAndSelectServer(serverSelector, clusterDescription, serverDeprioritization, timeout, operationContext.getTimeoutContext());
            if (!clusterDescription.isCompatibleWithDriver()) {
                this.logAndThrowIncompatibleException(operationContext.getId(), serverSelector, clusterDescription);
            }
            if (serverTuple != null) {
                object = serverTuple.getServerDescription().getAddress();
                BaseCluster.logServerSelectionSucceeded(this.clusterId, operationContext.getId(), (ServerAddress)object, serverSelector, clusterDescription);
                serverDeprioritization.updateCandidate((ServerAddress)object);
                return serverTuple;
            }
            timeout.onExpired(() -> this.logAndThrowTimeoutException(operationContext, serverSelector, clusterDescription));
            if (!bl) {
                BaseCluster.logServerSelectionWaiting(this.clusterId, operationContext.getId(), timeout, serverSelector, clusterDescription);
                bl = true;
            }
            this.connect();
            object = Timeout.earliest(timeout, this.startMinWaitHeartbeatTimeout());
            object.awaitOn(countDownLatch, () -> String.format("waiting for a server that matches %s", serverSelector));
        }
    }

    @Override
    public void selectServerAsync(ServerSelector serverSelector, OperationContext operationContext, SingleResultCallback<ServerTuple> singleResultCallback) {
        Assertions.isTrue("open", !this.isClosed());
        Timeout timeout = operationContext.getTimeoutContext().computeServerSelectionTimeout();
        ServerSelectionRequest serverSelectionRequest = new ServerSelectionRequest(serverSelector, operationContext, timeout, singleResultCallback);
        CountDownLatch countDownLatch = this.phase.get();
        ClusterDescription clusterDescription = this.description;
        BaseCluster.logServerSelectionStarted(this.clusterId, operationContext.getId(), serverSelector, clusterDescription);
        if (!this.handleServerSelectionRequest(serverSelectionRequest, countDownLatch, clusterDescription)) {
            this.notifyWaitQueueHandler(serverSelectionRequest);
        }
    }

    @Override
    public ClusterId getClusterId() {
        return this.clusterId;
    }

    @Override
    public ClusterSettings getSettings() {
        return this.settings;
    }

    public ClusterableServerFactory getServerFactory() {
        return this.serverFactory;
    }

    protected abstract void connect();

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.isClosed = true;
            this.phase.get().countDown();
            this.clusterListener.clusterClosed(new ClusterClosedEvent(this.clusterId));
            this.stopWaitQueueHandler();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    protected void updateDescription(ClusterDescription clusterDescription) {
        this.withLock(() -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Updating cluster description to  %s", clusterDescription.getShortDescription()));
            }
            this.description = clusterDescription;
            this.updatePhase();
        });
    }

    protected void fireChangeEvent(ClusterDescription clusterDescription, ClusterDescription clusterDescription2) {
        if (!EventHelper.wouldDescriptionsGenerateEquivalentEvents(clusterDescription, clusterDescription2)) {
            this.clusterListener.clusterDescriptionChanged(new ClusterDescriptionChangedEvent(this.getClusterId(), clusterDescription, clusterDescription2));
        }
    }

    @Override
    public ClusterDescription getCurrentDescription() {
        return this.description;
    }

    @Override
    public void withLock(Runnable runnable) {
        Locks.withInterruptibleLock((Lock)this.lock, runnable);
    }

    private void updatePhase() {
        this.withLock(() -> this.phase.getAndSet(new CountDownLatch(1)).countDown());
    }

    private Timeout startMinWaitHeartbeatTimeout() {
        long l = this.serverFactory.getSettings().getMinHeartbeatFrequency(TimeUnit.NANOSECONDS);
        l = Math.max(0L, l);
        return Timeout.expiresIn(l, TimeUnit.NANOSECONDS, Timeout.ZeroSemantics.ZERO_DURATION_MEANS_EXPIRED);
    }

    private boolean handleServerSelectionRequest(ServerSelectionRequest serverSelectionRequest, CountDownLatch countDownLatch, ClusterDescription clusterDescription) {
        try {
            OperationContext operationContext = serverSelectionRequest.getOperationContext();
            long l = operationContext.getId();
            if (countDownLatch != serverSelectionRequest.phase) {
                CountDownLatch countDownLatch2 = serverSelectionRequest.phase;
                serverSelectionRequest.phase = countDownLatch;
                if (!clusterDescription.isCompatibleWithDriver()) {
                    this.logAndThrowIncompatibleException(l, serverSelectionRequest.originalSelector, clusterDescription);
                }
                OperationContext.ServerDeprioritization serverDeprioritization = serverSelectionRequest.operationContext.getServerDeprioritization();
                ServerTuple serverTuple = this.createCompleteSelectorAndSelectServer(serverSelectionRequest.originalSelector, clusterDescription, serverDeprioritization, serverSelectionRequest.getTimeout(), operationContext.getTimeoutContext());
                if (serverTuple != null) {
                    ServerAddress serverAddress = serverTuple.getServerDescription().getAddress();
                    BaseCluster.logServerSelectionSucceeded(this.clusterId, l, serverAddress, serverSelectionRequest.originalSelector, clusterDescription);
                    serverDeprioritization.updateCandidate(serverAddress);
                    serverSelectionRequest.onResult(serverTuple, null);
                    return true;
                }
                if (countDownLatch2 == null) {
                    BaseCluster.logServerSelectionWaiting(this.clusterId, l, serverSelectionRequest.getTimeout(), serverSelectionRequest.originalSelector, clusterDescription);
                }
            }
            Timeout.onExistsAndExpired(serverSelectionRequest.getTimeout(), () -> this.logAndThrowTimeoutException(operationContext, serverSelectionRequest.originalSelector, clusterDescription));
            return false;
        }
        catch (Exception exception) {
            serverSelectionRequest.onResult(null, exception);
            return true;
        }
    }

    @Nullable
    private ServerTuple createCompleteSelectorAndSelectServer(ServerSelector serverSelector, ClusterDescription clusterDescription, OperationContext.ServerDeprioritization serverDeprioritization, Timeout timeout, TimeoutContext timeoutContext) {
        return BaseCluster.createCompleteSelectorAndSelectServer(serverSelector, clusterDescription, this.getServersSnapshot(timeout, timeoutContext), serverDeprioritization, this.settings);
    }

    @Nullable
    static ServerTuple createCompleteSelectorAndSelectServer(ServerSelector serverSelector, ClusterDescription clusterDescription, Cluster.ServersSnapshot serversSnapshot, OperationContext.ServerDeprioritization serverDeprioritization, ClusterSettings clusterSettings) {
        ServerSelector serverSelector2 = BaseCluster.getCompleteServerSelector(serverSelector, serverDeprioritization, serversSnapshot, clusterSettings);
        return serverSelector2.select(clusterDescription).stream().map(serverDescription -> new ServerTuple(Assertions.assertNotNull(serversSnapshot.getServer(serverDescription.getAddress())), (ServerDescription)serverDescription)).findAny().orElse(null);
    }

    private static ServerSelector getCompleteServerSelector(ServerSelector serverSelector, OperationContext.ServerDeprioritization serverDeprioritization, Cluster.ServersSnapshot serversSnapshot, ClusterSettings clusterSettings) {
        List list = Stream.of(BaseCluster.getRaceConditionPreFilteringSelector(serversSnapshot), serverSelector, serverDeprioritization.getServerSelector(), clusterSettings.getServerSelector(), new LatencyMinimizingServerSelector(clusterSettings.getLocalThreshold(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS), AtMostTwoRandomServerSelector.instance(), new MinimumOperationCountServerSelector(serversSnapshot)).filter(Objects::nonNull).collect(Collectors.toList());
        return new CompositeServerSelector(list);
    }

    private static ServerSelector getRaceConditionPreFilteringSelector(Cluster.ServersSnapshot serversSnapshot) {
        return clusterDescription -> clusterDescription.getServerDescriptions().stream().filter(serverDescription -> serversSnapshot.containsServer(serverDescription.getAddress())).collect(Collectors.toList());
    }

    protected ClusterableServer createServer(ServerAddress serverAddress) {
        return this.serverFactory.create(this, serverAddress);
    }

    private void logAndThrowIncompatibleException(long l, ServerSelector serverSelector, ClusterDescription clusterDescription) {
        MongoIncompatibleDriverException mongoIncompatibleDriverException = this.createIncompatibleException(clusterDescription);
        BaseCluster.logServerSelectionFailed(this.clusterId, l, mongoIncompatibleDriverException, serverSelector, clusterDescription);
        throw mongoIncompatibleDriverException;
    }

    private MongoIncompatibleDriverException createIncompatibleException(ClusterDescription clusterDescription) {
        String string;
        ServerDescription serverDescription = clusterDescription.findServerIncompatiblyOlderThanDriver();
        if (serverDescription != null) {
            string = String.format("Server at %s reports wire version %d, but this version of the driver requires at least %d (MongoDB %s).", serverDescription.getAddress(), serverDescription.getMaxWireVersion(), 7, "3.6");
        } else {
            serverDescription = clusterDescription.findServerIncompatiblyNewerThanDriver();
            if (serverDescription != null) {
                string = String.format("Server at %s requires wire version %d, but this version of the driver only supports up to %d.", serverDescription.getAddress(), serverDescription.getMinWireVersion(), 25);
            } else {
                throw new IllegalStateException("Server can't be both older than the driver and newer.");
            }
        }
        return new MongoIncompatibleDriverException(string, clusterDescription);
    }

    private void logAndThrowTimeoutException(OperationContext operationContext, ServerSelector serverSelector, ClusterDescription clusterDescription) {
        String string = String.format("Timed out while waiting for a server that matches %s. Client view of cluster state is %s", serverSelector, clusterDescription.getShortDescription());
        MongoTimeoutException mongoTimeoutException = operationContext.getTimeoutContext().hasTimeoutMS() ? new MongoOperationTimeoutException(string) : new MongoTimeoutException(string);
        BaseCluster.logServerSelectionFailed(this.clusterId, operationContext.getId(), mongoTimeoutException, serverSelector, clusterDescription);
        throw mongoTimeoutException;
    }

    private void notifyWaitQueueHandler(ServerSelectionRequest serverSelectionRequest) {
        this.withLock(() -> {
            if (this.isClosed) {
                return;
            }
            this.waitQueue.add(serverSelectionRequest);
            if (this.waitQueueHandler == null) {
                this.waitQueueHandler = new Thread((Runnable)new WaitQueueHandler(), "cluster-" + this.clusterId.getValue());
                this.waitQueueHandler.setDaemon(true);
                this.waitQueueHandler.start();
            } else {
                this.updatePhase();
            }
        });
    }

    private void stopWaitQueueHandler() {
        this.withLock(() -> {
            if (this.waitQueueHandler != null) {
                this.waitQueueHandler.interrupt();
            }
        });
    }

    static void logServerSelectionStarted(ClusterId clusterId, long l, ServerSelector serverSelector, ClusterDescription clusterDescription) {
        if (STRUCTURED_LOGGER.isRequired(LogMessage.Level.DEBUG, clusterId)) {
            STRUCTURED_LOGGER.log(new LogMessage(LogMessage.Component.SERVER_SELECTION, LogMessage.Level.DEBUG, "Server selection started", clusterId, Arrays.asList(new LogMessage.Entry(LogMessage.Entry.Name.OPERATION, null), new LogMessage.Entry(LogMessage.Entry.Name.OPERATION_ID, l), new LogMessage.Entry(LogMessage.Entry.Name.SELECTOR, serverSelector.toString()), new LogMessage.Entry(LogMessage.Entry.Name.TOPOLOGY_DESCRIPTION, clusterDescription.getShortDescription())), "Server selection started for operation[ {}] with ID {}. Selector: {}, topology description: {}"));
        }
    }

    private static void logServerSelectionWaiting(ClusterId clusterId, long l2, Timeout timeout, ServerSelector serverSelector, ClusterDescription clusterDescription) {
        if (STRUCTURED_LOGGER.isRequired(LogMessage.Level.INFO, clusterId)) {
            STRUCTURED_LOGGER.log(new LogMessage(LogMessage.Component.SERVER_SELECTION, LogMessage.Level.INFO, "Waiting for suitable server to become available", clusterId, Arrays.asList(new LogMessage.Entry(LogMessage.Entry.Name.OPERATION, null), new LogMessage.Entry(LogMessage.Entry.Name.OPERATION_ID, l2), timeout.call(TimeUnit.MILLISECONDS, () -> new LogMessage.Entry(LogMessage.Entry.Name.REMAINING_TIME_MS, "infinite"), l -> new LogMessage.Entry(LogMessage.Entry.Name.REMAINING_TIME_MS, l), () -> new LogMessage.Entry(LogMessage.Entry.Name.REMAINING_TIME_MS, 0L)), new LogMessage.Entry(LogMessage.Entry.Name.SELECTOR, serverSelector.toString()), new LogMessage.Entry(LogMessage.Entry.Name.TOPOLOGY_DESCRIPTION, clusterDescription.getShortDescription())), "Waiting for server to become available for operation[ {}] with ID {}.[ Remaining time: {} ms.] Selector: {}, topology description: {}."));
        }
    }

    private static void logServerSelectionFailed(ClusterId clusterId, long l, MongoException mongoException, ServerSelector serverSelector, ClusterDescription clusterDescription) {
        if (STRUCTURED_LOGGER.isRequired(LogMessage.Level.DEBUG, clusterId)) {
            String string = mongoException instanceof MongoTimeoutException ? MongoTimeoutException.class.getName() + ": Timed out while waiting for a suitable server" : mongoException.toString();
            STRUCTURED_LOGGER.log(new LogMessage(LogMessage.Component.SERVER_SELECTION, LogMessage.Level.DEBUG, "Server selection failed", clusterId, Arrays.asList(new LogMessage.Entry(LogMessage.Entry.Name.OPERATION, null), new LogMessage.Entry(LogMessage.Entry.Name.OPERATION_ID, l), new LogMessage.Entry(LogMessage.Entry.Name.FAILURE, string), new LogMessage.Entry(LogMessage.Entry.Name.SELECTOR, serverSelector.toString()), new LogMessage.Entry(LogMessage.Entry.Name.TOPOLOGY_DESCRIPTION, clusterDescription.getShortDescription())), "Server selection failed for operation[ {}] with ID {}. Failure: {}. Selector: {}, topology description: {}"));
        }
    }

    static void logServerSelectionSucceeded(ClusterId clusterId, long l, ServerAddress serverAddress, ServerSelector serverSelector, ClusterDescription clusterDescription) {
        if (STRUCTURED_LOGGER.isRequired(LogMessage.Level.DEBUG, clusterId)) {
            STRUCTURED_LOGGER.log(new LogMessage(LogMessage.Component.SERVER_SELECTION, LogMessage.Level.DEBUG, "Server selection succeeded", clusterId, Arrays.asList(new LogMessage.Entry(LogMessage.Entry.Name.OPERATION, null), new LogMessage.Entry(LogMessage.Entry.Name.OPERATION_ID, l), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_HOST, serverAddress.getHost()), new LogMessage.Entry(LogMessage.Entry.Name.SERVER_PORT, serverAddress instanceof UnixServerAddress ? null : Integer.valueOf(serverAddress.getPort())), new LogMessage.Entry(LogMessage.Entry.Name.SELECTOR, serverSelector.toString()), new LogMessage.Entry(LogMessage.Entry.Name.TOPOLOGY_DESCRIPTION, clusterDescription.getShortDescription())), "Server selection succeeded for operation[ {}] with ID {}. Selected server: {}[:{}]. Selector: {}, topology description: {}"));
        }
    }

    private static final class ServerSelectionRequest {
        private final ServerSelector originalSelector;
        private final SingleResultCallback<ServerTuple> callback;
        private final OperationContext operationContext;
        private final Timeout timeout;
        private CountDownLatch phase;

        ServerSelectionRequest(ServerSelector serverSelector, OperationContext operationContext, Timeout timeout, SingleResultCallback<ServerTuple> singleResultCallback) {
            this.originalSelector = serverSelector;
            this.operationContext = operationContext;
            this.timeout = timeout;
            this.callback = singleResultCallback;
        }

        void onResult(@Nullable ServerTuple serverTuple, @Nullable Throwable throwable) {
            try {
                this.callback.onResult(serverTuple, throwable);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }

        Timeout getTimeout() {
            return this.timeout;
        }

        public OperationContext getOperationContext() {
            return this.operationContext;
        }
    }

    private final class WaitQueueHandler
    implements Runnable {
        WaitQueueHandler() {
        }

        @Override
        public void run() {
            Object object;
            while (!BaseCluster.this.isClosed) {
                object = (CountDownLatch)BaseCluster.this.phase.get();
                ClusterDescription clusterDescription = BaseCluster.this.description;
                Timeout timeout = Timeout.infinite();
                boolean bl = false;
                Iterator iterator = BaseCluster.this.waitQueue.iterator();
                while (iterator.hasNext()) {
                    ServerSelectionRequest serverSelectionRequest = (ServerSelectionRequest)iterator.next();
                    if (BaseCluster.this.handleServerSelectionRequest(serverSelectionRequest, (CountDownLatch)object, clusterDescription)) {
                        iterator.remove();
                        continue;
                    }
                    bl = true;
                    timeout = Timeout.earliest(timeout, serverSelectionRequest.getTimeout(), BaseCluster.this.startMinWaitHeartbeatTimeout());
                }
                if (bl) {
                    BaseCluster.this.connect();
                }
                try {
                    timeout.awaitOn((CountDownLatch)object, () -> "ignored");
                }
                catch (MongoInterruptedException mongoInterruptedException) {}
            }
            object = BaseCluster.this.waitQueue.iterator();
            while (object.hasNext()) {
                ((ServerSelectionRequest)object.next()).onResult(null, new MongoClientException("Shutdown in progress"));
                object.remove();
            }
        }
    }
}

