/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.DualMessageSequences;
import com.mongodb.internal.connection.LevelCountingBsonWriter;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.SplittablePayload;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.AbstractBsonWriter;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBinaryWriterSettings;
import org.bson.BsonContextType;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonMaximumSizeExceededException;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BsonOutput;

public final class BsonWriterHelper {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final EncoderContext ENCODER_CONTEXT = EncoderContext.builder().build();

    static void appendElementsToDocument(BsonOutput bsonOutput, int n, @Nullable List<BsonElement> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        try (AppendingBsonWriter appendingBsonWriter = new AppendingBsonWriter(bsonOutput, n);){
            for (BsonElement bsonElement : list) {
                String string = bsonElement.getName();
                BsonValue bsonValue = bsonElement.getValue();
                appendingBsonWriter.writeName(string);
                BsonWriterHelper.encodeUsingRegistry(appendingBsonWriter, bsonValue);
            }
        }
    }

    static void writePayloadArray(BsonWriter bsonWriter, BsonOutput bsonOutput, MessageSettings messageSettings, int n, SplittablePayload splittablePayload, int n2) {
        bsonWriter.writeStartArray(splittablePayload.getPayloadName());
        BsonWriterHelper.writePayload(bsonWriter, bsonOutput, BsonWriterHelper.getDocumentMessageSettings(messageSettings), n, splittablePayload, n2);
        bsonWriter.writeEndArray();
    }

    static void writePayload(BsonWriter bsonWriter, BsonOutput bsonOutput, MessageSettings messageSettings, int n, SplittablePayload splittablePayload, int n2) {
        MessageSettings messageSettings2 = BsonWriterHelper.getPayloadMessageSettings(splittablePayload.getPayloadType(), messageSettings);
        List<BsonDocument> list = splittablePayload.getPayload();
        for (int i = 0; i < list.size() && BsonWriterHelper.writeDocument(bsonWriter, bsonOutput, messageSettings2, list.get(i), n, i + 1, n2); ++i) {
            splittablePayload.setPosition(i + 1);
        }
        if (splittablePayload.getPosition() == 0) {
            throw BsonWriterHelper.createBsonMaximumSizeExceededException(messageSettings2.getMaxDocumentSize());
        }
    }

    static DualMessageSequences.EncodeDocumentsResult writeDocumentsOfDualMessageSequences(DualMessageSequences dualMessageSequences, int n, BsonOutput bsonOutput, BsonOutput bsonOutput2, MessageSettings messageSettings) {
        BsonBinaryWriter bsonBinaryWriter = BsonWriterHelper.createBsonBinaryWriter(bsonOutput, dualMessageSequences.getFirstFieldNameValidator(), null);
        BsonBinaryWriter bsonBinaryWriter2 = BsonWriterHelper.createBsonBinaryWriter(bsonOutput2, dualMessageSequences.getSecondFieldNameValidator(), null);
        int n2 = 1000;
        int n3 = messageSettings.getMaxMessageSize() - (n2 + n);
        int n4 = bsonOutput.getPosition();
        int n5 = bsonOutput2.getPosition();
        int n6 = messageSettings.getMaxBatchCount();
        return dualMessageSequences.encodeDocuments(writeAction -> {
            int n5 = bsonOutput.getPosition();
            int n6 = bsonOutput2.getPosition();
            int n7 = writeAction.doAndGetBatchCount(bsonBinaryWriter, bsonBinaryWriter2);
            Assertions.assertTrue(n7 <= n6);
            int n8 = bsonOutput.getPosition() - n4 + bsonOutput2.getPosition() - n5;
            if (n8 < n3 && n7 < n6) {
                return DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.OK_LIMIT_NOT_REACHED;
            }
            if (n8 > n3) {
                bsonOutput.truncateToPosition(n5);
                bsonOutput2.truncateToPosition(n6);
                if (n7 == 1) {
                    throw BsonWriterHelper.createBsonMaximumSizeExceededException(messageSettings.getMaxDocumentSize());
                }
                return DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.FAIL_LIMIT_EXCEEDED;
            }
            return DualMessageSequences.WritersProviderAndLimitsChecker.WriteResult.OK_LIMIT_REACHED;
        });
    }

    static BsonBinaryWriter createBsonBinaryWriter(BsonOutput bsonOutput, FieldNameValidator fieldNameValidator, @Nullable MessageSettings messageSettings) {
        return new BsonBinaryWriter(new BsonWriterSettings(), messageSettings == null ? new BsonBinaryWriterSettings() : new BsonBinaryWriterSettings(messageSettings.getMaxDocumentSize() + 16384), bsonOutput, fieldNameValidator);
    }

    static void backpatchLength(int n, BsonOutput bsonOutput) {
        int n2 = bsonOutput.getPosition() - n;
        bsonOutput.writeInt32(n, n2);
    }

    private static BsonMaximumSizeExceededException createBsonMaximumSizeExceededException(int n) {
        return new BsonMaximumSizeExceededException(String.format("Payload document size is larger than maximum of %d.", n));
    }

    private static boolean writeDocument(BsonWriter bsonWriter, BsonOutput bsonOutput, MessageSettings messageSettings, BsonDocument bsonDocument, int n, int n2, int n3) {
        int n4 = bsonOutput.getPosition();
        BsonWriterHelper.encodeUsingRegistry(bsonWriter, bsonDocument);
        int n5 = bsonOutput.getPosition() - n;
        int n6 = bsonOutput.getPosition() - n4;
        if (BsonWriterHelper.exceedsLimits(messageSettings, n5, n6, n2) || n2 > 1 && bsonOutput.getPosition() - n > n3) {
            bsonOutput.truncateToPosition(n4);
            return false;
        }
        return true;
    }

    static void encodeUsingRegistry(BsonWriter bsonWriter, BsonValue bsonValue) {
        Codec<?> codec = REGISTRY.get(bsonValue.getClass());
        codec.encode(bsonWriter, bsonValue, ENCODER_CONTEXT);
    }

    private static MessageSettings getPayloadMessageSettings(SplittablePayload.Type type, MessageSettings messageSettings) {
        MessageSettings messageSettings2 = messageSettings;
        if (type != SplittablePayload.Type.INSERT) {
            messageSettings2 = BsonWriterHelper.createMessageSettingsBuilder(messageSettings).maxDocumentSize(messageSettings.getMaxDocumentSize() + 16384).build();
        }
        return messageSettings2;
    }

    private static MessageSettings getDocumentMessageSettings(MessageSettings messageSettings) {
        return BsonWriterHelper.createMessageSettingsBuilder(messageSettings).maxMessageSize(messageSettings.getMaxDocumentSize() + 16384).build();
    }

    private static MessageSettings.Builder createMessageSettingsBuilder(MessageSettings messageSettings) {
        return MessageSettings.builder().maxBatchCount(messageSettings.getMaxBatchCount()).maxMessageSize(messageSettings.getMaxMessageSize()).maxDocumentSize(messageSettings.getMaxDocumentSize()).maxWireVersion(messageSettings.getMaxWireVersion());
    }

    private static boolean exceedsLimits(MessageSettings messageSettings, int n, int n2, int n3) {
        if (n3 > messageSettings.getMaxBatchCount()) {
            return true;
        }
        if (n > messageSettings.getMaxMessageSize()) {
            return true;
        }
        return n2 > messageSettings.getMaxDocumentSize();
    }

    private BsonWriterHelper() {
    }

    private static final class AppendingBsonWriter
    extends LevelCountingBsonWriter
    implements AutoCloseable {
        private static final int INITIAL_LEVEL = 0;

        AppendingBsonWriter(BsonOutput bsonOutput, int n) {
            super(new InternalAppendingBsonBinaryWriter(bsonOutput, n), 0);
        }

        @Override
        public void writeEndDocument() {
            Assertions.assertTrue(this.getCurrentLevel() > 0);
            super.writeEndDocument();
        }

        @Override
        public void close() {
            try (InternalAppendingBsonBinaryWriter internalAppendingBsonBinaryWriter = (InternalAppendingBsonBinaryWriter)this.getBsonWriter();){
                internalAppendingBsonBinaryWriter.writeEndDocument();
            }
        }

        private static final class InternalAppendingBsonBinaryWriter
        extends BsonBinaryWriter {
            InternalAppendingBsonBinaryWriter(BsonOutput bsonOutput, int n) {
                super(bsonOutput);
                int n2 = bsonOutput.getPosition();
                int n3 = 1;
                int n4 = n2 - n3;
                bsonOutput.truncateToPosition(n4);
                this.setState(AbstractBsonWriter.State.NAME);
                this.setContext(new BsonBinaryWriter.Context(null, BsonContextType.DOCUMENT, n));
            }
        }
    }
}

