/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteInsert;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.internal.connection.IndexMap;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class BulkWriteBatchCombiner {
    private final ServerAddress serverAddress;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private int insertedCount;
    private int matchedCount;
    private int deletedCount;
    private int modifiedCount = 0;
    private final Set<BulkWriteUpsert> writeUpserts = new TreeSet<BulkWriteUpsert>(Comparator.comparingInt(BulkWriteUpsert::getIndex));
    private final Set<BulkWriteInsert> writeInserts = new TreeSet<BulkWriteInsert>(Comparator.comparingInt(BulkWriteInsert::getIndex));
    private final Set<BulkWriteError> writeErrors = new TreeSet<BulkWriteError>(Comparator.comparingInt(BulkWriteError::getIndex));
    private final Set<String> errorLabels = new HashSet<String>();
    private final List<WriteConcernError> writeConcernErrors = new ArrayList<WriteConcernError>();

    public BulkWriteBatchCombiner(ServerAddress serverAddress, boolean bl, WriteConcern writeConcern) {
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.ordered = bl;
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
    }

    public void addResult(BulkWriteResult bulkWriteResult) {
        this.insertedCount += bulkWriteResult.getInsertedCount();
        this.matchedCount += bulkWriteResult.getMatchedCount();
        this.deletedCount += bulkWriteResult.getDeletedCount();
        this.modifiedCount += bulkWriteResult.getModifiedCount();
        this.writeUpserts.addAll(bulkWriteResult.getUpserts());
        this.writeInserts.addAll(bulkWriteResult.getInserts());
    }

    public void addErrorResult(MongoBulkWriteException mongoBulkWriteException, IndexMap indexMap) {
        this.addResult(mongoBulkWriteException.getWriteResult());
        this.errorLabels.addAll(mongoBulkWriteException.getErrorLabels());
        this.mergeWriteErrors(mongoBulkWriteException.getWriteErrors(), indexMap);
        this.mergeWriteConcernError(mongoBulkWriteException.getWriteConcernError());
    }

    public void addWriteErrorResult(BulkWriteError bulkWriteError, IndexMap indexMap) {
        Assertions.notNull("writeError", bulkWriteError);
        this.mergeWriteErrors(Collections.singletonList(bulkWriteError), indexMap);
    }

    public void addWriteConcernErrorResult(WriteConcernError writeConcernError) {
        Assertions.notNull("writeConcernError", writeConcernError);
        this.mergeWriteConcernError(writeConcernError);
    }

    public void addErrorResult(List<BulkWriteError> list, WriteConcernError writeConcernError, IndexMap indexMap) {
        this.mergeWriteErrors(list, indexMap);
        this.mergeWriteConcernError(writeConcernError);
    }

    public BulkWriteResult getResult() {
        this.throwOnError();
        return this.createResult();
    }

    public boolean shouldStopSendingMoreBatches() {
        return this.ordered && this.hasWriteErrors();
    }

    public boolean hasErrors() {
        return this.hasWriteErrors() || this.hasWriteConcernErrors();
    }

    @Nullable
    public MongoBulkWriteException getError() {
        if (!this.hasErrors()) {
            return null;
        }
        return this.getErrorNonNullable();
    }

    private MongoBulkWriteException getErrorNonNullable() {
        return new MongoBulkWriteException(this.createResult(), new ArrayList<BulkWriteError>(this.writeErrors), this.writeConcernErrors.isEmpty() ? null : this.writeConcernErrors.get(this.writeConcernErrors.size() - 1), this.serverAddress, this.errorLabels);
    }

    private void mergeWriteConcernError(@Nullable WriteConcernError writeConcernError) {
        if (writeConcernError != null) {
            if (this.writeConcernErrors.isEmpty()) {
                this.writeConcernErrors.add(writeConcernError);
            } else if (!writeConcernError.equals(this.writeConcernErrors.get(this.writeConcernErrors.size() - 1))) {
                this.writeConcernErrors.add(writeConcernError);
            }
        }
    }

    private void mergeWriteErrors(List<BulkWriteError> list, IndexMap indexMap) {
        for (BulkWriteError bulkWriteError : list) {
            this.writeErrors.add(new BulkWriteError(bulkWriteError.getCode(), bulkWriteError.getMessage(), bulkWriteError.getDetails(), indexMap.map(bulkWriteError.getIndex())));
        }
    }

    private void throwOnError() {
        if (this.hasErrors()) {
            throw this.getErrorNonNullable();
        }
    }

    private BulkWriteResult createResult() {
        return this.writeConcern.isAcknowledged() ? BulkWriteResult.acknowledged(this.insertedCount, this.matchedCount, this.deletedCount, this.modifiedCount, new ArrayList<BulkWriteUpsert>(this.writeUpserts), new ArrayList<BulkWriteInsert>(this.writeInserts)) : BulkWriteResult.unacknowledged();
    }

    private boolean hasWriteErrors() {
        return !this.writeErrors.isEmpty();
    }

    private boolean hasWriteConcernErrors() {
        return !this.writeConcernErrors.isEmpty();
    }
}

