/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.ByteBufBsonHelper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.bson.BsonArray;
import org.bson.BsonBinaryReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.ByteBuf;
import org.bson.io.ByteBufferBsonInput;

final class ByteBufBsonArray
extends BsonArray {
    private final ByteBuf byteBuf;
    private static final String READ_ONLY_MESSAGE = "This BsonArray instance is read-only";

    ByteBufBsonArray(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    @Override
    public Iterator<BsonValue> iterator() {
        return new ByteBufBsonArrayIterator();
    }

    @Override
    public List<BsonValue> getValues() {
        ArrayList<BsonValue> arrayList = new ArrayList<BsonValue>();
        for (BsonValue bsonValue : this) {
            arrayList.add(bsonValue);
        }
        return arrayList;
    }

    @Override
    public int size() {
        int n = 0;
        for (BsonValue bsonValue : this) {
            ++n;
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        Iterator<BsonValue> iterator = this.iterator();
        Iterator iterator2 = ((List)object).iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (Objects.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    @Override
    public int hashCode() {
        int n = 1;
        for (BsonValue bsonValue : this) {
            n = 31 * n + (bsonValue == null ? 0 : bsonValue.hashCode());
        }
        return n;
    }

    @Override
    public boolean contains(Object object) {
        for (BsonValue bsonValue : this) {
            if (!Objects.equals(object, bsonValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator<BsonValue> iterator = this.iterator();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = iterator.next();
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.size();
        T[] TArray2 = TArray.length >= n ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
        Iterator<BsonValue> iterator = this.iterator();
        for (int i = 0; i < TArray2.length; ++i) {
            TArray2[i] = iterator.next();
        }
        return TArray2;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public BsonValue get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + n);
        }
        int n2 = 0;
        for (BsonValue bsonValue : this) {
            if (n2++ != n) continue;
            return bsonValue;
        }
        throw new IndexOutOfBoundsException("Index out of range: " + n);
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        for (BsonValue bsonValue : this) {
            if (Objects.equals(object, bsonValue)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        ListIterator<BsonValue> listIterator = this.listIterator(this.size());
        while (listIterator.hasPrevious()) {
            if (!Objects.equals(object, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    @Override
    public ListIterator<BsonValue> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<BsonValue> listIterator(int n) {
        return new ArrayList<BsonValue>(this).listIterator(n);
    }

    @Override
    public List<BsonValue> subList(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        ArrayList<BsonValue> arrayList = new ArrayList<BsonValue>();
        int n3 = 0;
        for (BsonValue bsonValue : this) {
            if (n3 == n2) break;
            if (n3 >= n) {
                arrayList.add(bsonValue);
            }
            ++n3;
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        return arrayList;
    }

    @Override
    public boolean add(BsonValue bsonValue) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    @Override
    public boolean addAll(Collection<? extends BsonValue> collection) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    @Override
    public boolean addAll(int n, Collection<? extends BsonValue> collection) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    @Override
    public BsonValue set(int n, BsonValue bsonValue) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    @Override
    public void add(int n, BsonValue bsonValue) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    @Override
    public BsonValue remove(int n) {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    private class ByteBufBsonArrayIterator
    implements Iterator<BsonValue> {
        private final ByteBuf duplicatedByteBuf;
        private final BsonBinaryReader bsonReader;

        private ByteBufBsonArrayIterator() {
            this.duplicatedByteBuf = ByteBufBsonArray.this.byteBuf.duplicate();
            this.bsonReader = new BsonBinaryReader(new ByteBufferBsonInput(this.duplicatedByteBuf));
            this.bsonReader.readStartDocument();
            this.bsonReader.readBsonType();
        }

        @Override
        public boolean hasNext() {
            return this.bsonReader.getCurrentBsonType() != BsonType.END_OF_DOCUMENT;
        }

        @Override
        public BsonValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.bsonReader.skipName();
            BsonValue bsonValue = ByteBufBsonHelper.readBsonValue(this.duplicatedByteBuf, this.bsonReader);
            this.bsonReader.readBsonType();
            return bsonValue;
        }
    }
}

