/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.ByteBufBsonHelper;
import com.mongodb.lang.Nullable;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.ByteBuf;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DecoderContext;
import org.bson.io.ByteBufferBsonInput;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

final class ByteBufBsonDocument
extends BsonDocument {
    private static final long serialVersionUID = 2L;
    private final transient ByteBuf byteBuf;

    static List<ByteBufBsonDocument> createList(ByteBuf byteBuf) {
        ArrayList<ByteBufBsonDocument> arrayList = new ArrayList<ByteBufBsonDocument>();
        while (byteBuf.hasRemaining()) {
            ByteBufBsonDocument byteBufBsonDocument = ByteBufBsonDocument.createOne(byteBuf);
            arrayList.add(byteBufBsonDocument);
        }
        return arrayList;
    }

    static ByteBufBsonDocument createOne(ByteBuf byteBuf) {
        int n = byteBuf.position();
        int n2 = byteBuf.getInt();
        int n3 = n + n2;
        ByteBuf byteBuf2 = byteBuf.duplicate().position(n).limit(n3);
        byteBuf.position(n3);
        return new ByteBufBsonDocument(byteBuf2);
    }

    @Override
    public String toJson() {
        return this.toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build());
    }

    @Override
    public String toJson(JsonWriterSettings jsonWriterSettings) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter(stringWriter, jsonWriterSettings);
        ByteBuf byteBuf = this.byteBuf.duplicate();
        try {
            BsonBinaryReader bsonBinaryReader = new BsonBinaryReader(new ByteBufferBsonInput(byteBuf));
            try {
                jsonWriter.pipe(bsonBinaryReader);
                String string = stringWriter.toString();
                bsonBinaryReader.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    bsonBinaryReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            byteBuf.release();
        }
    }

    @Override
    public BsonBinaryReader asBsonReader() {
        return new BsonBinaryReader(new ByteBufferBsonInput(this.byteBuf.duplicate()));
    }

    @Override
    public BsonDocument clone() {
        byte[] byArray = new byte[this.byteBuf.remaining()];
        this.byteBuf.get(this.byteBuf.position(), byArray);
        return new RawBsonDocument(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    <T> T findInDocument(Finder<T> finder) {
        ByteBuf byteBuf = this.byteBuf.duplicate();
        try (BsonBinaryReader bsonBinaryReader = new BsonBinaryReader(new ByteBufferBsonInput(byteBuf));){
            bsonBinaryReader.readStartDocument();
            while (bsonBinaryReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                T t = finder.find(byteBuf, bsonBinaryReader);
                if (t == null) continue;
                T t2 = t;
                return t2;
            }
            bsonBinaryReader.readEndDocument();
            return finder.notFound();
        }
        finally {
            byteBuf.release();
        }
    }

    BsonDocument toBaseBsonDocument() {
        ByteBuf byteBuf = this.byteBuf.duplicate();
        try {
            BsonBinaryReader bsonBinaryReader = new BsonBinaryReader(new ByteBufferBsonInput(byteBuf));
            try {
                BsonDocument bsonDocument = new BsonDocumentCodec().decode(bsonBinaryReader, DecoderContext.builder().build());
                bsonBinaryReader.close();
                return bsonDocument;
            }
            catch (Throwable throwable) {
                try {
                    bsonBinaryReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            byteBuf.release();
        }
    }

    ByteBufBsonDocument(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    @Override
    public BsonValue put(String string, BsonValue bsonValue) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    @Override
    public BsonDocument append(String string, BsonValue bsonValue) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    @Override
    public void putAll(Map<? extends String, ? extends BsonValue> map) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    @Override
    public BsonValue remove(Object object) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    @Override
    public boolean isEmpty() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(ByteBuf byteBuf, BsonBinaryReader bsonBinaryReader) {
                return false;
            }

            @Override
            public Boolean notFound() {
                return true;
            }
        }));
    }

    @Override
    public int size() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<Integer>(){
            private int size;

            @Override
            @Nullable
            public Integer find(ByteBuf byteBuf, BsonBinaryReader bsonBinaryReader) {
                ++this.size;
                bsonBinaryReader.readName();
                bsonBinaryReader.skipValue();
                return null;
            }

            @Override
            public Integer notFound() {
                return this.size;
            }
        }));
    }

    @Override
    public Set<Map.Entry<String, BsonValue>> entrySet() {
        return new ByteBufBsonDocumentEntrySet();
    }

    @Override
    public Collection<BsonValue> values() {
        return new ByteBufBsonDocumentValuesCollection();
    }

    @Override
    public Set<String> keySet() {
        return new ByteBufBsonDocumentKeySet();
    }

    @Override
    public boolean containsKey(final Object object) {
        if (object == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        Boolean bl = this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(ByteBuf byteBuf, BsonBinaryReader bsonBinaryReader) {
                if (bsonBinaryReader.readName().equals(object)) {
                    return true;
                }
                bsonBinaryReader.skipValue();
                return null;
            }

            @Override
            public Boolean notFound() {
                return false;
            }
        });
        return bl != null ? bl : false;
    }

    @Override
    public boolean containsValue(final Object object) {
        Boolean bl = this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(ByteBuf byteBuf, BsonBinaryReader bsonBinaryReader) {
                bsonBinaryReader.skipName();
                if (ByteBufBsonHelper.readBsonValue(byteBuf, bsonBinaryReader).equals(object)) {
                    return true;
                }
                return null;
            }

            @Override
            public Boolean notFound() {
                return false;
            }
        });
        return bl != null ? bl : false;
    }

    @Override
    @Nullable
    public BsonValue get(final Object object) {
        Assertions.notNull("key", object);
        return this.findInDocument(new Finder<BsonValue>(){

            @Override
            public BsonValue find(ByteBuf byteBuf, BsonBinaryReader bsonBinaryReader) {
                if (bsonBinaryReader.readName().equals(object)) {
                    return ByteBufBsonHelper.readBsonValue(byteBuf, bsonBinaryReader);
                }
                bsonBinaryReader.skipValue();
                return null;
            }

            @Override
            @Nullable
            public BsonValue notFound() {
                return null;
            }
        });
    }

    @Override
    public String getFirstKey() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<String>(){

            @Override
            public String find(ByteBuf byteBuf, BsonBinaryReader bsonBinaryReader) {
                return bsonBinaryReader.readName();
            }

            @Override
            public String notFound() {
                throw new NoSuchElementException();
            }
        }));
    }

    private Object writeReplace() {
        return this.toBaseBsonDocument();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static interface Finder<T> {
        @Nullable
        public T find(ByteBuf var1, BsonBinaryReader var2);

        @Nullable
        public T notFound();
    }

    private class ByteBufBsonDocumentEntrySet
    extends AbstractSet<Map.Entry<String, BsonValue>> {
        private ByteBufBsonDocumentEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, BsonValue>> iterator() {
            return new Iterator<Map.Entry<String, BsonValue>>(){
                private final ByteBuf duplicatedByteBuf;
                private final BsonBinaryReader bsonReader;
                {
                    this.duplicatedByteBuf = ByteBufBsonDocument.this.byteBuf.duplicate();
                    this.bsonReader = new BsonBinaryReader(new ByteBufferBsonInput(this.duplicatedByteBuf));
                    this.bsonReader.readStartDocument();
                    this.bsonReader.readBsonType();
                }

                @Override
                public boolean hasNext() {
                    return this.bsonReader.getCurrentBsonType() != BsonType.END_OF_DOCUMENT;
                }

                @Override
                public Map.Entry<String, BsonValue> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    String string = this.bsonReader.readName();
                    BsonValue bsonValue = ByteBufBsonHelper.readBsonValue(this.duplicatedByteBuf, this.bsonReader);
                    this.bsonReader.readBsonType();
                    return new AbstractMap.SimpleEntry<String, BsonValue>(string, bsonValue);
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            return ByteBufBsonDocument.this.size();
        }
    }

    private class ByteBufBsonDocumentValuesCollection
    extends AbstractCollection<BsonValue> {
        private final Set<Map.Entry<String, BsonValue>> entrySet;

        private ByteBufBsonDocumentValuesCollection() {
            this.entrySet = new ByteBufBsonDocumentEntrySet();
        }

        @Override
        public Iterator<BsonValue> iterator() {
            final Iterator<Map.Entry<String, BsonValue>> iterator = this.entrySet.iterator();
            return new Iterator<BsonValue>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public BsonValue next() {
                    return (BsonValue)((Map.Entry)iterator.next()).getValue();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }
    }

    private class ByteBufBsonDocumentKeySet
    extends AbstractSet<String> {
        private final Set<Map.Entry<String, BsonValue>> entrySet;

        private ByteBufBsonDocumentKeySet() {
            this.entrySet = new ByteBufBsonDocumentEntrySet();
        }

        @Override
        public Iterator<String> iterator() {
            final Iterator<Map.Entry<String, BsonValue>> iterator = this.entrySet.iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public String next() {
                    return (String)((Map.Entry)iterator.next()).getKey();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet.isEmpty();
        }

        @Override
        public int size() {
            return this.entrySet.size();
        }
    }
}

