/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.ByteBufBsonArray;
import com.mongodb.internal.connection.ByteBufBsonDocument;
import org.bson.BsonBinaryReader;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.ByteBuf;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DecoderContext;

final class ByteBufBsonHelper {
    static BsonValue readBsonValue(ByteBuf byteBuf, BsonBinaryReader bsonBinaryReader) {
        BsonValue bsonValue;
        switch (bsonBinaryReader.getCurrentBsonType()) {
            case DOCUMENT: {
                ByteBuf byteBuf2 = byteBuf.duplicate();
                bsonValue = new ByteBufBsonDocument(byteBuf2);
                bsonBinaryReader.skipValue();
                break;
            }
            case ARRAY: {
                ByteBuf byteBuf3 = byteBuf.duplicate();
                bsonValue = new ByteBufBsonArray(byteBuf3);
                bsonBinaryReader.skipValue();
                break;
            }
            case INT32: {
                bsonValue = new BsonInt32(bsonBinaryReader.readInt32());
                break;
            }
            case INT64: {
                bsonValue = new BsonInt64(bsonBinaryReader.readInt64());
                break;
            }
            case DOUBLE: {
                bsonValue = new BsonDouble(bsonBinaryReader.readDouble());
                break;
            }
            case DECIMAL128: {
                bsonValue = new BsonDecimal128(bsonBinaryReader.readDecimal128());
                break;
            }
            case DATE_TIME: {
                bsonValue = new BsonDateTime(bsonBinaryReader.readDateTime());
                break;
            }
            case TIMESTAMP: {
                bsonValue = bsonBinaryReader.readTimestamp();
                break;
            }
            case BOOLEAN: {
                bsonValue = new BsonBoolean(bsonBinaryReader.readBoolean());
                break;
            }
            case OBJECT_ID: {
                bsonValue = new BsonObjectId(bsonBinaryReader.readObjectId());
                break;
            }
            case STRING: {
                bsonValue = new BsonString(bsonBinaryReader.readString());
                break;
            }
            case BINARY: {
                bsonValue = bsonBinaryReader.readBinaryData();
                break;
            }
            case SYMBOL: {
                bsonValue = new BsonSymbol(bsonBinaryReader.readSymbol());
                break;
            }
            case UNDEFINED: {
                bsonBinaryReader.readUndefined();
                bsonValue = new BsonUndefined();
                break;
            }
            case REGULAR_EXPRESSION: {
                bsonValue = bsonBinaryReader.readRegularExpression();
                break;
            }
            case DB_POINTER: {
                bsonValue = bsonBinaryReader.readDBPointer();
                break;
            }
            case JAVASCRIPT: {
                bsonValue = new BsonJavaScript(bsonBinaryReader.readJavaScript());
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                String string = bsonBinaryReader.readJavaScriptWithScope();
                BsonDocument bsonDocument = new BsonDocumentCodec().decode(bsonBinaryReader, DecoderContext.builder().build());
                bsonValue = new BsonJavaScriptWithScope(string, bsonDocument);
                break;
            }
            case MIN_KEY: {
                bsonBinaryReader.readMinKey();
                bsonValue = new BsonMinKey();
                break;
            }
            case MAX_KEY: {
                bsonBinaryReader.readMaxKey();
                bsonValue = new BsonMaxKey();
                break;
            }
            case NULL: {
                bsonBinaryReader.readNull();
                bsonValue = new BsonNull();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected BSON type: " + (Object)((Object)bsonBinaryReader.getCurrentBsonType()));
            }
        }
        return bsonValue;
    }

    private ByteBufBsonHelper() {
    }
}

