/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.BufferProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.bson.ByteBuf;
import org.bson.io.OutputBuffer;

public class ByteBufferBsonOutput
extends OutputBuffer {
    private static final int MAX_SHIFT = 31;
    private static final int INITIAL_SHIFT = 10;
    public static final int INITIAL_BUFFER_SIZE = 1024;
    public static final int MAX_BUFFER_SIZE = 0x1000000;
    private final BufferProvider bufferProvider;
    private final List<ByteBuf> bufferList = new ArrayList<ByteBuf>();
    private int curBufferIndex = 0;
    private int position = 0;
    private boolean closed;

    public ByteBufferBsonOutput(BufferProvider bufferProvider) {
        this.bufferProvider = Assertions.notNull("bufferProvider", bufferProvider);
    }

    public Branch branch() {
        return new Branch(this);
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) {
        this.ensureOpen();
        int n3 = n;
        int n4 = n2;
        while (n4 > 0) {
            ByteBuf byteBuf = this.getCurrentByteBuffer();
            int n5 = Math.min(byteBuf.remaining(), n4);
            byteBuf.put(byArray, n3, n5);
            n4 -= n5;
            n3 += n5;
        }
        this.position += n2;
    }

    @Override
    public void writeByte(int n) {
        this.ensureOpen();
        this.getCurrentByteBuffer().put((byte)n);
        ++this.position;
    }

    private ByteBuf getCurrentByteBuffer() {
        ByteBuf byteBuf = this.getByteBufferAtIndex(this.curBufferIndex);
        if (byteBuf.hasRemaining()) {
            return byteBuf;
        }
        ++this.curBufferIndex;
        return this.getByteBufferAtIndex(this.curBufferIndex);
    }

    private ByteBuf getByteBufferAtIndex(int n) {
        if (this.bufferList.size() < n + 1) {
            this.bufferList.add(this.bufferProvider.getBuffer(n >= 21 ? 0x1000000 : Math.min(1024 << n, 0x1000000)));
        }
        return this.bufferList.get(n);
    }

    @Override
    public int getPosition() {
        this.ensureOpen();
        return this.position;
    }

    @Override
    public int getSize() {
        this.ensureOpen();
        return this.position;
    }

    @Override
    protected void write(int n, int n2) {
        this.ensureOpen();
        if (n < 0) {
            throw new IllegalArgumentException(String.format("position must be >= 0 but was %d", n));
        }
        if (n > this.position - 1) {
            throw new IllegalArgumentException(String.format("position must be <= %d but was %d", this.position - 1, n));
        }
        BufferPositionPair bufferPositionPair = this.getBufferPositionPair(n);
        ByteBuf byteBuf = this.getByteBufferAtIndex(bufferPositionPair.bufferIndex);
        byteBuf.put(bufferPositionPair.position++, (byte)n2);
    }

    @Override
    public List<ByteBuf> getByteBuffers() {
        this.ensureOpen();
        ArrayList<ByteBuf> arrayList = new ArrayList<ByteBuf>(this.bufferList.size());
        for (ByteBuf byteBuf : this.bufferList) {
            arrayList.add(byteBuf.duplicate().order(ByteOrder.LITTLE_ENDIAN).flip());
        }
        return arrayList;
    }

    @Override
    public int pipe(OutputStream outputStream) throws IOException {
        this.ensureOpen();
        byte[] byArray = new byte[1024];
        int n = 0;
        for (ByteBuf byteBuf : this.getByteBuffers()) {
            ByteBuf byteBuf2 = byteBuf.duplicate();
            while (byteBuf2.hasRemaining()) {
                int n2 = Math.min(byteBuf2.remaining(), byArray.length);
                byteBuf2.get(byArray, 0, n2);
                outputStream.write(byArray, 0, n2);
            }
            n += byteBuf2.limit();
        }
        return n;
    }

    @Override
    public void truncateToPosition(int n) {
        this.ensureOpen();
        if (n == this.position) {
            return;
        }
        if (n > this.position || n < 0) {
            throw new IllegalArgumentException();
        }
        BufferPositionPair bufferPositionPair = this.getBufferPositionPair(n);
        this.bufferList.get(bufferPositionPair.bufferIndex).position(bufferPositionPair.position);
        while (this.bufferList.size() > bufferPositionPair.bufferIndex + 1) {
            ByteBuf byteBuf = this.bufferList.remove(this.bufferList.size() - 1);
            byteBuf.release();
        }
        this.curBufferIndex = bufferPositionPair.bufferIndex;
        this.position = n;
    }

    @Override
    public final void flush() throws IOException {
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            for (ByteBuf byteBuf : this.bufferList) {
                byteBuf.release();
            }
            this.bufferList.clear();
            this.closed = true;
        }
    }

    private BufferPositionPair getBufferPositionPair(int n) {
        int n2 = n;
        int n3 = 0;
        int n4 = this.bufferList.get(n3).position();
        int n5 = 0;
        while (n5 + n4 <= n) {
            n5 += n4;
            n2 -= n4;
            n4 = this.bufferList.get(++n3).position();
        }
        return new BufferPositionPair(n3, n2);
    }

    private void ensureOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("The output is closed");
        }
    }

    boolean isOpen() {
        return !this.closed;
    }

    private void merge(ByteBufferBsonOutput byteBufferBsonOutput) {
        Assertions.assertTrue(byteBufferBsonOutput instanceof Branch);
        byteBufferBsonOutput.bufferList.forEach(ByteBuf::retain);
        this.bufferList.addAll(byteBufferBsonOutput.bufferList);
        this.curBufferIndex += byteBufferBsonOutput.curBufferIndex + 1;
        this.position += byteBufferBsonOutput.position;
    }

    public static final class Branch
    extends ByteBufferBsonOutput {
        private final ByteBufferBsonOutput parent;

        private Branch(ByteBufferBsonOutput byteBufferBsonOutput) {
            super(byteBufferBsonOutput.bufferProvider);
            this.parent = byteBufferBsonOutput;
        }

        @Override
        public void close() {
            if (this.isOpen()) {
                try {
                    Assertions.assertTrue(this.parent.isOpen());
                    this.parent.merge((ByteBufferBsonOutput)this);
                }
                finally {
                    super.close();
                }
            }
        }
    }

    private static final class BufferPositionPair {
        private final int bufferIndex;
        private int position;

        BufferPositionPair(int n, int n2) {
            this.bufferIndex = n;
            this.position = n2;
        }
    }
}

