/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoDriverInformation;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.FaasEnvironment;
import com.mongodb.lang.Nullable;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;

public final class ClientMetadataHelper {
    private static final String SEPARATOR = "|";
    private static final int MAXIMUM_CLIENT_METADATA_ENCODED_SIZE = 512;

    static String getOperatingSystemType(String string) {
        if (ClientMetadataHelper.nameStartsWith(string, "linux")) {
            return "Linux";
        }
        if (ClientMetadataHelper.nameStartsWith(string, "mac")) {
            return "Darwin";
        }
        if (ClientMetadataHelper.nameStartsWith(string, "windows")) {
            return "Windows";
        }
        if (ClientMetadataHelper.nameStartsWith(string, "hp-ux", "aix", "irix", "solaris", "sunos")) {
            return "Unix";
        }
        return "unknown";
    }

    private static String getOperatingSystemName() {
        return System.getProperty("os.name", "unknown");
    }

    private static boolean nameStartsWith(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.toLowerCase().startsWith(string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static BsonDocument createClientMetadataDocument(@Nullable String string, @Nullable MongoDriverInformation mongoDriverInformation) {
        if (string != null) {
            Assertions.isTrueArgument("applicationName UTF-8 encoding length <= 128", string.getBytes(StandardCharsets.UTF_8).length <= 128);
        }
        BsonDocument bsonDocument2 = new BsonDocument();
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "application.name", string));
        MongoDriverInformation mongoDriverInformation2 = ClientMetadataHelper.getDriverInformation(null);
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> {
            ClientMetadataHelper.putAtPath(bsonDocument, "driver.name", ClientMetadataHelper.listToString(mongoDriverInformation2.getDriverNames()));
            ClientMetadataHelper.putAtPath(bsonDocument, "driver.version", ClientMetadataHelper.listToString(mongoDriverInformation2.getDriverVersions()));
        });
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "os.type", ClientMetadataHelper.getOperatingSystemType(ClientMetadataHelper.getOperatingSystemName())));
        MongoDriverInformation mongoDriverInformation3 = ClientMetadataHelper.getDriverInformation(mongoDriverInformation);
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> {
            ClientMetadataHelper.putAtPath(bsonDocument, "driver.name", ClientMetadataHelper.listToString(mongoDriverInformation3.getDriverNames()));
            ClientMetadataHelper.putAtPath(bsonDocument, "driver.version", ClientMetadataHelper.listToString(mongoDriverInformation3.getDriverVersions()));
        });
        FaasEnvironment faasEnvironment = FaasEnvironment.getFaasEnvironment();
        ContainerRuntime containerRuntime = ContainerRuntime.determineExecutionContainer();
        Orchestrator orchestrator = Orchestrator.determineExecutionOrchestrator();
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "platform", ClientMetadataHelper.listToString(mongoDriverInformation2.getDriverPlatforms())));
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "platform", ClientMetadataHelper.listToString(mongoDriverInformation3.getDriverPlatforms())));
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "os.name", ClientMetadataHelper.getOperatingSystemName()));
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "os.architecture", System.getProperty("os.arch", "unknown")));
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "os.version", System.getProperty("os.version", "unknown")));
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "env.name", faasEnvironment.getName()));
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "env.timeout_sec", faasEnvironment.getTimeoutSec()));
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "env.memory_mb", faasEnvironment.getMemoryMb()));
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "env.region", faasEnvironment.getRegion()));
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "env.container.runtime", containerRuntime.getName()));
        ClientMetadataHelper.tryWithLimit(bsonDocument2, bsonDocument -> ClientMetadataHelper.putAtPath(bsonDocument, "env.container.orchestrator", orchestrator.getName()));
        return bsonDocument2;
    }

    private static void putAtPath(BsonDocument bsonDocument, String string, @Nullable String string2) {
        if (string2 == null) {
            return;
        }
        ClientMetadataHelper.putAtPath(bsonDocument, string, new BsonString(string2));
    }

    private static void putAtPath(BsonDocument bsonDocument, String string, @Nullable Integer n) {
        if (n == null) {
            return;
        }
        ClientMetadataHelper.putAtPath(bsonDocument, string, new BsonInt32(n));
    }

    private static void putAtPath(BsonDocument bsonDocument, String string, @Nullable BsonValue bsonValue) {
        if (bsonValue == null) {
            return;
        }
        String[] stringArray = string.split("\\.", 2);
        String string2 = stringArray[0];
        if (stringArray.length == 1) {
            bsonDocument.append(string2, bsonValue);
        } else {
            BsonDocument bsonDocument2;
            if (bsonDocument.containsKey(string2)) {
                bsonDocument2 = bsonDocument.getDocument(string2);
            } else {
                bsonDocument2 = new BsonDocument();
                bsonDocument.append(string2, bsonDocument2);
            }
            String string3 = stringArray[1];
            ClientMetadataHelper.putAtPath(bsonDocument2, string3, bsonValue);
        }
    }

    private static void tryWithLimit(BsonDocument bsonDocument, Consumer<BsonDocument> consumer) {
        try {
            BsonDocument bsonDocument2 = bsonDocument.clone();
            consumer.accept(bsonDocument2);
            if (!ClientMetadataHelper.clientMetadataDocumentTooLarge(bsonDocument2)) {
                consumer.accept(bsonDocument);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean clientMetadataDocumentTooLarge(BsonDocument bsonDocument) {
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer(512);
        new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter(basicOutputBuffer), bsonDocument, EncoderContext.builder().build());
        return basicOutputBuffer.getPosition() > 512;
    }

    static MongoDriverInformation getDriverInformation(@Nullable MongoDriverInformation mongoDriverInformation) {
        MongoDriverInformation.Builder builder = mongoDriverInformation != null ? MongoDriverInformation.builder(mongoDriverInformation) : MongoDriverInformation.builder();
        return builder.driverName("mongo-java-driver").driverVersion("5.4.0").driverPlatform(String.format("Java/%s/%s", System.getProperty("java.vendor", "unknown-vendor"), System.getProperty("java.runtime.version", "unknown-version"))).build();
    }

    private static String listToString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (String string : list) {
            if (n > 0) {
                stringBuilder.append(SEPARATOR);
            }
            stringBuilder.append(string);
            ++n;
        }
        return stringBuilder.toString();
    }

    private ClientMetadataHelper() {
    }

    public static enum ContainerRuntime {
        DOCKER("docker"){

            @Override
            boolean isCurrentRuntimeContainer() {
                try {
                    return Files.exists(Paths.get(File.separator + ".dockerenv", new String[0]), new LinkOption[0]);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        ,
        UNKNOWN(null);

        @Nullable
        private final String name;

        private ContainerRuntime(String string2) {
            this.name = string2;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        boolean isCurrentRuntimeContainer() {
            return false;
        }

        static ContainerRuntime determineExecutionContainer() {
            for (ContainerRuntime containerRuntime : ContainerRuntime.values()) {
                if (!containerRuntime.isCurrentRuntimeContainer()) continue;
                return containerRuntime;
            }
            return UNKNOWN;
        }
    }

    private static enum Orchestrator {
        K8S("kubernetes"){

            @Override
            boolean isCurrentOrchestrator() {
                return FaasEnvironment.getEnv("KUBERNETES_SERVICE_HOST") != null;
            }
        }
        ,
        UNKNOWN(null);

        @Nullable
        private final String name;

        private Orchestrator(String string2) {
            this.name = string2;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        boolean isCurrentOrchestrator() {
            return false;
        }

        static Orchestrator determineExecutionOrchestrator() {
            for (Orchestrator orchestrator : Orchestrator.values()) {
                if (!orchestrator.isCurrentOrchestrator()) continue;
                return orchestrator;
            }
            return UNKNOWN;
        }
    }
}

