/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.ReadConcern;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

public final class ClusterClockAdvancingSessionContext
implements SessionContext {
    private final SessionContext wrapped;
    private final ClusterClock clusterClock;

    public ClusterClockAdvancingSessionContext(SessionContext sessionContext, ClusterClock clusterClock) {
        this.wrapped = sessionContext;
        this.clusterClock = clusterClock;
    }

    @Override
    public boolean hasSession() {
        return this.wrapped.hasSession();
    }

    @Override
    public boolean isImplicitSession() {
        return this.wrapped.isImplicitSession();
    }

    @Override
    public BsonDocument getSessionId() {
        return this.wrapped.getSessionId();
    }

    @Override
    public boolean isCausallyConsistent() {
        return this.wrapped.isCausallyConsistent();
    }

    @Override
    public long getTransactionNumber() {
        return this.wrapped.getTransactionNumber();
    }

    @Override
    public long advanceTransactionNumber() {
        return this.wrapped.advanceTransactionNumber();
    }

    @Override
    public boolean notifyMessageSent() {
        return this.wrapped.notifyMessageSent();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.wrapped.getOperationTime();
    }

    @Override
    public void advanceOperationTime(@Nullable BsonTimestamp bsonTimestamp) {
        this.wrapped.advanceOperationTime(bsonTimestamp);
    }

    @Override
    public BsonDocument getClusterTime() {
        return this.clusterClock.greaterOf(this.wrapped.getClusterTime());
    }

    @Override
    public void advanceClusterTime(@Nullable BsonDocument bsonDocument) {
        this.wrapped.advanceClusterTime(bsonDocument);
        this.clusterClock.advance(bsonDocument);
    }

    @Override
    public boolean isSnapshot() {
        return this.wrapped.isSnapshot();
    }

    @Override
    public void setSnapshotTimestamp(@Nullable BsonTimestamp bsonTimestamp) {
        this.wrapped.setSnapshotTimestamp(bsonTimestamp);
    }

    @Override
    @Nullable
    public BsonTimestamp getSnapshotTimestamp() {
        return this.wrapped.getSnapshotTimestamp();
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.wrapped.hasActiveTransaction();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    @Override
    public void setRecoveryToken(BsonDocument bsonDocument) {
        this.wrapped.setRecoveryToken(bsonDocument);
    }

    @Override
    public void clearTransactionContext() {
        this.wrapped.clearTransactionContext();
    }

    @Override
    public void markSessionDirty() {
        this.wrapped.markSessionDirty();
    }

    @Override
    public boolean isSessionMarkedDirty() {
        return this.wrapped.isSessionMarkedDirty();
    }
}

