/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.MongoServerException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Locale;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;

public final class CommandHelper {
    static final String HELLO = "hello";
    static final String LEGACY_HELLO = "isMaster";
    static final String LEGACY_HELLO_LOWER = "isMaster".toLowerCase(Locale.ROOT);

    static BsonDocument executeCommand(String string, BsonDocument bsonDocument, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection, OperationContext operationContext) {
        return CommandHelper.sendAndReceive(string, bsonDocument, clusterConnectionMode, serverApi, internalConnection, operationContext);
    }

    static BsonDocument executeCommandWithoutCheckingForFailure(String string, BsonDocument bsonDocument, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection, OperationContext operationContext) {
        try {
            return CommandHelper.executeCommand(string, bsonDocument, clusterConnectionMode, serverApi, internalConnection, operationContext);
        }
        catch (MongoServerException mongoServerException) {
            return new BsonDocument();
        }
    }

    static void executeCommandAsync(String string, BsonDocument bsonDocument2, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection, OperationContext operationContext, SingleResultCallback<BsonDocument> singleResultCallback) {
        internalConnection.sendAndReceiveAsync(CommandHelper.getCommandMessage(string, bsonDocument2, internalConnection, clusterConnectionMode, serverApi), new BsonDocumentCodec(), operationContext, (bsonDocument, throwable) -> {
            if (throwable != null) {
                singleResultCallback.onResult(null, throwable);
            } else {
                singleResultCallback.onResult((BsonDocument)bsonDocument, null);
            }
        });
    }

    static boolean isCommandOk(BsonDocument bsonDocument) {
        if (!bsonDocument.containsKey("ok")) {
            return false;
        }
        BsonValue bsonValue = bsonDocument.get("ok");
        if (bsonValue.isBoolean()) {
            return bsonValue.asBoolean().getValue();
        }
        if (bsonValue.isNumber()) {
            return bsonValue.asNumber().intValue() == 1;
        }
        return false;
    }

    private static BsonDocument sendAndReceive(String string, BsonDocument bsonDocument, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection, OperationContext operationContext) {
        return Assertions.assertNotNull(internalConnection.sendAndReceive(CommandHelper.getCommandMessage(string, bsonDocument, internalConnection, clusterConnectionMode, serverApi), new BsonDocumentCodec(), operationContext));
    }

    private static CommandMessage getCommandMessage(String string, BsonDocument bsonDocument, InternalConnection internalConnection, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        return new CommandMessage(new MongoNamespace(string, "$cmd"), bsonDocument, NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), MessageSettings.builder().maxWireVersion(internalConnection.getDescription().getMaxWireVersion()).serverType(internalConnection.getDescription().getServerType()).cryptd(internalConnection.getInitialServerDescription().isCryptd()).build(), clusterConnectionMode, serverApi);
    }

    public static void applyMaxTimeMS(TimeoutContext timeoutContext, BsonDocument bsonDocument) {
        if (!timeoutContext.hasTimeoutMS()) {
            bsonDocument.append("maxTimeMS", new BsonInt64(timeoutContext.getTimeoutSettings().getMaxTimeMS()));
            timeoutContext.disableMaxTimeOverride();
        }
    }

    private CommandHelper() {
    }
}

