/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.connection.BsonWriterHelper;
import com.mongodb.internal.connection.ByteBufBsonDocument;
import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.CompositeByteBuf;
import com.mongodb.internal.connection.DualMessageSequences;
import com.mongodb.internal.connection.MessageSequences;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.OpCode;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ReadConcernHelper;
import com.mongodb.internal.connection.RequestMessage;
import com.mongodb.internal.connection.SplittablePayload;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.ByteBuf;
import org.bson.FieldNameValidator;

public final class CommandMessage
extends RequestMessage {
    private static final byte PAYLOAD_TYPE_0_DOCUMENT = 0;
    private static final byte PAYLOAD_TYPE_1_DOCUMENT_SEQUENCE = 1;
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final FieldNameValidator commandFieldNameValidator;
    private final ReadPreference readPreference;
    private final boolean exhaustAllowed;
    private final MessageSequences sequences;
    private final boolean responseExpected;
    @Nullable
    private Boolean dualMessageSequencesRequireResponse;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ServerApi serverApi;

    CommandMessage(MongoNamespace mongoNamespace, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, ReadPreference readPreference, MessageSettings messageSettings, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this(mongoNamespace, bsonDocument, fieldNameValidator, readPreference, messageSettings, true, MessageSequences.EmptyMessageSequences.INSTANCE, clusterConnectionMode, serverApi);
    }

    CommandMessage(MongoNamespace mongoNamespace, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, ReadPreference readPreference, MessageSettings messageSettings, boolean bl, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this(mongoNamespace, bsonDocument, fieldNameValidator, readPreference, messageSettings, true, bl, MessageSequences.EmptyMessageSequences.INSTANCE, clusterConnectionMode, serverApi);
    }

    CommandMessage(MongoNamespace mongoNamespace, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, ReadPreference readPreference, MessageSettings messageSettings, boolean bl, MessageSequences messageSequences, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this(mongoNamespace, bsonDocument, fieldNameValidator, readPreference, messageSettings, bl, false, messageSequences, clusterConnectionMode, serverApi);
    }

    CommandMessage(MongoNamespace mongoNamespace, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, ReadPreference readPreference, MessageSettings messageSettings, boolean bl, boolean bl2, MessageSequences messageSequences, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(mongoNamespace.getFullName(), CommandMessage.getOpCode(messageSettings, clusterConnectionMode, serverApi), messageSettings);
        this.namespace = mongoNamespace;
        this.command = bsonDocument;
        this.commandFieldNameValidator = fieldNameValidator;
        this.readPreference = readPreference;
        this.responseExpected = bl;
        this.dualMessageSequencesRequireResponse = null;
        this.exhaustAllowed = bl2;
        this.sequences = messageSequences;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
        Assertions.assertTrue(this.useOpMsg() || bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BsonDocument getCommandDocument(ByteBufferBsonOutput byteBufferBsonOutput) {
        List<ByteBuf> list = byteBufferBsonOutput.getByteBuffers();
        try {
            ByteBufBsonDocument byteBufBsonDocument;
            CompositeByteBuf compositeByteBuf;
            block12: {
                compositeByteBuf = new CompositeByteBuf(list);
                try {
                    compositeByteBuf.position(this.getEncodingMetadata().getFirstDocumentPosition());
                    byteBufBsonDocument = ByteBufBsonDocument.createOne(compositeByteBuf);
                    if (!compositeByteBuf.hasRemaining()) break block12;
                    BsonDocument bsonDocument = byteBufBsonDocument.toBaseBsonDocument();
                    while (compositeByteBuf.hasRemaining()) {
                        compositeByteBuf.position(compositeByteBuf.position() + 1);
                        int n = compositeByteBuf.position();
                        int n2 = compositeByteBuf.getInt();
                        int n3 = n + n2;
                        String string = this.getSequenceIdentifier(compositeByteBuf);
                        Assertions.assertFalse(string.contains("."));
                        ByteBuf byteBuf = compositeByteBuf.duplicate().limit(n3);
                        try {
                            bsonDocument.append(string, new BsonArray(ByteBufBsonDocument.createList(byteBuf)));
                        }
                        finally {
                            byteBuf.release();
                        }
                        compositeByteBuf.position(n3);
                    }
                    BsonDocument bsonDocument2 = bsonDocument;
                    compositeByteBuf.release();
                    return bsonDocument2;
                }
                catch (Throwable throwable) {
                    compositeByteBuf.release();
                    throw throwable;
                }
            }
            ByteBufBsonDocument byteBufBsonDocument2 = byteBufBsonDocument;
            compositeByteBuf.release();
            return byteBufBsonDocument2;
        }
        finally {
            list.forEach(ByteBuf::release);
        }
    }

    private String getSequenceIdentifier(ByteBuf byteBuf) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte by = byteBuf.get();
        while (by != 0) {
            byteArrayOutputStream.write(by);
            by = byteBuf.get();
        }
        try {
            return byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MongoInternalException("Unexpected exception", unsupportedEncodingException);
        }
    }

    boolean isResponseExpected() {
        if (this.responseExpected) {
            return true;
        }
        if (this.sequences instanceof SplittablePayload) {
            SplittablePayload splittablePayload = (SplittablePayload)this.sequences;
            return splittablePayload.isOrdered() && splittablePayload.hasAnotherSplit();
        }
        if (this.sequences instanceof DualMessageSequences) {
            return Assertions.assertNotNull(this.dualMessageSequencesRequireResponse);
        }
        if (!(this.sequences instanceof MessageSequences.EmptyMessageSequences)) {
            Assertions.fail(this.sequences.toString());
        }
        return false;
    }

    MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(ByteBufferBsonOutput byteBufferBsonOutput, OperationContext operationContext) {
        int n = this.useOpMsg() ? this.writeOpMsg(byteBufferBsonOutput, operationContext) : this.writeOpQuery(byteBufferBsonOutput);
        return new RequestMessage.EncodingMetadata(n);
    }

    private int writeOpMsg(ByteBufferBsonOutput byteBufferBsonOutput, OperationContext operationContext) {
        int n;
        int n2;
        block35: {
            int n3 = byteBufferBsonOutput.getPosition() - 16;
            n2 = byteBufferBsonOutput.getPosition();
            byteBufferBsonOutput.writeInt32(0);
            byteBufferBsonOutput.writeByte(0);
            n = byteBufferBsonOutput.getPosition();
            List<BsonElement> list = this.getExtraElements(operationContext);
            int n4 = this.writeDocument(this.command, byteBufferBsonOutput, this.commandFieldNameValidator);
            if (this.sequences instanceof SplittablePayload) {
                BsonWriterHelper.appendElementsToDocument(byteBufferBsonOutput, n, list);
                SplittablePayload splittablePayload = (SplittablePayload)this.sequences;
                try (FinishOpMsgSectionWithPayloadType1 finishOpMsgSectionWithPayloadType1 = this.startOpMsgSectionWithPayloadType1(byteBufferBsonOutput, splittablePayload.getPayloadName());){
                    BsonWriterHelper.writePayload(new BsonBinaryWriter(byteBufferBsonOutput, splittablePayload.getFieldNameValidator()), byteBufferBsonOutput, this.getSettings(), n3, splittablePayload, this.getSettings().getMaxDocumentSize());
                }
            }
            if (this.sequences instanceof DualMessageSequences) {
                DualMessageSequences dualMessageSequences = (DualMessageSequences)this.sequences;
                try (ByteBufferBsonOutput.Branch branch = byteBufferBsonOutput.branch();
                     ByteBufferBsonOutput.Branch branch2 = byteBufferBsonOutput.branch();){
                    DualMessageSequences.EncodeDocumentsResult encodeDocumentsResult;
                    try (FinishOpMsgSectionWithPayloadType1 finishOpMsgSectionWithPayloadType1 = this.startOpMsgSectionWithPayloadType1(branch2, dualMessageSequences.getFirstSequenceId());
                         FinishOpMsgSectionWithPayloadType1 finishOpMsgSectionWithPayloadType12 = this.startOpMsgSectionWithPayloadType1(branch, dualMessageSequences.getSecondSequenceId());){
                        encodeDocumentsResult = BsonWriterHelper.writeDocumentsOfDualMessageSequences(dualMessageSequences, n4, branch2, branch, this.getSettings());
                    }
                    this.dualMessageSequencesRequireResponse = encodeDocumentsResult.isServerResponseRequired();
                    list.addAll(encodeDocumentsResult.getExtraElements());
                    BsonWriterHelper.appendElementsToDocument(byteBufferBsonOutput, n, list);
                    break block35;
                }
            }
            if (this.sequences instanceof MessageSequences.EmptyMessageSequences) {
                BsonWriterHelper.appendElementsToDocument(byteBufferBsonOutput, n, list);
            } else {
                Assertions.fail(this.sequences.toString());
            }
        }
        byteBufferBsonOutput.writeInt32(n2, this.getOpMsgFlagBits());
        return n;
    }

    private int writeOpQuery(ByteBufferBsonOutput byteBufferBsonOutput) {
        byteBufferBsonOutput.writeInt32(0);
        byteBufferBsonOutput.writeCString(this.namespace.getFullName());
        byteBufferBsonOutput.writeInt32(0);
        byteBufferBsonOutput.writeInt32(-1);
        int n = byteBufferBsonOutput.getPosition();
        ArrayList<BsonElement> arrayList = null;
        if (this.serverApi != null) {
            arrayList = new ArrayList<BsonElement>(3);
            this.addServerApiElements(arrayList);
        }
        this.writeDocument(this.command, byteBufferBsonOutput, this.commandFieldNameValidator);
        BsonWriterHelper.appendElementsToDocument(byteBufferBsonOutput, n, arrayList);
        return n;
    }

    private int getOpMsgFlagBits() {
        int n = 0;
        if (!this.isResponseExpected()) {
            n = 2;
        }
        if (this.exhaustAllowed) {
            n |= 0x10000;
        }
        return n;
    }

    private boolean isDirectConnectionToReplicaSetMember() {
        return this.clusterConnectionMode == ClusterConnectionMode.SINGLE && this.getSettings().getServerType() != ServerType.SHARD_ROUTER && this.getSettings().getServerType() != ServerType.STANDALONE;
    }

    private boolean useOpMsg() {
        return this.getOpCode().equals((Object)OpCode.OP_MSG);
    }

    private List<BsonElement> getExtraElements(OperationContext operationContext) {
        SessionContext sessionContext = operationContext.getSessionContext();
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        ArrayList<BsonElement> arrayList = new ArrayList<BsonElement>();
        if (!this.getSettings().isCryptd()) {
            timeoutContext.runMaxTimeMS(l -> arrayList.add(new BsonElement("maxTimeMS", new BsonInt64(l))));
        }
        arrayList.add(new BsonElement("$db", new BsonString(new MongoNamespace(this.getCollectionName()).getDatabaseName())));
        if (sessionContext.getClusterTime() != null) {
            arrayList.add(new BsonElement("$clusterTime", sessionContext.getClusterTime()));
        }
        if (sessionContext.hasSession()) {
            if (!sessionContext.isImplicitSession() && !this.getSettings().isSessionSupported()) {
                throw new MongoClientException("Attempting to use a ClientSession while connected to a server that doesn't support sessions");
            }
            if (this.getSettings().isSessionSupported() && this.responseExpected) {
                arrayList.add(new BsonElement("lsid", sessionContext.getSessionId()));
            }
        }
        boolean bl = sessionContext.notifyMessageSent();
        Assertions.assertFalse(sessionContext.hasActiveTransaction() && sessionContext.isSnapshot());
        if (sessionContext.hasActiveTransaction()) {
            this.checkServerVersionForTransactionSupport();
            arrayList.add(new BsonElement("txnNumber", new BsonInt64(sessionContext.getTransactionNumber())));
            if (bl) {
                arrayList.add(new BsonElement("startTransaction", BsonBoolean.TRUE));
                this.addReadConcernDocument(arrayList, sessionContext);
            }
            arrayList.add(new BsonElement("autocommit", BsonBoolean.FALSE));
        } else if (sessionContext.isSnapshot()) {
            this.addReadConcernDocument(arrayList, sessionContext);
        }
        if (this.serverApi != null) {
            this.addServerApiElements(arrayList);
        }
        if (this.readPreference != null) {
            if (!this.readPreference.equals(ReadPreference.primary())) {
                arrayList.add(new BsonElement("$readPreference", this.readPreference.toDocument()));
            } else if (this.isDirectConnectionToReplicaSetMember()) {
                arrayList.add(new BsonElement("$readPreference", ReadPreference.primaryPreferred().toDocument()));
            }
        }
        return arrayList;
    }

    private void addServerApiElements(List<BsonElement> list) {
        list.add(new BsonElement("apiVersion", new BsonString(this.serverApi.getVersion().getValue())));
        if (this.serverApi.getStrict().isPresent()) {
            list.add(new BsonElement("apiStrict", BsonBoolean.valueOf(this.serverApi.getStrict().get())));
        }
        if (this.serverApi.getDeprecationErrors().isPresent()) {
            list.add(new BsonElement("apiDeprecationErrors", BsonBoolean.valueOf(this.serverApi.getDeprecationErrors().get())));
        }
    }

    private void checkServerVersionForTransactionSupport() {
        if (this.getSettings().getMaxWireVersion() < 8 && this.getSettings().getServerType() == ServerType.SHARD_ROUTER) {
            throw new MongoClientException("Transactions are not supported by the MongoDB cluster to which this client is connected.");
        }
    }

    private void addReadConcernDocument(List<BsonElement> list, SessionContext sessionContext) {
        BsonDocument bsonDocument = ReadConcernHelper.getReadConcernDocument(sessionContext, this.getSettings().getMaxWireVersion());
        if (!bsonDocument.isEmpty()) {
            list.add(new BsonElement("readConcern", bsonDocument));
        }
    }

    private FinishOpMsgSectionWithPayloadType1 startOpMsgSectionWithPayloadType1(ByteBufferBsonOutput byteBufferBsonOutput, String string) {
        byteBufferBsonOutput.writeByte(1);
        int n = byteBufferBsonOutput.getPosition();
        byteBufferBsonOutput.writeInt32(0);
        byteBufferBsonOutput.writeCString(string);
        return () -> BsonWriterHelper.backpatchLength(n, byteBufferBsonOutput);
    }

    private static OpCode getOpCode(MessageSettings messageSettings, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        return CommandMessage.isServerVersionKnown(messageSettings) || clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED || serverApi != null ? OpCode.OP_MSG : OpCode.OP_QUERY;
    }

    private static boolean isServerVersionKnown(MessageSettings messageSettings) {
        return messageSettings.getMaxWireVersion() >= 7;
    }

    @FunctionalInterface
    private static interface FinishOpMsgSectionWithPayloadType1
    extends AutoCloseable {
        @Override
        public void close();
    }
}

