/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.CommandProtocol;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MessageSequences;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

class CommandProtocolImpl<T>
implements CommandProtocol<T> {
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final MessageSequences sequences;
    private final ReadPreference readPreference;
    private final FieldNameValidator commandFieldNameValidator;
    private final Decoder<T> commandResultDecoder;
    private final boolean responseExpected;
    private final ClusterConnectionMode clusterConnectionMode;
    private final OperationContext operationContext;

    CommandProtocolImpl(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, boolean bl, MessageSequences messageSequences, ClusterConnectionMode clusterConnectionMode, OperationContext operationContext) {
        Assertions.notNull("database", string);
        this.namespace = new MongoNamespace(Assertions.notNull("database", string), "$cmd");
        this.command = Assertions.notNull("command", bsonDocument);
        this.commandFieldNameValidator = Assertions.notNull("commandFieldNameValidator", fieldNameValidator);
        this.readPreference = readPreference;
        this.commandResultDecoder = Assertions.notNull("commandResultDecoder", decoder);
        this.responseExpected = bl;
        this.sequences = messageSequences;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.operationContext = operationContext;
    }

    @Override
    @Nullable
    public T execute(InternalConnection internalConnection) {
        return internalConnection.sendAndReceive(this.getCommandMessage(internalConnection), this.commandResultDecoder, this.operationContext);
    }

    @Override
    public void executeAsync(InternalConnection internalConnection, SingleResultCallback<T> singleResultCallback) {
        try {
            internalConnection.sendAndReceiveAsync(this.getCommandMessage(internalConnection), this.commandResultDecoder, this.operationContext, (object, throwable) -> {
                if (throwable != null) {
                    singleResultCallback.onResult(null, throwable);
                } else {
                    singleResultCallback.onResult(object, null);
                }
            });
        }
        catch (Throwable throwable2) {
            singleResultCallback.onResult(null, throwable2);
        }
    }

    @Override
    public CommandProtocolImpl<T> withSessionContext(SessionContext sessionContext) {
        return new CommandProtocolImpl<T>(this.namespace.getDatabaseName(), this.command, this.commandFieldNameValidator, this.readPreference, this.commandResultDecoder, this.responseExpected, this.sequences, this.clusterConnectionMode, this.operationContext.withSessionContext(sessionContext));
    }

    private CommandMessage getCommandMessage(InternalConnection internalConnection) {
        return new CommandMessage(this.namespace, this.command, this.commandFieldNameValidator, this.readPreference, ProtocolHelper.getMessageSettings(internalConnection.getDescription(), internalConnection.getInitialServerDescription()), this.responseExpected, this.sequences, this.clusterConnectionMode, this.operationContext.getServerApi());
    }
}

