/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.ByteBuf;
import org.bson.assertions.Assertions;

class CompositeByteBuf
implements ByteBuf {
    private final List<Component> components;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private int position;
    private int limit;

    CompositeByteBuf(List<ByteBuf> list) {
        Assertions.notNull("buffers", list);
        Assertions.isTrueArgument("buffer list not empty", !list.isEmpty());
        this.components = new ArrayList<Component>(list.size());
        int n = 0;
        for (ByteBuf byteBuf : list) {
            Component component = new Component(byteBuf.asReadOnly().order(ByteOrder.LITTLE_ENDIAN), n);
            this.components.add(component);
            n = component.endOffset;
        }
        this.limit = this.components.get(this.components.size() - 1).endOffset;
    }

    CompositeByteBuf(CompositeByteBuf compositeByteBuf) {
        this.components = compositeByteBuf.components;
        this.position = compositeByteBuf.position();
        this.limit = compositeByteBuf.limit();
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            throw new UnsupportedOperationException(String.format("Only %s is supported", ByteOrder.BIG_ENDIAN));
        }
        return this;
    }

    @Override
    public int capacity() {
        return this.components.get(this.components.size() - 1).endOffset;
    }

    @Override
    public int remaining() {
        return this.limit() - this.position();
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public ByteBuf position(int n) {
        if (n < 0 || n > this.limit) {
            throw new IndexOutOfBoundsException(String.format("%d is out of bounds", n));
        }
        this.position = n;
        return this;
    }

    @Override
    public ByteBuf clear() {
        this.position = 0;
        this.limit = this.capacity();
        return this;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public byte get() {
        this.checkIndex(this.position);
        ++this.position;
        return this.get(this.position - 1);
    }

    @Override
    public byte get(int n) {
        this.checkIndex(n);
        Component component = this.findComponent(n);
        return component.buffer.get(n - component.offset);
    }

    @Override
    public ByteBuf get(byte[] byArray) {
        this.checkIndex(this.position, byArray.length);
        this.position += byArray.length;
        return this.get(this.position - byArray.length, byArray);
    }

    @Override
    public ByteBuf get(int n, byte[] byArray) {
        return this.get(n, byArray, 0, byArray.length);
    }

    @Override
    public ByteBuf get(byte[] byArray, int n, int n2) {
        this.checkIndex(this.position, n2);
        this.position += n2;
        return this.get(this.position - n2, byArray, n, n2);
    }

    @Override
    public ByteBuf get(int n, byte[] byArray, int n2, int n3) {
        this.checkDstIndex(n, n3, n2, byArray.length);
        int n4 = this.findComponentIndex(n);
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        while (n7 > 0) {
            Component component = this.components.get(n4);
            int n8 = Math.min(n7, component.buffer.capacity() - (n5 - component.offset));
            component.buffer.get(n5 - component.offset, byArray, n6, n8);
            n5 += n8;
            n6 += n8;
            n7 -= n8;
            ++n4;
        }
        return this;
    }

    @Override
    public long getLong() {
        this.position += 8;
        return this.getLong(this.position - 8);
    }

    @Override
    public long getLong(int n) {
        this.checkIndex(n, 8);
        Component component = this.findComponent(n);
        if (n + 8 <= component.endOffset) {
            return component.buffer.getLong(n - component.offset);
        }
        return (long)this.getInt(n) & 0xFFFFFFFFL | ((long)this.getInt(n + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    public double getDouble() {
        this.position += 8;
        return this.getDouble(this.position - 8);
    }

    @Override
    public double getDouble(int n) {
        return Double.longBitsToDouble(this.getLong(n));
    }

    @Override
    public int getInt() {
        this.position += 4;
        return this.getInt(this.position - 4);
    }

    @Override
    public int getInt(int n) {
        this.checkIndex(n, 4);
        Component component = this.findComponent(n);
        if (n + 4 <= component.endOffset) {
            return component.buffer.getInt(n - component.offset);
        }
        return this.getShort(n) & 0xFFFF | (this.getShort(n + 2) & 0xFFFF) << 16;
    }

    private int getShort(int n) {
        this.checkIndex(n, 2);
        return (short)(this.get(n) & 0xFF | (this.get(n + 1) & 0xFF) << 8);
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public ByteBuf limit(int n) {
        if (n < 0 || n > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("%d is out of bounds", n));
        }
        this.limit = n;
        return this;
    }

    @Override
    public ByteBuf put(int n, byte by) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf put(byte[] byArray, int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf put(byte by) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf flip() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf asReadOnly() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf duplicate() {
        return new CompositeByteBuf(this);
    }

    @Override
    public ByteBuffer asNIO() {
        if (this.components.size() == 1) {
            ByteBuffer byteBuffer = this.components.get(0).buffer.asNIO().duplicate();
            ((Buffer)byteBuffer).position(this.position).limit(this.limit);
            return byteBuffer;
        }
        byte[] byArray = new byte[this.remaining()];
        this.get(this.position, byArray, 0, byArray.length);
        return ByteBuffer.wrap(byArray);
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    @Override
    public ByteBuf retain() {
        if (this.referenceCount.incrementAndGet() == 1) {
            this.referenceCount.decrementAndGet();
            throw new IllegalStateException("Attempted to increment the reference count when it is already 0");
        }
        return this;
    }

    @Override
    public void release() {
        if (this.referenceCount.decrementAndGet() < 0) {
            this.referenceCount.incrementAndGet();
            throw new IllegalStateException("Attempted to decrement the reference count below 0");
        }
    }

    private Component findComponent(int n) {
        return this.components.get(this.findComponentIndex(n));
    }

    private int findComponentIndex(int n) {
        for (int i = this.components.size() - 1; i >= 0; --i) {
            Component component = this.components.get(i);
            if (n < component.offset) continue;
            return i;
        }
        throw new IndexOutOfBoundsException(String.format("%d is out of bounds", n));
    }

    private void checkIndex(int n) {
        this.ensureAccessible();
        if (n < 0 || n >= this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("index: %d (expected: range(0, %d))", n, this.capacity()));
        }
    }

    private void checkIndex(int n, int n2) {
        this.ensureAccessible();
        if (n < 0 || n > this.capacity() - n2) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", n, n2, this.capacity()));
        }
    }

    private void checkDstIndex(int n, int n2, int n3, int n4) {
        this.checkIndex(n, n2);
        if (n3 < 0 || n3 > n4 - n2) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", n3, n2, n4));
        }
    }

    private void ensureAccessible() {
        if (this.referenceCount.get() == 0) {
            throw new IllegalStateException("Reference count is 0");
        }
    }

    private static final class Component {
        private final ByteBuf buffer;
        private final int length;
        private final int offset;
        private final int endOffset;

        Component(ByteBuf byteBuf, int n) {
            this.buffer = byteBuf;
            this.length = byteBuf.limit() - byteBuf.position();
            this.offset = n;
            this.endOffset = n + this.length;
        }
    }
}

