/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.Compressor;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.OpCode;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.RequestMessage;
import java.util.List;
import org.bson.ByteBuf;

class CompressedMessage
extends RequestMessage {
    private final OpCode wrappedOpcode;
    private final List<ByteBuf> wrappedMessageBuffers;
    private final Compressor compressor;

    CompressedMessage(OpCode opCode, List<ByteBuf> list, Compressor compressor, MessageSettings messageSettings) {
        super(OpCode.OP_COMPRESSED, CompressedMessage.getWrappedMessageRequestId(list), messageSettings);
        this.wrappedOpcode = opCode;
        this.wrappedMessageBuffers = list;
        this.compressor = compressor;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(ByteBufferBsonOutput byteBufferBsonOutput, OperationContext operationContext) {
        byteBufferBsonOutput.writeInt32(this.wrappedOpcode.getValue());
        byteBufferBsonOutput.writeInt32(CompressedMessage.getWrappedMessageSize(this.wrappedMessageBuffers) - 16);
        byteBufferBsonOutput.writeByte(this.compressor.getId());
        CompressedMessage.getFirstWrappedMessageBuffer(this.wrappedMessageBuffers).position(CompressedMessage.getFirstWrappedMessageBuffer(this.wrappedMessageBuffers).position() + 16);
        this.compressor.compress(this.wrappedMessageBuffers, byteBufferBsonOutput);
        return new RequestMessage.EncodingMetadata(0);
    }

    private static int getWrappedMessageSize(List<ByteBuf> list) {
        ByteBuf byteBuf = CompressedMessage.getFirstWrappedMessageBuffer(list);
        return byteBuf.getInt(0);
    }

    private static int getWrappedMessageRequestId(List<ByteBuf> list) {
        ByteBuf byteBuf = CompressedMessage.getFirstWrappedMessageBuffer(list);
        return byteBuf.getInt(4);
    }

    private static ByteBuf getFirstWrappedMessageBuffer(List<ByteBuf> list) {
        return list.get(0);
    }
}

