/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInternalException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.bson.ByteBuf;
import org.bson.io.BsonOutput;

abstract class Compressor {
    static final int BUFFER_SIZE = 256;

    Compressor() {
    }

    abstract String getName();

    abstract byte getId();

    void compress(List<ByteBuf> list, BsonOutput bsonOutput) {
        BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = new BufferExposingByteArrayOutputStream(1024);
        try (OutputStream outputStream = this.getOutputStream(bufferExposingByteArrayOutputStream);){
            byte[] byArray = new byte[256];
            for (ByteBuf byteBuf : list) {
                while (byteBuf.hasRemaining()) {
                    int n = Math.min(byteBuf.remaining(), byArray.length);
                    byteBuf.get(byArray, 0, n);
                    outputStream.write(byArray, 0, n);
                }
            }
        }
        catch (IOException iOException) {
            throw new MongoInternalException("Unexpected IOException", iOException);
        }
        bsonOutput.writeBytes(bufferExposingByteArrayOutputStream.getInternalBytes(), 0, bufferExposingByteArrayOutputStream.size());
    }

    void uncompress(ByteBuf byteBuf, ByteBuf byteBuf2) {
        try (InputStream inputStream = this.getInputStream(new ByteBufInputStream(byteBuf));){
            byte[] byArray = new byte[256];
            int n = inputStream.read(byArray);
            while (n != -1) {
                byteBuf2.put(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            throw new MongoInternalException("Unexpected IOException", iOException);
        }
    }

    OutputStream getOutputStream(OutputStream outputStream) throws IOException {
        throw new UnsupportedEncodingException();
    }

    InputStream getInputStream(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static final class BufferExposingByteArrayOutputStream
    extends ByteArrayOutputStream {
        BufferExposingByteArrayOutputStream(int n) {
            super(n);
        }

        byte[] getInternalBytes() {
            return this.buf;
        }
    }

    private static final class ByteBufInputStream
    extends InputStream {
        private final ByteBuf source;

        ByteBufInputStream(ByteBuf byteBuf) {
            this.source = byteBuf;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            if (!this.source.hasRemaining()) {
                return -1;
            }
            int n3 = n2 > this.source.remaining() ? this.source.remaining() : n2;
            this.source.get(byArray, n, n3);
            return n3;
        }

        @Override
        public int read() {
            throw new UnsupportedOperationException();
        }
    }
}

