/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoServerUnavailableException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.Locks;
import com.mongodb.internal.connection.Pool;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.lang.Nullable;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class ConcurrentPool<T>
implements Pool<T> {
    public static final int INFINITE_SIZE = Integer.MAX_VALUE;
    private final int maxSize;
    private final ItemFactory<T> itemFactory;
    private final Deque<T> available = new ConcurrentLinkedDeque<T>();
    private final StateAndPermits stateAndPermits;
    private final String poolClosedMessage;

    public ConcurrentPool(int n, ItemFactory<T> itemFactory) {
        this(n, itemFactory, "The pool is closed");
    }

    public ConcurrentPool(int n, ItemFactory<T> itemFactory, String string) {
        Assertions.assertTrue(n > 0);
        this.maxSize = n;
        this.itemFactory = itemFactory;
        this.stateAndPermits = new StateAndPermits(n, this::poolClosedException);
        this.poolClosedMessage = Assertions.notNull("poolClosedMessage", string);
    }

    @Override
    public void release(T t) {
        this.release(t, false);
    }

    @Override
    public void release(T t, boolean bl) {
        if (t == null) {
            throw new IllegalArgumentException("Can not return a null item to the pool");
        }
        if (this.stateAndPermits.closed()) {
            this.close(t);
            return;
        }
        if (bl) {
            this.close(t);
        } else {
            this.available.addLast(t);
        }
        this.stateAndPermits.releasePermit();
    }

    @Override
    public T get() {
        return this.get(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public T get(long l, TimeUnit timeUnit) {
        if (!this.stateAndPermits.acquirePermit(l, timeUnit)) {
            throw new MongoTimeoutException(String.format("Timeout waiting for a pooled item after %d %s", new Object[]{l, timeUnit}));
        }
        T t = this.available.pollLast();
        if (t == null) {
            t = this.createNewAndReleasePermitIfFailure();
        }
        return t;
    }

    @Nullable
    T getImmediate() {
        T t = null;
        if (this.stateAndPermits.acquirePermitImmediate() && (t = (T)this.available.pollLast()) == null) {
            this.stateAndPermits.releasePermit();
        }
        return t;
    }

    public void prune() {
        int n = this.available.size();
        int n2 = 0;
        for (T t : this.available) {
            if (this.itemFactory.shouldPrune(t) && this.available.remove(t)) {
                this.close(t);
            }
            if (++n2 != n) continue;
            break;
        }
    }

    public void ensureMinSize(int n, Consumer<T> consumer) {
        while (this.getCount() < n && this.stateAndPermits.acquirePermit(0L, TimeUnit.MILLISECONDS)) {
            consumer.accept(this.createNewAndReleasePermitIfFailure());
        }
    }

    private T createNewAndReleasePermitIfFailure() {
        try {
            T t = this.itemFactory.create();
            if (t == null) {
                throw new MongoInternalException("The factory for the pool created a null item");
            }
            return t;
        }
        catch (Exception exception) {
            this.stateAndPermits.releasePermit();
            throw exception;
        }
    }

    boolean acquirePermit(long l, TimeUnit timeUnit) {
        return this.stateAndPermits.acquirePermit(l, timeUnit);
    }

    @Override
    public void close() {
        if (this.stateAndPermits.close()) {
            Iterator<T> iterator = this.available.iterator();
            while (iterator.hasNext()) {
                T t = iterator.next();
                this.close(t);
                iterator.remove();
            }
        }
    }

    int getMaxSize() {
        return this.maxSize;
    }

    public int getInUseCount() {
        return this.maxSize - this.stateAndPermits.permits();
    }

    public int getAvailableCount() {
        return this.available.size();
    }

    public int getCount() {
        return this.getInUseCount() + this.getAvailableCount();
    }

    public String toString() {
        return "pool:  maxSize: " + ConcurrentPool.sizeToString(this.maxSize) + " availableCount " + this.getAvailableCount() + " inUseCount " + this.getInUseCount();
    }

    private void close(T t) {
        try {
            this.itemFactory.close(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void ready() {
        this.stateAndPermits.ready();
    }

    void pause(Supplier<MongoException> supplier) {
        this.stateAndPermits.pause(supplier);
    }

    MongoServerUnavailableException poolClosedException() {
        return new MongoServerUnavailableException(this.poolClosedMessage);
    }

    static boolean isPoolClosedException(Throwable throwable) {
        return throwable instanceof MongoServerUnavailableException;
    }

    static String sizeToString(int n) {
        return n == Integer.MAX_VALUE ? "infinite" : Integer.toString(n);
    }

    public static interface ItemFactory<T> {
        public T create();

        public void close(T var1);

        public boolean shouldPrune(T var1);
    }

    @ThreadSafe
    private static final class StateAndPermits {
        private final Supplier<MongoServerUnavailableException> poolClosedExceptionSupplier;
        private final ReentrantLock lock;
        private final Condition permitAvailableOrClosedOrPausedCondition;
        private volatile boolean paused;
        private volatile boolean closed;
        private final int maxPermits;
        private volatile int permits;
        @Nullable
        private Supplier<MongoException> causeSupplier;

        StateAndPermits(int n, Supplier<MongoServerUnavailableException> supplier) {
            this.poolClosedExceptionSupplier = supplier;
            this.lock = new ReentrantLock();
            this.permitAvailableOrClosedOrPausedCondition = this.lock.newCondition();
            this.paused = false;
            this.closed = false;
            this.maxPermits = n;
            this.permits = n;
            this.causeSupplier = null;
        }

        int permits() {
            return this.permits;
        }

        boolean acquirePermitImmediate() {
            return Locks.withLock((Lock)this.lock, () -> {
                this.throwIfClosedOrPaused();
                if (this.permits > 0) {
                    --this.permits;
                    return true;
                }
                return false;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean acquirePermit(long l, TimeUnit timeUnit) throws MongoInterruptedException {
            long l2 = timeUnit.toNanos(l);
            Locks.lockInterruptibly(this.lock);
            try {
                while (this.permits == 0 & !this.throwIfClosedOrPaused()) {
                    try {
                        if (l < 0L || l2 == Long.MAX_VALUE) {
                            this.permitAvailableOrClosedOrPausedCondition.await();
                            continue;
                        }
                        if (l2 < 0L) {
                            boolean bl = false;
                            return bl;
                        }
                        l2 = this.permitAvailableOrClosedOrPausedCondition.awaitNanos(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        throw InterruptionUtil.interruptAndCreateMongoInterruptedException(null, interruptedException);
                    }
                }
                Assertions.assertTrue(this.permits > 0);
                --this.permits;
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        void releasePermit() {
            Locks.withLock((Lock)this.lock, () -> {
                Assertions.assertTrue(this.permits < this.maxPermits);
                ++this.permits;
                this.permitAvailableOrClosedOrPausedCondition.signal();
            });
        }

        void pause(Supplier<MongoException> supplier) {
            Locks.withLock((Lock)this.lock, () -> {
                if (!this.paused) {
                    this.paused = true;
                    this.permitAvailableOrClosedOrPausedCondition.signalAll();
                }
                this.causeSupplier = Assertions.assertNotNull(supplier);
            });
        }

        void ready() {
            if (this.paused) {
                Locks.withLock((Lock)this.lock, () -> {
                    this.paused = false;
                    this.causeSupplier = null;
                });
            }
        }

        boolean close() {
            if (!this.closed) {
                return Locks.withLock((Lock)this.lock, () -> {
                    if (!this.closed) {
                        this.closed = true;
                        this.permitAvailableOrClosedOrPausedCondition.signalAll();
                        return true;
                    }
                    return false;
                });
            }
            return false;
        }

        boolean throwIfClosedOrPaused() {
            if (this.closed) {
                throw this.poolClosedExceptionSupplier.get();
            }
            if (this.paused) {
                throw Assertions.assertNotNull(Assertions.assertNotNull(this.causeSupplier).get());
            }
            return false;
        }

        boolean closed() {
            return this.closed;
        }
    }
}

