/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ScramShaAuthenticator;
import com.mongodb.internal.connection.SpeculativeAuthenticator;
import com.mongodb.lang.Nullable;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;

class DefaultAuthenticator
extends Authenticator
implements SpeculativeAuthenticator {
    static final int USER_NOT_FOUND_CODE = 11;
    private static final BsonString DEFAULT_MECHANISM_NAME = new BsonString(AuthenticationMechanism.SCRAM_SHA_256.getMechanismName());
    private Authenticator delegate;

    DefaultAuthenticator(MongoCredentialWithCache mongoCredentialWithCache, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(mongoCredentialWithCache, clusterConnectionMode, serverApi);
        Assertions.isTrueArgument("unspecified authentication mechanism", mongoCredentialWithCache.getAuthenticationMechanism() == null);
    }

    @Override
    void authenticate(InternalConnection internalConnection, ConnectionDescription connectionDescription, OperationContext operationContext) {
        try {
            this.setDelegate(connectionDescription);
            this.delegate.authenticate(internalConnection, connectionDescription, operationContext);
        }
        catch (Exception exception) {
            throw this.wrapException(exception);
        }
    }

    @Override
    void authenticateAsync(InternalConnection internalConnection, ConnectionDescription connectionDescription, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback) {
        this.setDelegate(connectionDescription);
        this.delegate.authenticateAsync(internalConnection, connectionDescription, operationContext, singleResultCallback);
    }

    @Override
    public BsonDocument createSpeculativeAuthenticateCommand(InternalConnection internalConnection) {
        this.delegate = this.getAuthenticatorForHello();
        return ((SpeculativeAuthenticator)((Object)this.delegate)).createSpeculativeAuthenticateCommand(internalConnection);
    }

    @Override
    @Nullable
    public BsonDocument getSpeculativeAuthenticateResponse() {
        if (this.delegate != null) {
            return ((SpeculativeAuthenticator)((Object)this.delegate)).getSpeculativeAuthenticateResponse();
        }
        return null;
    }

    @Override
    public void setSpeculativeAuthenticateResponse(BsonDocument bsonDocument) {
        ((SpeculativeAuthenticator)((Object)this.delegate)).setSpeculativeAuthenticateResponse(bsonDocument);
    }

    Authenticator getAuthenticatorForHello() {
        return new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_256), this.getClusterConnectionMode(), this.getServerApi());
    }

    private void setDelegate(ConnectionDescription connectionDescription) {
        if (this.delegate != null && ((SpeculativeAuthenticator)((Object)this.delegate)).getSpeculativeAuthenticateResponse() != null) {
            return;
        }
        if (connectionDescription.getSaslSupportedMechanisms() != null) {
            BsonArray bsonArray = connectionDescription.getSaslSupportedMechanisms();
            AuthenticationMechanism authenticationMechanism = bsonArray.contains(DEFAULT_MECHANISM_NAME) ? AuthenticationMechanism.SCRAM_SHA_256 : AuthenticationMechanism.SCRAM_SHA_1;
            this.delegate = new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(authenticationMechanism), this.getClusterConnectionMode(), this.getServerApi());
        } else {
            this.delegate = new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_1), this.getClusterConnectionMode(), this.getServerApi());
        }
    }

    private MongoException wrapException(Throwable throwable) {
        if (throwable instanceof MongoSecurityException) {
            return (MongoSecurityException)throwable;
        }
        if (throwable instanceof MongoException && ((MongoException)throwable).getCode() == 11) {
            return new MongoSecurityException(this.getMongoCredential(), String.format("Exception authenticating %s", this.getMongoCredential()), throwable);
        }
        return Assertions.assertNotNull(MongoException.fromThrowable(throwable));
    }
}

