/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.LoggerSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.event.ClusterListener;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerMonitorListener;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.connection.AsynchronousClusterEventListener;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.DefaultClusterableServerFactory;
import com.mongodb.internal.connection.DefaultDnsSrvRecordMonitorFactory;
import com.mongodb.internal.connection.DnsMultiServerCluster;
import com.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import com.mongodb.internal.connection.FaasEnvironment;
import com.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.mongodb.internal.connection.InternalOperationContextFactory;
import com.mongodb.internal.connection.LoadBalancedCluster;
import com.mongodb.internal.connection.LoadBalancedClusterableServerFactory;
import com.mongodb.internal.connection.MultiServerCluster;
import com.mongodb.internal.connection.SingleServerCluster;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.DnsClient;
import java.util.Collections;
import java.util.List;

public final class DefaultClusterFactory {
    private static final Logger LOGGER = Loggers.getLogger("client");

    public Cluster createCluster(ClusterSettings clusterSettings, ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, TimeoutSettings timeoutSettings, StreamFactory streamFactory, TimeoutSettings timeoutSettings2, StreamFactory streamFactory2, @Nullable MongoCredential mongoCredential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String string, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> list, @Nullable ServerApi serverApi, @Nullable DnsClient dnsClient) {
        Object object;
        ServerSettings serverSettings2;
        ClusterSettings clusterSettings2;
        this.detectAndLogClusterEnvironment(clusterSettings);
        ClusterId clusterId = new ClusterId(string);
        if (this.noClusterEventListeners(clusterSettings, serverSettings)) {
            clusterSettings2 = ClusterSettings.builder(clusterSettings).clusterListenerList(Collections.singletonList(EventListenerHelper.NO_OP_CLUSTER_LISTENER)).build();
            serverSettings2 = ServerSettings.builder(serverSettings).serverListenerList(Collections.singletonList(EventListenerHelper.NO_OP_SERVER_LISTENER)).serverMonitorListenerList(Collections.singletonList(EventListenerHelper.NO_OP_SERVER_MONITOR_LISTENER)).build();
        } else {
            object = AsynchronousClusterEventListener.startNew(clusterId, DefaultClusterFactory.getClusterListener(clusterSettings), DefaultClusterFactory.getServerListener(serverSettings), DefaultClusterFactory.getServerMonitorListener(serverSettings));
            clusterSettings2 = ClusterSettings.builder(clusterSettings).clusterListenerList(Collections.singletonList(object)).build();
            serverSettings2 = ServerSettings.builder(serverSettings).serverListenerList(Collections.singletonList(object)).serverMonitorListenerList(Collections.singletonList(object)).build();
        }
        object = new DefaultDnsSrvRecordMonitorFactory(clusterId, serverSettings2, dnsClient);
        InternalOperationContextFactory internalOperationContextFactory = new InternalOperationContextFactory(timeoutSettings, serverApi);
        InternalOperationContextFactory internalOperationContextFactory2 = new InternalOperationContextFactory(timeoutSettings2, serverApi);
        if (clusterSettings2.getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            LoadBalancedClusterableServerFactory loadBalancedClusterableServerFactory = new LoadBalancedClusterableServerFactory(serverSettings2, connectionPoolSettings, internalConnectionPoolSettings, streamFactory, mongoCredential, loggerSettings, commandListener, string, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), list, serverApi, internalOperationContextFactory);
            return new LoadBalancedCluster(clusterId, clusterSettings2, loadBalancedClusterableServerFactory, (DnsSrvRecordMonitorFactory)object);
        }
        DefaultClusterableServerFactory defaultClusterableServerFactory = new DefaultClusterableServerFactory(serverSettings2, connectionPoolSettings, internalConnectionPoolSettings, internalOperationContextFactory, streamFactory, internalOperationContextFactory2, streamFactory2, mongoCredential, loggerSettings, commandListener, string, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), list, serverApi, FaasEnvironment.getFaasEnvironment() != FaasEnvironment.UNKNOWN);
        if (clusterSettings2.getMode() == ClusterConnectionMode.SINGLE) {
            return new SingleServerCluster(clusterId, clusterSettings2, defaultClusterableServerFactory);
        }
        if (clusterSettings2.getMode() == ClusterConnectionMode.MULTIPLE) {
            if (clusterSettings2.getSrvHost() == null) {
                return new MultiServerCluster(clusterId, clusterSettings2, defaultClusterableServerFactory);
            }
            return new DnsMultiServerCluster(clusterId, clusterSettings2, defaultClusterableServerFactory, (DnsSrvRecordMonitorFactory)object);
        }
        throw new UnsupportedOperationException("Unsupported cluster mode: " + (Object)((Object)clusterSettings2.getMode()));
    }

    private boolean noClusterEventListeners(ClusterSettings clusterSettings, ServerSettings serverSettings) {
        return clusterSettings.getClusterListeners().isEmpty() && serverSettings.getServerListeners().isEmpty() && serverSettings.getServerMonitorListeners().isEmpty();
    }

    private static ClusterListener getClusterListener(ClusterSettings clusterSettings) {
        return clusterSettings.getClusterListeners().size() == 0 ? EventListenerHelper.NO_OP_CLUSTER_LISTENER : EventListenerHelper.clusterListenerMulticaster(clusterSettings.getClusterListeners());
    }

    private static ServerListener getServerListener(ServerSettings serverSettings) {
        return serverSettings.getServerListeners().size() == 0 ? EventListenerHelper.NO_OP_SERVER_LISTENER : EventListenerHelper.serverListenerMulticaster(serverSettings.getServerListeners());
    }

    private static ServerMonitorListener getServerMonitorListener(ServerSettings serverSettings) {
        return serverSettings.getServerMonitorListeners().size() == 0 ? EventListenerHelper.NO_OP_SERVER_MONITOR_LISTENER : EventListenerHelper.serverMonitorListenerMulticaster(serverSettings.getServerMonitorListeners());
    }

    public void detectAndLogClusterEnvironment(ClusterSettings clusterSettings) {
        String string = clusterSettings.getSrvHost();
        ClusterEnvironment clusterEnvironment = string != null ? ClusterEnvironment.detectCluster(string) : ClusterEnvironment.detectCluster((String[])clusterSettings.getHosts().stream().map(ServerAddress::getHost).toArray(String[]::new));
        if (clusterEnvironment != null) {
            LOGGER.info(String.format("You appear to be connected to a %s cluster. For more information regarding feature compatibility and support please visit %s", clusterEnvironment.clusterProductName, clusterEnvironment.documentationUrl));
        }
    }

    static enum ClusterEnvironment {
        AZURE("https://www.mongodb.com/supportability/cosmosdb", "CosmosDB", ".cosmos.azure.com"),
        AWS("https://www.mongodb.com/supportability/documentdb", "DocumentDB", ".docdb.amazonaws.com", ".docdb-elastic.amazonaws.com");

        private final String documentationUrl;
        private final String clusterProductName;
        private final String[] hostSuffixes;

        private ClusterEnvironment(String string2, String string3, String ... stringArray) {
            this.hostSuffixes = stringArray;
            this.documentationUrl = string2;
            this.clusterProductName = string3;
        }

        @Nullable
        public static ClusterEnvironment detectCluster(String ... stringArray) {
            for (String string : stringArray) {
                for (ClusterEnvironment clusterEnvironment : ClusterEnvironment.values()) {
                    if (!clusterEnvironment.isExternalClusterProvider(string)) continue;
                    return clusterEnvironment;
                }
            }
            return null;
        }

        private boolean isExternalClusterProvider(String string) {
            for (String string2 : this.hostSuffixes) {
                String string3 = string.toLowerCase();
                if (!string3.endsWith(string2)) continue;
                return true;
            }
            return false;
        }
    }
}

