/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.LoggerSettings;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerSettings;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ServerListener;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.ClusterableServerFactory;
import com.mongodb.internal.connection.DefaultConnectionFactory;
import com.mongodb.internal.connection.DefaultConnectionPool;
import com.mongodb.internal.connection.DefaultSdamServerDescriptionManager;
import com.mongodb.internal.connection.DefaultServer;
import com.mongodb.internal.connection.DefaultServerMonitor;
import com.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.mongodb.internal.connection.InternalOperationContextFactory;
import com.mongodb.internal.connection.InternalStreamConnectionFactory;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.SdamServerDescriptionManager;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.inject.SameObjectProvider;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final InternalOperationContextFactory clusterOperationContextFactory;
    private final StreamFactory streamFactory;
    private final InternalOperationContextFactory heartbeatOperationContextFactory;
    private final StreamFactory heartbeatStreamFactory;
    private final MongoCredentialWithCache credential;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    @Nullable
    private final ServerApi serverApi;
    private final boolean isFunctionAsAServiceEnvironment;

    public DefaultClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, InternalOperationContextFactory internalOperationContextFactory, StreamFactory streamFactory, InternalOperationContextFactory internalOperationContextFactory2, StreamFactory streamFactory2, @Nullable MongoCredential mongoCredential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String string, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> list, @Nullable ServerApi serverApi, boolean bl) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.clusterOperationContextFactory = internalOperationContextFactory;
        this.streamFactory = streamFactory;
        this.heartbeatOperationContextFactory = internalOperationContextFactory2;
        this.heartbeatStreamFactory = streamFactory2;
        this.credential = mongoCredential == null ? null : new MongoCredentialWithCache(mongoCredential);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = string;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = list;
        this.serverApi = serverApi;
        this.isFunctionAsAServiceEnvironment = bl;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        ServerId serverId = new ServerId(cluster.getClusterId(), serverAddress);
        ClusterConnectionMode clusterConnectionMode = cluster.getSettings().getMode();
        SameObjectProvider<SdamServerDescriptionManager> sameObjectProvider = SameObjectProvider.uninitialized();
        DefaultServerMonitor defaultServerMonitor = new DefaultServerMonitor(serverId, this.serverSettings, new InternalStreamConnectionFactory(clusterConnectionMode, true, this.heartbeatStreamFactory, null, this.applicationName, this.mongoDriverInformation, Collections.emptyList(), this.loggerSettings, null, this.serverApi), clusterConnectionMode, this.serverApi, this.isFunctionAsAServiceEnvironment, sameObjectProvider, this.heartbeatOperationContextFactory);
        DefaultConnectionPool defaultConnectionPool = new DefaultConnectionPool(serverId, new InternalStreamConnectionFactory(clusterConnectionMode, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, sameObjectProvider, this.clusterOperationContextFactory);
        ServerListener serverListener = EventListenerHelper.singleServerListener(this.serverSettings);
        DefaultSdamServerDescriptionManager defaultSdamServerDescriptionManager = new DefaultSdamServerDescriptionManager(cluster, serverId, serverListener, defaultServerMonitor, defaultConnectionPool, clusterConnectionMode);
        sameObjectProvider.initialize(defaultSdamServerDescriptionManager);
        defaultServerMonitor.start();
        return new DefaultServer(serverId, clusterConnectionMode, defaultConnectionPool, new DefaultConnectionFactory(), defaultServerMonitor, defaultSdamServerDescriptionManager, serverListener, this.commandListener, cluster.getClock(), true);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

