/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterType;
import com.mongodb.internal.connection.DnsSrvRecordInitializer;
import com.mongodb.internal.connection.DnsSrvRecordMonitor;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.dns.DnsResolver;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class DefaultDnsSrvRecordMonitor
implements DnsSrvRecordMonitor {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final String hostName;
    private final String srvServiceName;
    private final long rescanFrequencyMillis;
    private final long noRecordsRescanFrequencyMillis;
    private final DnsSrvRecordInitializer dnsSrvRecordInitializer;
    private final DnsResolver dnsResolver;
    private final Thread monitorThread;
    private volatile boolean isClosed;

    DefaultDnsSrvRecordMonitor(String string, String string2, long l, long l2, DnsSrvRecordInitializer dnsSrvRecordInitializer, ClusterId clusterId, DnsResolver dnsResolver) {
        this.hostName = string;
        this.srvServiceName = string2;
        this.rescanFrequencyMillis = l;
        this.noRecordsRescanFrequencyMillis = l2;
        this.dnsSrvRecordInitializer = dnsSrvRecordInitializer;
        this.dnsResolver = dnsResolver;
        this.monitorThread = new Thread((Runnable)new DnsSrvRecordMonitorRunnable(), "cluster-" + clusterId + "-srv-" + string);
        this.monitorThread.setDaemon(true);
    }

    @Override
    public void start() {
        this.monitorThread.start();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.monitorThread.interrupt();
    }

    private class DnsSrvRecordMonitorRunnable
    implements Runnable {
        private Set<ServerAddress> currentHosts = Collections.emptySet();
        private ClusterType clusterType = ClusterType.UNKNOWN;

        private DnsSrvRecordMonitorRunnable() {
        }

        @Override
        public void run() {
            while (!DefaultDnsSrvRecordMonitor.this.isClosed && this.shouldContinueMonitoring()) {
                try {
                    List<String> list = DefaultDnsSrvRecordMonitor.this.dnsResolver.resolveHostFromSrvRecords(DefaultDnsSrvRecordMonitor.this.hostName, DefaultDnsSrvRecordMonitor.this.srvServiceName);
                    Set<ServerAddress> set = this.createServerAddressSet(list);
                    if (DefaultDnsSrvRecordMonitor.this.isClosed) {
                        return;
                    }
                    if (!set.equals(this.currentHosts)) {
                        try {
                            DefaultDnsSrvRecordMonitor.this.dnsSrvRecordInitializer.initialize(Collections.unmodifiableSet(set));
                            this.currentHosts = set;
                        }
                        catch (Exception exception) {
                            LOGGER.warn("Exception in monitor thread during notification of DNS resolution state change", exception);
                        }
                    }
                }
                catch (MongoException mongoException) {
                    if (this.currentHosts.isEmpty()) {
                        DefaultDnsSrvRecordMonitor.this.dnsSrvRecordInitializer.initialize(mongoException);
                    }
                    LOGGER.info("Exception while resolving SRV records", mongoException);
                }
                catch (Exception exception) {
                    if (this.currentHosts.isEmpty()) {
                        DefaultDnsSrvRecordMonitor.this.dnsSrvRecordInitializer.initialize(new MongoInternalException("Unexpected runtime exception", exception));
                    }
                    LOGGER.info("Unexpected runtime exception while resolving SRV record", exception);
                }
                try {
                    Thread.sleep(this.getRescanFrequencyMillis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.clusterType = DefaultDnsSrvRecordMonitor.this.dnsSrvRecordInitializer.getClusterType();
            }
        }

        private boolean shouldContinueMonitoring() {
            return this.clusterType == ClusterType.UNKNOWN || this.clusterType == ClusterType.SHARDED;
        }

        private long getRescanFrequencyMillis() {
            return this.currentHosts.isEmpty() ? DefaultDnsSrvRecordMonitor.this.noRecordsRescanFrequencyMillis : DefaultDnsSrvRecordMonitor.this.rescanFrequencyMillis;
        }

        private Set<ServerAddress> createServerAddressSet(List<String> list) {
            HashSet<ServerAddress> hashSet = new HashSet<ServerAddress>(list.size());
            for (String string : list) {
                hashSet.add(ServerAddressHelper.createServerAddress(string));
            }
            return hashSet;
        }
    }
}

