/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoException;
import com.mongodb.MongoServerUnavailableException;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ServerClosedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerOpeningEvent;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.AbstractProtocolExecutor;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import com.mongodb.internal.connection.ClusterableServer;
import com.mongodb.internal.connection.CommandProtocol;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.ConnectionFactory;
import com.mongodb.internal.connection.ConnectionPool;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MessageSequences;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.SdamServerDescriptionManager;
import com.mongodb.internal.connection.ServerDescriptionHelper;
import com.mongodb.internal.connection.ServerMonitor;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

class DefaultServer
implements ClusterableServer {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final ServerId serverId;
    private final ConnectionPool connectionPool;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ConnectionFactory connectionFactory;
    private final ServerMonitor serverMonitor;
    private final SdamServerDescriptionManager sdam;
    private final ServerListener serverListener;
    private final CommandListener commandListener;
    private final ClusterClock clusterClock;
    @Nullable
    private final AtomicInteger operationCount;
    private volatile boolean isClosed;

    DefaultServer(ServerId serverId, ClusterConnectionMode clusterConnectionMode, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerMonitor serverMonitor, SdamServerDescriptionManager sdamServerDescriptionManager, ServerListener serverListener, CommandListener commandListener, ClusterClock clusterClock, boolean bl) {
        this.sdam = Assertions.assertNotNull(sdamServerDescriptionManager);
        this.serverListener = Assertions.notNull("serverListener", serverListener);
        this.commandListener = commandListener;
        this.clusterClock = Assertions.notNull("clusterClock", clusterClock);
        Assertions.notNull("serverAddress", serverId);
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.connectionFactory = Assertions.notNull("connectionFactory", connectionFactory);
        this.connectionPool = Assertions.notNull("connectionPool", connectionPool);
        this.serverId = serverId;
        serverListener.serverOpening(new ServerOpeningEvent(this.serverId));
        this.serverMonitor = serverMonitor;
        this.operationCount = bl ? new AtomicInteger() : null;
    }

    @Override
    public Connection getConnection(OperationContext operationContext) {
        if (this.isClosed) {
            throw new MongoServerUnavailableException(String.format("The server at %s is no longer available", this.serverId.getAddress()));
        }
        SdamServerDescriptionManager.SdamIssue.Context context = this.sdam.context();
        this.operationBegin();
        try {
            return OperationCountTrackingConnection.decorate(this, this.connectionFactory.create(this.connectionPool.get(operationContext), new DefaultServerProtocolExecutor(), this.clusterConnectionMode));
        }
        catch (Throwable throwable) {
            try {
                this.operationEnd();
                if (throwable instanceof MongoException) {
                    this.sdam.handleExceptionBeforeHandshake(SdamServerDescriptionManager.SdamIssue.specific(throwable, context));
                }
            }
            catch (Exception exception) {
                throwable.addSuppressed(exception);
            }
            throw throwable;
        }
    }

    @Override
    public void getConnectionAsync(OperationContext operationContext, SingleResultCallback<AsyncConnection> singleResultCallback) {
        if (this.isClosed) {
            singleResultCallback.onResult(null, new MongoServerUnavailableException(String.format("The server at %s is no longer available", this.serverId.getAddress())));
            return;
        }
        SdamServerDescriptionManager.SdamIssue.Context context = this.sdam.context();
        this.operationBegin();
        this.connectionPool.getAsync(operationContext, (internalConnection, throwable) -> {
            if (throwable != null) {
                try {
                    this.operationEnd();
                    this.sdam.handleExceptionBeforeHandshake(SdamServerDescriptionManager.SdamIssue.specific(throwable, context));
                }
                catch (Exception exception) {
                    throwable.addSuppressed(exception);
                }
                finally {
                    singleResultCallback.onResult(null, throwable);
                }
            } else {
                singleResultCallback.onResult(AsyncOperationCountTrackingConnection.decorate(this, this.connectionFactory.createAsync(Assertions.assertNotNull(internalConnection), new DefaultServerProtocolExecutor(), this.clusterConnectionMode)), null);
            }
        });
    }

    @Override
    public int operationCount() {
        return this.operationCount == null ? -1 : this.operationCount.get();
    }

    private void operationBegin() {
        if (this.operationCount != null) {
            this.operationCount.incrementAndGet();
        }
    }

    private void operationEnd() {
        if (this.operationCount != null) {
            Assertions.assertTrue(this.operationCount.decrementAndGet() >= 0);
        }
    }

    @Override
    public void resetToConnecting() {
        this.sdam.update(ServerDescriptionHelper.unknownConnectingServerDescription(this.serverId, null));
    }

    @Override
    public void invalidate() {
        if (!this.isClosed()) {
            this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.unspecified(this.sdam.context()));
        }
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.connectionPool.close();
            this.serverMonitor.close();
            this.isClosed = true;
            this.serverListener.serverClosed(new ServerClosedEvent(this.serverId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void connect() {
        this.serverMonitor.connect();
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    SdamServerDescriptionManager sdamServerDescriptionManager() {
        return this.sdam;
    }

    ServerId serverId() {
        return this.serverId;
    }

    private class DefaultServerProtocolExecutor
    extends AbstractProtocolExecutor {
        private DefaultServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(CommandProtocol<T> commandProtocol, InternalConnection internalConnection, SessionContext sessionContext) {
            try {
                return commandProtocol.withSessionContext(new ClusterClockAdvancingSessionContext(sessionContext, DefaultServer.this.clusterClock)).execute(internalConnection);
            }
            catch (MongoException mongoException) {
                try {
                    DefaultServer.this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.specific(mongoException, DefaultServer.this.sdam.context(internalConnection)));
                }
                catch (Exception exception) {
                    mongoException.addSuppressed(exception);
                }
                if (mongoException instanceof MongoWriteConcernWithResponseException) {
                    return (T)((MongoWriteConcernWithResponseException)mongoException).getResponse();
                }
                if (this.shouldMarkSessionDirty(mongoException, sessionContext)) {
                    sessionContext.markSessionDirty();
                }
                throw mongoException;
            }
        }

        @Override
        public <T> void executeAsync(CommandProtocol<T> commandProtocol, InternalConnection internalConnection, SessionContext sessionContext, SingleResultCallback<T> singleResultCallback) {
            commandProtocol.withSessionContext(new ClusterClockAdvancingSessionContext(sessionContext, DefaultServer.this.clusterClock)).executeAsync(internalConnection, ErrorHandlingResultCallback.errorHandlingCallback((object, throwable) -> {
                if (throwable != null) {
                    try {
                        DefaultServer.this.sdam.handleExceptionAfterHandshake(SdamServerDescriptionManager.SdamIssue.specific(throwable, DefaultServer.this.sdam.context(internalConnection)));
                    }
                    catch (Exception exception) {
                        throwable.addSuppressed(exception);
                    }
                    finally {
                        if (throwable instanceof MongoWriteConcernWithResponseException) {
                            singleResultCallback.onResult(((MongoWriteConcernWithResponseException)throwable).getResponse(), null);
                        } else {
                            if (this.shouldMarkSessionDirty(throwable, sessionContext)) {
                                sessionContext.markSessionDirty();
                            }
                            singleResultCallback.onResult(null, throwable);
                        }
                    }
                } else {
                    singleResultCallback.onResult(object, null);
                }
            }, LOGGER));
        }
    }

    private static final class OperationCountTrackingConnection
    implements Connection {
        private final DefaultServer server;
        private final Connection wrapped;

        static Connection decorate(DefaultServer defaultServer, Connection connection) {
            return defaultServer.operationCount() < 0 ? connection : new OperationCountTrackingConnection(defaultServer, connection);
        }

        private OperationCountTrackingConnection(DefaultServer defaultServer, Connection connection) {
            this.server = defaultServer;
            this.wrapped = connection;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public int release() {
            int n = this.wrapped.release();
            if (n == 0) {
                this.server.operationEnd();
            }
            return n;
        }

        @Override
        public Connection retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public ConnectionDescription getDescription() {
            return this.wrapped.getDescription();
        }

        @Override
        public <T> T command(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, OperationContext operationContext) {
            return this.wrapped.command(string, bsonDocument, fieldNameValidator, readPreference, decoder, operationContext);
        }

        @Override
        public <T> T command(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, OperationContext operationContext, boolean bl, MessageSequences messageSequences) {
            return this.wrapped.command(string, bsonDocument, fieldNameValidator, readPreference, decoder, operationContext, bl, messageSequences);
        }

        @Override
        public void markAsPinned(Connection.PinningMode pinningMode) {
            this.wrapped.markAsPinned(pinningMode);
        }
    }

    private static final class AsyncOperationCountTrackingConnection
    implements AsyncConnection {
        private final DefaultServer server;
        private final AsyncConnection wrapped;

        static AsyncConnection decorate(DefaultServer defaultServer, AsyncConnection asyncConnection) {
            return defaultServer.operationCount() < 0 ? asyncConnection : new AsyncOperationCountTrackingConnection(defaultServer, asyncConnection);
        }

        AsyncOperationCountTrackingConnection(DefaultServer defaultServer, AsyncConnection asyncConnection) {
            this.server = defaultServer;
            this.wrapped = asyncConnection;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public int release() {
            int n = this.wrapped.release();
            if (n == 0) {
                this.server.operationEnd();
            }
            return n;
        }

        @Override
        public AsyncConnection retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public ConnectionDescription getDescription() {
            return this.wrapped.getDescription();
        }

        @Override
        public <T> void commandAsync(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, OperationContext operationContext, SingleResultCallback<T> singleResultCallback) {
            this.wrapped.commandAsync(string, bsonDocument, fieldNameValidator, readPreference, decoder, operationContext, singleResultCallback);
        }

        @Override
        public <T> void commandAsync(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, OperationContext operationContext, boolean bl, MessageSequences messageSequences, SingleResultCallback<T> singleResultCallback) {
            this.wrapped.commandAsync(string, bsonDocument, fieldNameValidator, readPreference, decoder, operationContext, bl, messageSequences, singleResultCallback);
        }

        @Override
        public void markAsPinned(Connection.PinningMode pinningMode) {
            this.wrapped.markAsPinned(pinningMode);
        }
    }
}

