/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.ReadPreference;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.AbstractReferenceCounted;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.CommandProtocol;
import com.mongodb.internal.connection.CommandProtocolImpl;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MessageSequences;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ProtocolExecutor;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

public class DefaultServerConnection
extends AbstractReferenceCounted
implements Connection,
AsyncConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final InternalConnection wrapped;
    private final ProtocolExecutor protocolExecutor;
    private final ClusterConnectionMode clusterConnectionMode;

    public DefaultServerConnection(InternalConnection internalConnection, ProtocolExecutor protocolExecutor, ClusterConnectionMode clusterConnectionMode) {
        this.wrapped = internalConnection;
        this.protocolExecutor = protocolExecutor;
        this.clusterConnectionMode = clusterConnectionMode;
    }

    @Override
    public DefaultServerConnection retain() {
        super.retain();
        return this;
    }

    @Override
    public int release() {
        int n = super.release();
        if (n == 0) {
            this.wrapped.close();
        }
        return n;
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    @Nullable
    public <T> T command(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, OperationContext operationContext) {
        return this.command(string, bsonDocument, fieldNameValidator, readPreference, decoder, operationContext, true, MessageSequences.EmptyMessageSequences.INSTANCE);
    }

    @Override
    @Nullable
    public <T> T command(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, OperationContext operationContext, boolean bl, MessageSequences messageSequences) {
        return this.executeProtocol(new CommandProtocolImpl<T>(string, bsonDocument, fieldNameValidator, readPreference, decoder, bl, messageSequences, this.clusterConnectionMode, operationContext), operationContext.getSessionContext());
    }

    @Override
    public <T> void commandAsync(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, OperationContext operationContext, SingleResultCallback<T> singleResultCallback) {
        this.commandAsync(string, bsonDocument, fieldNameValidator, readPreference, decoder, operationContext, true, MessageSequences.EmptyMessageSequences.INSTANCE, singleResultCallback);
    }

    @Override
    public <T> void commandAsync(String string, BsonDocument bsonDocument, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> decoder, OperationContext operationContext, boolean bl, MessageSequences messageSequences, SingleResultCallback<T> singleResultCallback) {
        this.executeProtocolAsync(new CommandProtocolImpl<T>(string, bsonDocument, fieldNameValidator, readPreference, decoder, bl, messageSequences, this.clusterConnectionMode, operationContext), operationContext.getSessionContext(), singleResultCallback);
    }

    @Override
    public void markAsPinned(Connection.PinningMode pinningMode) {
        this.wrapped.markAsPinned(pinningMode);
    }

    @Nullable
    private <T> T executeProtocol(CommandProtocol<T> commandProtocol, SessionContext sessionContext) {
        return this.protocolExecutor.execute(commandProtocol, this.wrapped, sessionContext);
    }

    private <T> void executeProtocolAsync(CommandProtocol<T> commandProtocol, SessionContext sessionContext, SingleResultCallback<T> singleResultCallback) {
        SingleResultCallback<Object> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, LOGGER);
        try {
            this.protocolExecutor.executeAsync(commandProtocol, this.wrapped, sessionContext, singleResultCallback2);
        }
        catch (Throwable throwable) {
            singleResultCallback2.onResult(null, throwable);
        }
    }
}

