/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.ServerType;
import com.mongodb.event.ServerHeartbeatFailedEvent;
import com.mongodb.event.ServerHeartbeatStartedEvent;
import com.mongodb.event.ServerHeartbeatSucceededEvent;
import com.mongodb.event.ServerMonitorListener;
import com.mongodb.internal.Locks;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.DescriptionHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.InternalConnectionFactory;
import com.mongodb.internal.connection.InternalOperationContextFactory;
import com.mongodb.internal.connection.MessageSettings;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.RoundTripTimeSampler;
import com.mongodb.internal.connection.SdamServerDescriptionManager;
import com.mongodb.internal.connection.ServerDescriptionHelper;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.event.EventListenerHelper;
import com.mongodb.internal.inject.Provider;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.types.ObjectId;

@ThreadSafe
class DefaultServerMonitor
implements com.mongodb.internal.connection.ServerMonitor {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final ServerId serverId;
    private final ServerMonitorListener serverMonitorListener;
    private final Provider<SdamServerDescriptionManager> sdamProvider;
    private final InternalOperationContextFactory operationContextFactory;
    private final InternalConnectionFactory internalConnectionFactory;
    private final ClusterConnectionMode clusterConnectionMode;
    @Nullable
    private final ServerApi serverApi;
    private final boolean isFunctionAsAServiceEnvironment;
    private final ServerSettings serverSettings;
    private final ServerMonitor monitor;
    @Nullable
    private RoundTripTimeMonitor roundTripTimeMonitor;
    private final RoundTripTimeSampler roundTripTimeSampler = new RoundTripTimeSampler();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile boolean isClosed;

    DefaultServerMonitor(ServerId serverId, ServerSettings serverSettings, InternalConnectionFactory internalConnectionFactory, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, boolean bl, Provider<SdamServerDescriptionManager> provider, InternalOperationContextFactory internalOperationContextFactory) {
        this.serverSettings = Assertions.notNull("serverSettings", serverSettings);
        this.serverId = Assertions.notNull("serverId", serverId);
        this.serverMonitorListener = EventListenerHelper.singleServerMonitorListener(serverSettings);
        this.internalConnectionFactory = Assertions.notNull("internalConnectionFactory", internalConnectionFactory);
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.operationContextFactory = Assertions.assertNotNull(internalOperationContextFactory);
        this.serverApi = serverApi;
        this.isFunctionAsAServiceEnvironment = bl;
        this.sdamProvider = provider;
        this.monitor = new ServerMonitor();
        this.roundTripTimeMonitor = null;
        this.isClosed = false;
    }

    @Override
    public void start() {
        this.monitor.start();
    }

    private void ensureRoundTripTimeMonitorStarted() {
        Locks.withLock(this.lock, () -> {
            if (!this.isClosed && this.roundTripTimeMonitor == null) {
                this.roundTripTimeMonitor = new RoundTripTimeMonitor();
                this.roundTripTimeMonitor.start();
            }
        });
    }

    @Override
    public void connect() {
        Locks.withLock(this.lock, this.condition::signal);
    }

    @Override
    public void close() {
        Locks.withLock(this.lock, () -> {
            this.isClosed = true;
            try (ServerMonitor serverMonitor = this.monitor;){
                RoundTripTimeMonitor roundTripTimeMonitor = this.roundTripTimeMonitor;
                if (roundTripTimeMonitor != null) {
                    roundTripTimeMonitor.close();
                }
            }
        });
    }

    @Override
    public void cancelCurrentCheck() {
        this.monitor.cancelCurrentCheck();
    }

    static boolean shouldLogStageChange(ServerDescription serverDescription, ServerDescription serverDescription2) {
        String string;
        Class<?> clazz;
        if (serverDescription.isOk() != serverDescription2.isOk()) {
            return true;
        }
        if (!serverDescription.getAddress().equals(serverDescription2.getAddress())) {
            return true;
        }
        String string2 = serverDescription.getCanonicalAddress();
        if (string2 != null ? !string2.equals(serverDescription2.getCanonicalAddress()) : serverDescription2.getCanonicalAddress() != null) {
            return true;
        }
        if (!serverDescription.getHosts().equals(serverDescription2.getHosts())) {
            return true;
        }
        if (!serverDescription.getArbiters().equals(serverDescription2.getArbiters())) {
            return true;
        }
        if (!serverDescription.getPassives().equals(serverDescription2.getPassives())) {
            return true;
        }
        String string3 = serverDescription.getPrimary();
        if (string3 != null ? !string3.equals(serverDescription2.getPrimary()) : serverDescription2.getPrimary() != null) {
            return true;
        }
        String string4 = serverDescription.getSetName();
        if (string4 != null ? !string4.equals(serverDescription2.getSetName()) : serverDescription2.getSetName() != null) {
            return true;
        }
        if (serverDescription.getState() != serverDescription2.getState()) {
            return true;
        }
        if (!serverDescription.getTagSet().equals(serverDescription2.getTagSet())) {
            return true;
        }
        if (serverDescription.getType() != serverDescription2.getType()) {
            return true;
        }
        if (serverDescription.getMaxWireVersion() != serverDescription2.getMaxWireVersion()) {
            return true;
        }
        ObjectId objectId = serverDescription.getElectionId();
        if (objectId != null ? !objectId.equals(serverDescription2.getElectionId()) : serverDescription2.getElectionId() != null) {
            return true;
        }
        Integer n = serverDescription.getSetVersion();
        if (n != null ? !n.equals(serverDescription2.getSetVersion()) : serverDescription2.getSetVersion() != null) {
            return true;
        }
        Throwable throwable = serverDescription.getException();
        Throwable throwable2 = serverDescription2.getException();
        Class<?> clazz2 = throwable != null ? throwable.getClass() : null;
        Class<?> clazz3 = clazz = throwable2 != null ? throwable2.getClass() : null;
        if (!Objects.equals(clazz2, clazz)) {
            return true;
        }
        String string5 = throwable != null ? throwable.getMessage() : null;
        String string6 = string = throwable2 != null ? throwable2.getMessage() : null;
        return !Objects.equals(string5, string);
    }

    private void waitForNext() throws InterruptedException {
        Thread.sleep(this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS));
    }

    private String getHandshakeCommandName(ServerDescription serverDescription) {
        return serverDescription.isHelloOk() ? "hello" : "isMaster";
    }

    class ServerMonitor
    extends Thread
    implements AutoCloseable {
        private volatile InternalConnection connection;
        private volatile boolean currentCheckCancelled;

        ServerMonitor() {
            super("cluster-" + DefaultServerMonitor.this.serverId.getClusterId() + "-" + DefaultServerMonitor.this.serverId.getAddress());
            this.connection = null;
            this.setDaemon(true);
        }

        @Override
        public void close() {
            this.interrupt();
            InternalConnection internalConnection = this.connection;
            if (internalConnection != null) {
                internalConnection.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerDescription serverDescription = ServerDescriptionHelper.unknownConnectingServerDescription(DefaultServerMonitor.this.serverId, null);
            try {
                while (!DefaultServerMonitor.this.isClosed) {
                    ServerDescription serverDescription2 = serverDescription;
                    boolean bl = this.shouldStreamResponses(serverDescription = this.lookupServerDescription(serverDescription));
                    if (bl) {
                        DefaultServerMonitor.this.ensureRoundTripTimeMonitorStarted();
                    }
                    if (DefaultServerMonitor.this.isClosed) continue;
                    if (this.currentCheckCancelled) {
                        this.waitForNext();
                        this.currentCheckCancelled = false;
                        continue;
                    }
                    this.logStateChange(serverDescription2, serverDescription);
                    ((SdamServerDescriptionManager)DefaultServerMonitor.this.sdamProvider.get()).update(serverDescription);
                    if (bl && serverDescription.getType() != ServerType.UNKNOWN || this.connection != null && this.connection.hasMoreToCome() || serverDescription.getException() instanceof MongoSocketException && serverDescription2.getType() != ServerType.UNKNOWN) continue;
                    this.waitForNext();
                }
            }
            catch (MongoInterruptedException | InterruptedException exception) {
            }
            catch (RuntimeException runtimeException) {
                LOGGER.error(String.format("Server monitor for %s exiting with exception", DefaultServerMonitor.this.serverId), runtimeException);
            }
            finally {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        private ServerDescription lookupServerDescription(ServerDescription serverDescription) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    this.currentCheckCancelled = false;
                    InternalConnection internalConnection = DefaultServerMonitor.this.internalConnectionFactory.create(DefaultServerMonitor.this.serverId);
                    internalConnection.open(DefaultServerMonitor.this.operationContextFactory.create());
                    this.connection = internalConnection;
                    DefaultServerMonitor.this.roundTripTimeSampler.addSample(this.connection.getInitialServerDescription().getRoundTripTimeNanos());
                    return this.connection.getInitialServerDescription();
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Checking status of %s", DefaultServerMonitor.this.serverId.getAddress()));
                }
                boolean bl = this.shouldStreamResponses(serverDescription);
                DefaultServerMonitor.this.serverMonitorListener.serverHearbeatStarted(new ServerHeartbeatStartedEvent(this.connection.getDescription().getConnectionId(), bl));
                long l = System.nanoTime();
                try {
                    BsonDocument bsonDocument;
                    OperationContext operationContext = DefaultServerMonitor.this.operationContextFactory.create();
                    if (!this.connection.hasMoreToCome()) {
                        bsonDocument = new BsonDocument(DefaultServerMonitor.this.getHandshakeCommandName(serverDescription), new BsonInt32(1)).append("helloOk", BsonBoolean.TRUE);
                        if (bl) {
                            bsonDocument.append("topologyVersion", Assertions.assertNotNull(serverDescription.getTopologyVersion()).asDocument());
                            bsonDocument.append("maxAwaitTimeMS", new BsonInt64(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS)));
                        }
                        this.connection.send(this.createCommandMessage(bsonDocument, this.connection, serverDescription), new BsonDocumentCodec(), operationContext);
                    }
                    bsonDocument = bl ? this.connection.receive(new BsonDocumentCodec(), this.operationContextWithAdditionalTimeout(operationContext)) : this.connection.receive(new BsonDocumentCodec(), operationContext);
                    long l2 = System.nanoTime() - l;
                    if (!bl) {
                        DefaultServerMonitor.this.roundTripTimeSampler.addSample(l2);
                    }
                    DefaultServerMonitor.this.serverMonitorListener.serverHeartbeatSucceeded(new ServerHeartbeatSucceededEvent(this.connection.getDescription().getConnectionId(), bsonDocument, l2, bl));
                    return DescriptionHelper.createServerDescription(DefaultServerMonitor.this.serverId.getAddress(), bsonDocument, DefaultServerMonitor.this.roundTripTimeSampler.getAverage(), DefaultServerMonitor.this.roundTripTimeSampler.getMin());
                }
                catch (Exception exception) {
                    DefaultServerMonitor.this.serverMonitorListener.serverHeartbeatFailed(new ServerHeartbeatFailedEvent(this.connection.getDescription().getConnectionId(), System.nanoTime() - l, bl, exception));
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                DefaultServerMonitor.this.roundTripTimeSampler.reset();
                InternalConnection internalConnection = Locks.withLock(DefaultServerMonitor.this.lock, () -> {
                    InternalConnection internalConnection = this.connection;
                    this.connection = null;
                    return internalConnection;
                });
                if (internalConnection != null) {
                    internalConnection.close();
                }
                return ServerDescriptionHelper.unknownConnectingServerDescription(DefaultServerMonitor.this.serverId, throwable);
            }
        }

        private OperationContext operationContextWithAdditionalTimeout(OperationContext operationContext) {
            TimeoutContext timeoutContext = operationContext.getTimeoutContext().withAdditionalReadTimeout(Math.toIntExact(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS)));
            return operationContext.withTimeoutContext(timeoutContext);
        }

        private boolean shouldStreamResponses(ServerDescription serverDescription) {
            boolean bl = serverDescription.getTopologyVersion() != null;
            switch (DefaultServerMonitor.this.serverSettings.getServerMonitoringMode()) {
                case STREAM: {
                    return bl;
                }
                case POLL: {
                    return false;
                }
                case AUTO: {
                    return !DefaultServerMonitor.this.isFunctionAsAServiceEnvironment && bl;
                }
            }
            throw Assertions.fail();
        }

        private CommandMessage createCommandMessage(BsonDocument bsonDocument, InternalConnection internalConnection, ServerDescription serverDescription) {
            return new CommandMessage(new MongoNamespace("admin", "$cmd"), bsonDocument, NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), MessageSettings.builder().maxWireVersion(internalConnection.getDescription().getMaxWireVersion()).build(), this.shouldStreamResponses(serverDescription), DefaultServerMonitor.this.clusterConnectionMode, DefaultServerMonitor.this.serverApi);
        }

        private void logStateChange(ServerDescription serverDescription, ServerDescription serverDescription2) {
            if (DefaultServerMonitor.shouldLogStageChange(serverDescription, serverDescription2)) {
                if (serverDescription2.getException() != null) {
                    LOGGER.info(String.format("Exception in monitor thread while connecting to server %s", DefaultServerMonitor.this.serverId.getAddress()), Assertions.assertNotNull(serverDescription2.getException()));
                } else {
                    LOGGER.info(String.format("Monitor thread successfully connected to server with description %s", serverDescription2));
                }
            }
        }

        private void waitForNext() throws InterruptedException {
            long l;
            long l2;
            long l3;
            long l4 = this.waitForSignalOrTimeout();
            if (l4 > 0L && (l3 = DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.NANOSECONDS) - l4) < (l2 = DefaultServerMonitor.this.serverSettings.getMinHeartbeatFrequency(TimeUnit.NANOSECONDS)) && (l = TimeUnit.MILLISECONDS.convert(l2 - l3, TimeUnit.NANOSECONDS)) > 0L) {
                Thread.sleep(l);
            }
        }

        private long waitForSignalOrTimeout() throws InterruptedException {
            return Locks.checkedWithLock(DefaultServerMonitor.this.lock, () -> DefaultServerMonitor.this.condition.awaitNanos(DefaultServerMonitor.this.serverSettings.getHeartbeatFrequency(TimeUnit.NANOSECONDS)));
        }

        public void cancelCurrentCheck() {
            InternalConnection internalConnection = Locks.withLock(DefaultServerMonitor.this.lock, () -> {
                if (this.connection != null && !this.currentCheckCancelled) {
                    InternalConnection internalConnection = this.connection;
                    this.currentCheckCancelled = true;
                    return internalConnection;
                }
                return null;
            });
            if (internalConnection != null) {
                internalConnection.close();
            }
        }
    }

    private class RoundTripTimeMonitor
    extends Thread
    implements AutoCloseable {
        private volatile InternalConnection connection;

        RoundTripTimeMonitor() {
            super("cluster-rtt-" + DefaultServerMonitor.this.serverId.getClusterId() + "-" + DefaultServerMonitor.this.serverId.getAddress());
            this.connection = null;
            this.setDaemon(true);
        }

        @Override
        public void close() {
            this.interrupt();
            InternalConnection internalConnection = this.connection;
            if (internalConnection != null) {
                internalConnection.close();
            }
        }

        @Override
        public void run() {
            try {
                while (!DefaultServerMonitor.this.isClosed) {
                    block10: {
                        try {
                            if (this.connection == null) {
                                this.initialize();
                            } else {
                                this.pingServer(this.connection);
                            }
                        }
                        catch (Throwable throwable) {
                            if (this.connection == null) break block10;
                            this.connection.close();
                            this.connection = null;
                        }
                    }
                    DefaultServerMonitor.this.waitForNext();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
        }

        private void initialize() {
            this.connection = null;
            this.connection = DefaultServerMonitor.this.internalConnectionFactory.create(DefaultServerMonitor.this.serverId);
            this.connection.open(DefaultServerMonitor.this.operationContextFactory.create());
            DefaultServerMonitor.this.roundTripTimeSampler.addSample(this.connection.getInitialServerDescription().getRoundTripTimeNanos());
        }

        private void pingServer(InternalConnection internalConnection) {
            long l = System.nanoTime();
            OperationContext operationContext = DefaultServerMonitor.this.operationContextFactory.create();
            CommandHelper.executeCommand("admin", new BsonDocument(DefaultServerMonitor.this.getHandshakeCommandName(internalConnection.getInitialServerDescription()), new BsonInt32(1)), DefaultServerMonitor.this.clusterConnectionMode, DefaultServerMonitor.this.serverApi, internalConnection, operationContext);
            long l2 = System.nanoTime() - l;
            DefaultServerMonitor.this.roundTripTimeSampler.addSample(l2);
        }
    }
}

