/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoClientException;
import com.mongodb.ServerAddress;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.connection.TopologyVersion;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.types.ObjectId;

public final class DescriptionHelper {
    static ConnectionDescription createConnectionDescription(ClusterConnectionMode clusterConnectionMode, ConnectionId connectionId, BsonDocument bsonDocument) {
        Object object;
        ConnectionDescription connectionDescription = new ConnectionDescription(connectionId, DescriptionHelper.getMaxWireVersion(bsonDocument), DescriptionHelper.getServerType(bsonDocument), DescriptionHelper.getMaxWriteBatchSize(bsonDocument), DescriptionHelper.getMaxBsonObjectSize(bsonDocument), DescriptionHelper.getMaxMessageSizeBytes(bsonDocument), DescriptionHelper.getCompressors(bsonDocument), bsonDocument.getArray("saslSupportedMechs", null), DescriptionHelper.getLogicalSessionTimeoutMinutes(bsonDocument));
        if (bsonDocument.containsKey("connectionId")) {
            object = connectionDescription.getConnectionId().withServerValue(bsonDocument.getNumber("connectionId").longValue());
            connectionDescription = connectionDescription.withConnectionId((ConnectionId)object);
        }
        if (clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED) {
            object = DescriptionHelper.getServiceId(bsonDocument);
            if (object != null) {
                connectionDescription = connectionDescription.withServiceId((ObjectId)object);
            } else {
                throw new MongoClientException("Driver attempted to initialize in load balancing mode, but the server does not support this mode");
            }
        }
        return connectionDescription;
    }

    public static ServerDescription createServerDescription(ServerAddress serverAddress, BsonDocument bsonDocument, long l, long l2) {
        return ServerDescription.builder().state(ServerConnectionState.CONNECTED).address(serverAddress).type(DescriptionHelper.getServerType(bsonDocument)).cryptd(bsonDocument.getBoolean("iscryptd", BsonBoolean.FALSE).getValue()).canonicalAddress(bsonDocument.containsKey("me") ? bsonDocument.getString("me").getValue() : null).hosts(DescriptionHelper.listToSet(bsonDocument.getArray("hosts", new BsonArray()))).passives(DescriptionHelper.listToSet(bsonDocument.getArray("passives", new BsonArray()))).arbiters(DescriptionHelper.listToSet(bsonDocument.getArray("arbiters", new BsonArray()))).primary(DescriptionHelper.getString(bsonDocument, "primary")).maxDocumentSize(DescriptionHelper.getMaxBsonObjectSize(bsonDocument)).tagSet(DescriptionHelper.getTagSetFromDocument(bsonDocument.getDocument("tags", new BsonDocument()))).setName(DescriptionHelper.getString(bsonDocument, "setName")).minWireVersion(DescriptionHelper.getMinWireVersion(bsonDocument)).maxWireVersion(DescriptionHelper.getMaxWireVersion(bsonDocument)).electionId(DescriptionHelper.getElectionId(bsonDocument)).setVersion(DescriptionHelper.getSetVersion(bsonDocument)).topologyVersion(DescriptionHelper.getTopologyVersion(bsonDocument)).lastWriteDate(DescriptionHelper.getLastWriteDate(bsonDocument)).roundTripTime(l, TimeUnit.NANOSECONDS).minRoundTripTime(l2, TimeUnit.NANOSECONDS).logicalSessionTimeoutMinutes(DescriptionHelper.getLogicalSessionTimeoutMinutes(bsonDocument)).helloOk(bsonDocument.getBoolean("helloOk", BsonBoolean.FALSE).getValue()).ok(CommandHelper.isCommandOk(bsonDocument)).build();
    }

    private static int getMinWireVersion(BsonDocument bsonDocument) {
        return bsonDocument.getInt32("minWireVersion", new BsonInt32(ServerDescription.getDefaultMinWireVersion())).getValue();
    }

    private static int getMaxWireVersion(BsonDocument bsonDocument) {
        return bsonDocument.getInt32("maxWireVersion", new BsonInt32(ServerDescription.getDefaultMaxWireVersion())).getValue();
    }

    @Nullable
    private static Date getLastWriteDate(BsonDocument bsonDocument) {
        if (!bsonDocument.containsKey("lastWrite")) {
            return null;
        }
        return new Date(bsonDocument.getDocument("lastWrite").getDateTime("lastWriteDate").getValue());
    }

    @Nullable
    private static ObjectId getElectionId(BsonDocument bsonDocument) {
        return bsonDocument.containsKey("electionId") ? bsonDocument.getObjectId("electionId").getValue() : null;
    }

    @Nullable
    private static Integer getSetVersion(BsonDocument bsonDocument) {
        return bsonDocument.containsKey("setVersion") ? Integer.valueOf(bsonDocument.getNumber("setVersion").intValue()) : null;
    }

    @Nullable
    private static TopologyVersion getTopologyVersion(BsonDocument bsonDocument) {
        return bsonDocument.containsKey("topologyVersion") && bsonDocument.get("topologyVersion").isDocument() ? new TopologyVersion(bsonDocument.getDocument("topologyVersion")) : null;
    }

    @Nullable
    private static ObjectId getServiceId(BsonDocument bsonDocument) {
        return bsonDocument.containsKey("serviceId") && bsonDocument.get("serviceId").isObjectId() ? bsonDocument.getObjectId("serviceId").getValue() : null;
    }

    private static int getMaxMessageSizeBytes(BsonDocument bsonDocument) {
        return bsonDocument.getInt32("maxMessageSizeBytes", new BsonInt32(ConnectionDescription.getDefaultMaxMessageSize())).getValue();
    }

    private static int getMaxBsonObjectSize(BsonDocument bsonDocument) {
        return bsonDocument.getInt32("maxBsonObjectSize", new BsonInt32(ServerDescription.getDefaultMaxDocumentSize())).getValue();
    }

    private static int getMaxWriteBatchSize(BsonDocument bsonDocument) {
        return bsonDocument.getInt32("maxWriteBatchSize", new BsonInt32(ConnectionDescription.getDefaultMaxWriteBatchSize())).getValue();
    }

    @Nullable
    private static Integer getLogicalSessionTimeoutMinutes(BsonDocument bsonDocument) {
        return bsonDocument.isNumber("logicalSessionTimeoutMinutes") ? Integer.valueOf(bsonDocument.getNumber("logicalSessionTimeoutMinutes").intValue()) : null;
    }

    @Nullable
    private static String getString(BsonDocument bsonDocument, String string) {
        if (bsonDocument.containsKey(string)) {
            return bsonDocument.getString(string).getValue();
        }
        return null;
    }

    private static Set<String> listToSet(@Nullable BsonArray bsonArray) {
        if (bsonArray == null || bsonArray.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (BsonValue bsonValue : bsonArray) {
            hashSet.add(bsonValue.asString().getValue());
        }
        return hashSet;
    }

    private static ServerType getServerType(BsonDocument bsonDocument) {
        if (!CommandHelper.isCommandOk(bsonDocument)) {
            return ServerType.UNKNOWN;
        }
        if (DescriptionHelper.isReplicaSetMember(bsonDocument)) {
            if (bsonDocument.getBoolean("hidden", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_OTHER;
            }
            if (bsonDocument.getBoolean("isWritablePrimary", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_PRIMARY;
            }
            if (bsonDocument.getBoolean(CommandHelper.LEGACY_HELLO_LOWER, BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_PRIMARY;
            }
            if (bsonDocument.getBoolean("secondary", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_SECONDARY;
            }
            if (bsonDocument.getBoolean("arbiterOnly", BsonBoolean.FALSE).getValue()) {
                return ServerType.REPLICA_SET_ARBITER;
            }
            if (bsonDocument.containsKey("setName") && bsonDocument.containsKey("hosts")) {
                return ServerType.REPLICA_SET_OTHER;
            }
            return ServerType.REPLICA_SET_GHOST;
        }
        if (bsonDocument.containsKey("msg") && bsonDocument.get("msg").equals(new BsonString("isdbgrid"))) {
            return ServerType.SHARD_ROUTER;
        }
        return ServerType.STANDALONE;
    }

    private static boolean isReplicaSetMember(BsonDocument bsonDocument) {
        return bsonDocument.containsKey("setName") || bsonDocument.getBoolean("isreplicaset", BsonBoolean.FALSE).getValue();
    }

    private static TagSet getTagSetFromDocument(BsonDocument bsonDocument) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (Map.Entry<String, BsonValue> entry : bsonDocument.entrySet()) {
            arrayList.add(new Tag(entry.getKey(), entry.getValue().asString().getValue()));
        }
        return new TagSet(arrayList);
    }

    private static List<String> getCompressors(BsonDocument bsonDocument) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BsonValue bsonValue : bsonDocument.getArray("compression", new BsonArray())) {
            arrayList.add(bsonValue.asString().getValue());
        }
        return arrayList;
    }

    private DescriptionHelper() {
    }
}

