/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.lang.Nullable;
import java.util.Objects;

final class EventHelper {
    static boolean wouldDescriptionsGenerateEquivalentEvents(ClusterDescription clusterDescription, ClusterDescription clusterDescription2) {
        if (!EventHelper.exceptionsEquals(clusterDescription.getSrvResolutionException(), clusterDescription2.getSrvResolutionException())) {
            return false;
        }
        if (clusterDescription.getServerDescriptions().size() != clusterDescription2.getServerDescriptions().size()) {
            return false;
        }
        for (ServerDescription serverDescription : clusterDescription.getServerDescriptions()) {
            ServerDescription serverDescription2 = null;
            for (ServerDescription serverDescription3 : clusterDescription2.getServerDescriptions()) {
                if (!serverDescription.getAddress().equals(serverDescription3.getAddress())) continue;
                serverDescription2 = serverDescription3;
                break;
            }
            if (EventHelper.wouldDescriptionsGenerateEquivalentEvents(serverDescription, serverDescription2)) continue;
            return false;
        }
        return true;
    }

    static boolean wouldDescriptionsGenerateEquivalentEvents(@Nullable ServerDescription serverDescription, @Nullable ServerDescription serverDescription2) {
        if (serverDescription == serverDescription2) {
            return true;
        }
        if (serverDescription2 == null || serverDescription == null) {
            return false;
        }
        if (serverDescription.isOk() != serverDescription2.isOk()) {
            return false;
        }
        if (serverDescription.getState() != serverDescription2.getState()) {
            return false;
        }
        if (serverDescription.getType() != serverDescription2.getType()) {
            return false;
        }
        if (serverDescription.getMinWireVersion() != serverDescription2.getMinWireVersion()) {
            return false;
        }
        if (serverDescription.getMaxWireVersion() != serverDescription2.getMaxWireVersion()) {
            return false;
        }
        if (!Objects.equals(serverDescription.getCanonicalAddress(), serverDescription2.getCanonicalAddress())) {
            return false;
        }
        if (!serverDescription.getHosts().equals(serverDescription2.getHosts())) {
            return false;
        }
        if (!serverDescription.getPassives().equals(serverDescription2.getPassives())) {
            return false;
        }
        if (!serverDescription.getArbiters().equals(serverDescription2.getArbiters())) {
            return false;
        }
        if (!serverDescription.getTagSet().equals(serverDescription2.getTagSet())) {
            return false;
        }
        if (!Objects.equals(serverDescription.getSetName(), serverDescription2.getSetName())) {
            return false;
        }
        if (!Objects.equals(serverDescription.getSetVersion(), serverDescription2.getSetVersion())) {
            return false;
        }
        if (!Objects.equals(serverDescription.getElectionId(), serverDescription2.getElectionId())) {
            return false;
        }
        if (!Objects.equals(serverDescription.getPrimary(), serverDescription2.getPrimary())) {
            return false;
        }
        if (!Objects.equals(serverDescription.getLogicalSessionTimeoutMinutes(), serverDescription2.getLogicalSessionTimeoutMinutes())) {
            return false;
        }
        if (!Objects.equals(serverDescription.getTopologyVersion(), serverDescription2.getTopologyVersion())) {
            return false;
        }
        return EventHelper.exceptionsEquals(serverDescription.getException(), serverDescription2.getException());
    }

    private static boolean exceptionsEquals(@Nullable Throwable throwable, @Nullable Throwable throwable2) {
        if (throwable == null || throwable2 == null) {
            return throwable == throwable2;
        }
        if (!Objects.equals(throwable.getClass(), throwable2.getClass())) {
            return false;
        }
        return Objects.equals(throwable.getMessage(), throwable2.getMessage());
    }

    private EventHelper() {
    }
}

