/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import java.util.concurrent.atomic.AtomicLong;

class ExponentiallyWeightedMovingAverage {
    private static final long EMPTY = -1L;
    private final double alpha;
    private final AtomicLong average;

    ExponentiallyWeightedMovingAverage(double d) {
        Assertions.isTrueArgument("alpha >= 0.0 and <= 1.0", d >= 0.0 && d <= 1.0);
        this.alpha = d;
        this.average = new AtomicLong(-1L);
    }

    void reset() {
        this.average.set(-1L);
    }

    long addSample(long l3) {
        return this.average.accumulateAndGet(l3, (l, l2) -> {
            if (l == -1L) {
                return l2;
            }
            return (long)(this.alpha * (double)l2 + (1.0 - this.alpha) * (double)l);
        });
    }

    long getAverage() {
        long l = this.average.get();
        return l == -1L ? 0L : l;
    }
}

