/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

enum FaasEnvironment {
    AWS_LAMBDA("aws.lambda"),
    AZURE_FUNC("azure.func"),
    GCP_FUNC("gcp.func"),
    VERCEL("vercel"),
    UNKNOWN(null);

    static final Map<String, String> ENV_OVERRIDES_FOR_TESTING;
    @Nullable
    private final String name;

    static FaasEnvironment getFaasEnvironment() {
        ArrayList<FaasEnvironment> arrayList = new ArrayList<FaasEnvironment>();
        String string = FaasEnvironment.getEnv("AWS_EXECUTION_ENV");
        if (FaasEnvironment.getEnv("VERCEL") != null) {
            arrayList.add(VERCEL);
        }
        if (string != null && string.startsWith("AWS_Lambda_") || FaasEnvironment.getEnv("AWS_LAMBDA_RUNTIME_API") != null) {
            arrayList.add(AWS_LAMBDA);
        }
        if (FaasEnvironment.getEnv("FUNCTIONS_WORKER_RUNTIME") != null) {
            arrayList.add(AZURE_FUNC);
        }
        if (FaasEnvironment.getEnv("K_SERVICE") != null || FaasEnvironment.getEnv("FUNCTION_NAME") != null) {
            arrayList.add(GCP_FUNC);
        }
        if (arrayList.equals(Arrays.asList(VERCEL, AWS_LAMBDA))) {
            return VERCEL;
        }
        if (arrayList.size() != 1) {
            return UNKNOWN;
        }
        return (FaasEnvironment)((Object)arrayList.get(0));
    }

    @Nullable
    public static String getEnv(String string) {
        if (ENV_OVERRIDES_FOR_TESTING.containsKey(string)) {
            return ENV_OVERRIDES_FOR_TESTING.get(string);
        }
        return System.getenv(string);
    }

    private FaasEnvironment(String string2) {
        this.name = string2;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Integer getTimeoutSec() {
        switch (this) {
            case GCP_FUNC: {
                return FaasEnvironment.getEnvInteger("FUNCTION_TIMEOUT_SEC");
            }
        }
        return null;
    }

    @Nullable
    public Integer getMemoryMb() {
        switch (this) {
            case AWS_LAMBDA: {
                return FaasEnvironment.getEnvInteger("AWS_LAMBDA_FUNCTION_MEMORY_SIZE");
            }
            case GCP_FUNC: {
                return FaasEnvironment.getEnvInteger("FUNCTION_MEMORY_MB");
            }
        }
        return null;
    }

    @Nullable
    public String getRegion() {
        switch (this) {
            case AWS_LAMBDA: {
                return FaasEnvironment.getEnv("AWS_REGION");
            }
            case GCP_FUNC: {
                return FaasEnvironment.getEnv("FUNCTION_REGION");
            }
            case VERCEL: {
                return FaasEnvironment.getEnv("VERCEL_REGION");
            }
        }
        return null;
    }

    @Nullable
    private static Integer getEnvInteger(String string) {
        try {
            String string2 = FaasEnvironment.getEnv(string);
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static {
        ENV_OVERRIDES_FOR_TESTING = new HashMap<String, String>();
    }
}

