/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.BsonWriterDecorator;
import org.bson.BsonBinary;
import org.bson.BsonDbPointer;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonWriter;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class FieldTrackingBsonWriter
extends BsonWriterDecorator {
    private boolean hasWrittenField;
    private boolean topLevelDocumentWritten;

    public FieldTrackingBsonWriter(BsonWriter bsonWriter) {
        super(bsonWriter);
    }

    public boolean hasWrittenField() {
        return this.hasWrittenField;
    }

    @Override
    public void writeStartDocument(String string) {
        if (this.topLevelDocumentWritten) {
            this.hasWrittenField = true;
        }
        super.writeStartDocument(string);
    }

    @Override
    public void writeStartDocument() {
        if (this.topLevelDocumentWritten) {
            this.hasWrittenField = true;
        }
        this.topLevelDocumentWritten = true;
        super.writeStartDocument();
    }

    @Override
    public void writeStartArray(String string) {
        this.hasWrittenField = true;
        super.writeStartArray(string);
    }

    @Override
    public void writeStartArray() {
        this.hasWrittenField = true;
        super.writeStartArray();
    }

    @Override
    public void writeBinaryData(String string, BsonBinary bsonBinary) {
        this.hasWrittenField = true;
        super.writeBinaryData(string, bsonBinary);
    }

    @Override
    public void writeBinaryData(BsonBinary bsonBinary) {
        this.hasWrittenField = true;
        super.writeBinaryData(bsonBinary);
    }

    @Override
    public void writeBoolean(String string, boolean bl) {
        this.hasWrittenField = true;
        super.writeBoolean(string, bl);
    }

    @Override
    public void writeBoolean(boolean bl) {
        this.hasWrittenField = true;
        super.writeBoolean(bl);
    }

    @Override
    public void writeDateTime(String string, long l) {
        this.hasWrittenField = true;
        super.writeDateTime(string, l);
    }

    @Override
    public void writeDateTime(long l) {
        this.hasWrittenField = true;
        super.writeDateTime(l);
    }

    @Override
    public void writeDBPointer(String string, BsonDbPointer bsonDbPointer) {
        this.hasWrittenField = true;
        super.writeDBPointer(string, bsonDbPointer);
    }

    @Override
    public void writeDBPointer(BsonDbPointer bsonDbPointer) {
        this.hasWrittenField = true;
        super.writeDBPointer(bsonDbPointer);
    }

    @Override
    public void writeDouble(String string, double d) {
        this.hasWrittenField = true;
        super.writeDouble(string, d);
    }

    @Override
    public void writeDouble(double d) {
        this.hasWrittenField = true;
        super.writeDouble(d);
    }

    @Override
    public void writeInt32(String string, int n) {
        this.hasWrittenField = true;
        super.writeInt32(string, n);
    }

    @Override
    public void writeInt32(int n) {
        this.hasWrittenField = true;
        super.writeInt32(n);
    }

    @Override
    public void writeInt64(String string, long l) {
        super.writeInt64(string, l);
        this.hasWrittenField = true;
    }

    @Override
    public void writeInt64(long l) {
        this.hasWrittenField = true;
        super.writeInt64(l);
    }

    @Override
    public void writeDecimal128(Decimal128 decimal128) {
        this.hasWrittenField = true;
        super.writeDecimal128(decimal128);
    }

    @Override
    public void writeDecimal128(String string, Decimal128 decimal128) {
        this.hasWrittenField = true;
        super.writeDecimal128(string, decimal128);
    }

    @Override
    public void writeJavaScript(String string, String string2) {
        this.hasWrittenField = true;
        super.writeJavaScript(string, string2);
    }

    @Override
    public void writeJavaScript(String string) {
        this.hasWrittenField = true;
        super.writeJavaScript(string);
    }

    @Override
    public void writeJavaScriptWithScope(String string, String string2) {
        super.writeJavaScriptWithScope(string, string2);
        this.hasWrittenField = true;
    }

    @Override
    public void writeJavaScriptWithScope(String string) {
        this.hasWrittenField = true;
        super.writeJavaScriptWithScope(string);
    }

    @Override
    public void writeMaxKey(String string) {
        this.hasWrittenField = true;
        super.writeMaxKey(string);
    }

    @Override
    public void writeMaxKey() {
        this.hasWrittenField = true;
        super.writeMaxKey();
    }

    @Override
    public void writeMinKey(String string) {
        this.hasWrittenField = true;
        super.writeMinKey(string);
    }

    @Override
    public void writeMinKey() {
        this.hasWrittenField = true;
        super.writeMinKey();
    }

    @Override
    public void writeNull(String string) {
        this.hasWrittenField = true;
        super.writeNull(string);
    }

    @Override
    public void writeNull() {
        this.hasWrittenField = true;
        super.writeNull();
    }

    @Override
    public void writeObjectId(String string, ObjectId objectId) {
        this.hasWrittenField = true;
        super.writeObjectId(string, objectId);
    }

    @Override
    public void writeObjectId(ObjectId objectId) {
        this.hasWrittenField = true;
        super.writeObjectId(objectId);
    }

    @Override
    public void writeRegularExpression(String string, BsonRegularExpression bsonRegularExpression) {
        this.hasWrittenField = true;
        super.writeRegularExpression(string, bsonRegularExpression);
    }

    @Override
    public void writeRegularExpression(BsonRegularExpression bsonRegularExpression) {
        this.hasWrittenField = true;
        super.writeRegularExpression(bsonRegularExpression);
    }

    @Override
    public void writeString(String string, String string2) {
        this.hasWrittenField = true;
        super.writeString(string, string2);
    }

    @Override
    public void writeString(String string) {
        this.hasWrittenField = true;
        super.writeString(string);
    }

    @Override
    public void writeSymbol(String string, String string2) {
        this.hasWrittenField = true;
        super.writeSymbol(string, string2);
    }

    @Override
    public void writeSymbol(String string) {
        this.hasWrittenField = true;
        super.writeSymbol(string);
    }

    @Override
    public void writeTimestamp(String string, BsonTimestamp bsonTimestamp) {
        this.hasWrittenField = true;
        super.writeTimestamp(string, bsonTimestamp);
    }

    @Override
    public void writeTimestamp(BsonTimestamp bsonTimestamp) {
        this.hasWrittenField = true;
        super.writeTimestamp(bsonTimestamp);
    }

    @Override
    public void writeUndefined(String string) {
        this.hasWrittenField = true;
        super.writeUndefined(string);
    }

    @Override
    public void writeUndefined() {
        this.hasWrittenField = true;
        super.writeUndefined();
    }

    @Override
    public void pipe(BsonReader bsonReader) {
        this.hasWrittenField = true;
        super.pipe(bsonReader);
    }
}

