/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

class FutureAsyncCompletionHandler<T>
implements AsyncCompletionHandler<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile T result;
    private volatile Throwable error;

    FutureAsyncCompletionHandler() {
    }

    @Override
    public void completed(@Nullable T t) {
        this.result = t;
        this.latch.countDown();
    }

    @Override
    public void failed(Throwable throwable) {
        this.error = throwable;
        this.latch.countDown();
    }

    public void getOpen() throws IOException {
        this.get("Opening");
    }

    public void getWrite() throws IOException {
        this.get("Writing to");
    }

    public T getRead() throws IOException {
        return this.get("Reading from");
    }

    private T get(String string) throws IOException {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            throw InterruptionUtil.interruptAndCreateMongoInterruptedException(string + " the AsynchronousSocketChannelStream failed", interruptedException);
        }
        if (this.error != null) {
            if (this.error instanceof IOException) {
                throw (IOException)this.error;
            }
            if (this.error instanceof MongoException) {
                throw (MongoException)this.error;
            }
            throw new MongoInternalException(string + " the AsynchronousSocketChannelStream failed", this.error);
        }
        return this.result;
    }
}

