/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.KerberosSubjectProvider;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.SubjectProvider;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.SaslAuthenticator;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class GSSAPIAuthenticator
extends SaslAuthenticator {
    private static final String GSSAPI_MECHANISM_NAME = "GSSAPI";
    private static final String GSSAPI_OID = "1.2.840.113554.1.2.2";
    private static final String SERVICE_NAME_DEFAULT_VALUE = "mongodb";
    private static final Boolean CANONICALIZE_HOST_NAME_DEFAULT_VALUE = false;

    GSSAPIAuthenticator(MongoCredentialWithCache mongoCredentialWithCache, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(mongoCredentialWithCache, clusterConnectionMode, serverApi);
        if (this.getMongoCredential().getAuthenticationMechanism() != AuthenticationMechanism.GSSAPI) {
            throw new MongoException("Incorrect mechanism: " + this.getMongoCredential().getMechanism());
        }
    }

    @Override
    public String getMechanismName() {
        return GSSAPI_MECHANISM_NAME;
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        MongoCredential mongoCredential = this.getMongoCredential();
        try {
            SaslClient saslClient;
            HashMap<String, Object> hashMap = mongoCredential.getMechanismProperty("JAVA_SASL_CLIENT_PROPERTIES", null);
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
                hashMap.put("javax.security.sasl.maxbuffer", "0");
                hashMap.put("javax.security.sasl.credentials", this.getGSSCredential(Assertions.assertNotNull(mongoCredential.getUserName())));
            }
            if ((saslClient = Sasl.createSaslClient(new String[]{AuthenticationMechanism.GSSAPI.getMechanismName()}, mongoCredential.getUserName(), mongoCredential.getMechanismProperty("SERVICE_NAME", SERVICE_NAME_DEFAULT_VALUE), this.getHostName(serverAddress), hashMap, null)) == null) {
                throw new MongoSecurityException(mongoCredential, String.format("No platform support for %s mechanism", new Object[]{AuthenticationMechanism.GSSAPI}));
            }
            return saslClient;
        }
        catch (SaslException saslException) {
            throw new MongoSecurityException(mongoCredential, "Exception initializing SASL client", (Throwable)saslException);
        }
        catch (GSSException gSSException) {
            throw new MongoSecurityException(mongoCredential, "Exception initializing GSSAPI credentials", (Throwable)gSSException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new MongoSecurityException(mongoCredential, "Unable to canonicalize host name + " + serverAddress);
        }
    }

    private GSSCredential getGSSCredential(String string) throws GSSException {
        Oid oid = new Oid(GSSAPI_OID);
        GSSManager gSSManager = GSSManager.getInstance();
        GSSName gSSName = gSSManager.createName(string, GSSName.NT_USER_NAME);
        return gSSManager.createCredential(gSSName, Integer.MAX_VALUE, oid, 1);
    }

    private String getHostName(ServerAddress serverAddress) throws UnknownHostException {
        return this.getNonNullMechanismProperty("CANONICALIZE_HOST_NAME", CANONICALIZE_HOST_NAME_DEFAULT_VALUE) != false ? InetAddress.getByName(serverAddress.getHost()).getCanonicalHostName() : serverAddress.getHost();
    }

    @Override
    @NonNull
    protected SubjectProvider getDefaultSubjectProvider() {
        return new KerberosSubjectProvider();
    }
}

