/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.LevelCountingBsonWriter;
import com.mongodb.lang.Nullable;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.io.BasicOutputBuffer;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class IdHoldingBsonWriter
extends LevelCountingBsonWriter {
    private static final String ID_FIELD_NAME = "_id";
    private LevelCountingBsonWriter idBsonBinaryWriter;
    private BasicOutputBuffer outputBuffer;
    private String currentFieldName;
    private final BsonValue fallbackId;
    private BsonValue id;
    private boolean idFieldIsAnArray = false;

    public IdHoldingBsonWriter(BsonWriter bsonWriter, @Nullable BsonObjectId bsonObjectId) {
        super(bsonWriter);
        this.fallbackId = bsonObjectId;
    }

    @Override
    public void writeStartDocument(String string) {
        this.setCurrentFieldName(string);
        if (this.isWritingId()) {
            this.getIdBsonWriter().writeStartDocument(string);
        }
        super.writeStartDocument(string);
    }

    @Override
    public void writeStartDocument() {
        if (this.isWritingId()) {
            this.getIdBsonWriter().writeStartDocument();
        }
        super.writeStartDocument();
    }

    @Override
    public void writeEndDocument() {
        if (this.isWritingId()) {
            if (this.getIdBsonWriterCurrentLevel() > -1) {
                this.getIdBsonWriter().writeEndDocument();
            }
            if (this.getIdBsonWriterCurrentLevel() == -1) {
                if (this.id != null && this.id.isJavaScriptWithScope()) {
                    this.id = new BsonJavaScriptWithScope(this.id.asJavaScriptWithScope().getCode(), new RawBsonDocument(this.getBytes()));
                } else if (this.id == null) {
                    this.id = new RawBsonDocument(this.getBytes());
                }
            }
        }
        if (this.getCurrentLevel() == 0 && this.id == null) {
            this.id = this.fallbackId == null ? new BsonObjectId() : this.fallbackId;
            this.writeObjectId(ID_FIELD_NAME, this.id.asObjectId().getValue());
        }
        super.writeEndDocument();
    }

    @Override
    public void writeStartArray() {
        if (this.isWritingId()) {
            if (this.getIdBsonWriterCurrentLevel() == -1) {
                this.idFieldIsAnArray = true;
                this.getIdBsonWriter().writeStartDocument();
                this.getIdBsonWriter().writeName(ID_FIELD_NAME);
            }
            this.getIdBsonWriter().writeStartArray();
        }
        super.writeStartArray();
    }

    @Override
    public void writeStartArray(String string) {
        this.setCurrentFieldName(string);
        if (this.isWritingId()) {
            if (this.getIdBsonWriterCurrentLevel() == -1) {
                this.getIdBsonWriter().writeStartDocument();
            }
            this.getIdBsonWriter().writeStartArray(string);
        }
        super.writeStartArray(string);
    }

    @Override
    public void writeEndArray() {
        if (this.isWritingId()) {
            this.getIdBsonWriter().writeEndArray();
            if (this.getIdBsonWriterCurrentLevel() == 0 && this.idFieldIsAnArray) {
                this.getIdBsonWriter().writeEndDocument();
                this.id = new RawBsonDocument(this.getBytes()).get(ID_FIELD_NAME);
            }
        }
        super.writeEndArray();
    }

    @Override
    public void writeBinaryData(String string, BsonBinary bsonBinary) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> bsonBinary, () -> this.getIdBsonWriter().writeBinaryData(string, bsonBinary));
        super.writeBinaryData(string, bsonBinary);
    }

    @Override
    public void writeBinaryData(BsonBinary bsonBinary) {
        this.addBsonValue(() -> bsonBinary, () -> this.getIdBsonWriter().writeBinaryData(bsonBinary));
        super.writeBinaryData(bsonBinary);
    }

    @Override
    public void writeBoolean(String string, boolean bl) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> BsonBoolean.valueOf(bl), () -> this.getIdBsonWriter().writeBoolean(string, bl));
        super.writeBoolean(string, bl);
    }

    @Override
    public void writeBoolean(boolean bl) {
        this.addBsonValue(() -> BsonBoolean.valueOf(bl), () -> this.getIdBsonWriter().writeBoolean(bl));
        super.writeBoolean(bl);
    }

    @Override
    public void writeDateTime(String string, long l) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> new BsonDateTime(l), () -> this.getIdBsonWriter().writeDateTime(string, l));
        super.writeDateTime(string, l);
    }

    @Override
    public void writeDateTime(long l) {
        this.addBsonValue(() -> new BsonDateTime(l), () -> this.getIdBsonWriter().writeDateTime(l));
        super.writeDateTime(l);
    }

    @Override
    public void writeDBPointer(String string, BsonDbPointer bsonDbPointer) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> bsonDbPointer, () -> this.getIdBsonWriter().writeDBPointer(string, bsonDbPointer));
        super.writeDBPointer(string, bsonDbPointer);
    }

    @Override
    public void writeDBPointer(BsonDbPointer bsonDbPointer) {
        this.addBsonValue(() -> bsonDbPointer, () -> this.getIdBsonWriter().writeDBPointer(bsonDbPointer));
        super.writeDBPointer(bsonDbPointer);
    }

    @Override
    public void writeDouble(String string, double d) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> new BsonDouble(d), () -> this.getIdBsonWriter().writeDouble(string, d));
        super.writeDouble(string, d);
    }

    @Override
    public void writeDouble(double d) {
        this.addBsonValue(() -> new BsonDouble(d), () -> this.getIdBsonWriter().writeDouble(d));
        super.writeDouble(d);
    }

    @Override
    public void writeInt32(String string, int n) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> new BsonInt32(n), () -> this.getIdBsonWriter().writeInt32(string, n));
        super.writeInt32(string, n);
    }

    @Override
    public void writeInt32(int n) {
        this.addBsonValue(() -> new BsonInt32(n), () -> this.getIdBsonWriter().writeInt32(n));
        super.writeInt32(n);
    }

    @Override
    public void writeInt64(String string, long l) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> new BsonInt64(l), () -> this.getIdBsonWriter().writeInt64(string, l));
        super.writeInt64(string, l);
    }

    @Override
    public void writeInt64(long l) {
        this.addBsonValue(() -> new BsonInt64(l), () -> this.getIdBsonWriter().writeInt64(l));
        super.writeInt64(l);
    }

    @Override
    public void writeDecimal128(String string, Decimal128 decimal128) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> new BsonDecimal128(decimal128), () -> this.getIdBsonWriter().writeDecimal128(string, decimal128));
        super.writeDecimal128(string, decimal128);
    }

    @Override
    public void writeDecimal128(Decimal128 decimal128) {
        this.addBsonValue(() -> new BsonDecimal128(decimal128), () -> this.getIdBsonWriter().writeDecimal128(decimal128));
        super.writeDecimal128(decimal128);
    }

    @Override
    public void writeJavaScript(String string, String string2) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> new BsonJavaScript(string2), () -> this.getIdBsonWriter().writeJavaScript(string, string2));
        super.writeJavaScript(string, string2);
    }

    @Override
    public void writeJavaScript(String string) {
        this.addBsonValue(() -> new BsonJavaScript(string), () -> this.getIdBsonWriter().writeJavaScript(string));
        super.writeJavaScript(string);
    }

    @Override
    public void writeJavaScriptWithScope(String string, String string2) {
        this.addBsonValue(() -> new BsonJavaScriptWithScope(string2, new BsonDocument()), () -> this.getIdBsonWriter().writeJavaScriptWithScope(string, string2));
        super.writeJavaScriptWithScope(string, string2);
    }

    @Override
    public void writeJavaScriptWithScope(String string) {
        this.addBsonValue(() -> new BsonJavaScriptWithScope(string, new BsonDocument()), () -> this.getIdBsonWriter().writeJavaScriptWithScope(string));
        super.writeJavaScriptWithScope(string);
    }

    @Override
    public void writeMaxKey(String string) {
        this.setCurrentFieldName(string);
        this.addBsonValue(BsonMaxKey::new, () -> this.getIdBsonWriter().writeMaxKey(string));
        super.writeMaxKey(string);
    }

    @Override
    public void writeMaxKey() {
        this.addBsonValue(BsonMaxKey::new, this.getIdBsonWriter()::writeMaxKey);
        super.writeMaxKey();
    }

    @Override
    public void writeMinKey(String string) {
        this.setCurrentFieldName(string);
        this.addBsonValue(BsonMinKey::new, () -> this.getIdBsonWriter().writeMinKey(string));
        super.writeMinKey(string);
    }

    @Override
    public void writeMinKey() {
        this.addBsonValue(BsonMinKey::new, this.getIdBsonWriter()::writeMinKey);
        super.writeMinKey();
    }

    @Override
    public void writeName(String string) {
        this.setCurrentFieldName(string);
        if (this.getIdBsonWriterCurrentLevel() > -1) {
            this.getIdBsonWriter().writeName(string);
        }
        super.writeName(string);
    }

    @Override
    public void writeNull(String string) {
        this.setCurrentFieldName(string);
        this.addBsonValue(BsonNull::new, () -> this.getIdBsonWriter().writeNull(string));
        super.writeNull(string);
    }

    @Override
    public void writeNull() {
        this.addBsonValue(BsonNull::new, this.getIdBsonWriter()::writeNull);
        super.writeNull();
    }

    @Override
    public void writeObjectId(String string, ObjectId objectId) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> new BsonObjectId(objectId), () -> this.getIdBsonWriter().writeObjectId(string, objectId));
        super.writeObjectId(string, objectId);
    }

    @Override
    public void writeObjectId(ObjectId objectId) {
        this.addBsonValue(() -> new BsonObjectId(objectId), () -> this.getIdBsonWriter().writeObjectId(objectId));
        super.writeObjectId(objectId);
    }

    @Override
    public void writeRegularExpression(String string, BsonRegularExpression bsonRegularExpression) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> bsonRegularExpression, () -> this.getIdBsonWriter().writeRegularExpression(string, bsonRegularExpression));
        super.writeRegularExpression(string, bsonRegularExpression);
    }

    @Override
    public void writeRegularExpression(BsonRegularExpression bsonRegularExpression) {
        this.addBsonValue(() -> bsonRegularExpression, () -> this.getIdBsonWriter().writeRegularExpression(bsonRegularExpression));
        super.writeRegularExpression(bsonRegularExpression);
    }

    @Override
    public void writeString(String string, String string2) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> new BsonString(string2), () -> this.getIdBsonWriter().writeString(string, string2));
        super.writeString(string, string2);
    }

    @Override
    public void writeString(String string) {
        this.addBsonValue(() -> new BsonString(string), () -> this.getIdBsonWriter().writeString(string));
        super.writeString(string);
    }

    @Override
    public void writeSymbol(String string, String string2) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> new BsonSymbol(string2), () -> this.getIdBsonWriter().writeSymbol(string, string2));
        super.writeSymbol(string, string2);
    }

    @Override
    public void writeSymbol(String string) {
        this.addBsonValue(() -> new BsonSymbol(string), () -> this.getIdBsonWriter().writeSymbol(string));
        super.writeSymbol(string);
    }

    @Override
    public void writeTimestamp(String string, BsonTimestamp bsonTimestamp) {
        this.setCurrentFieldName(string);
        this.addBsonValue(() -> bsonTimestamp, () -> this.getIdBsonWriter().writeTimestamp(string, bsonTimestamp));
        super.writeTimestamp(string, bsonTimestamp);
    }

    @Override
    public void writeTimestamp(BsonTimestamp bsonTimestamp) {
        this.addBsonValue(() -> bsonTimestamp, () -> this.getIdBsonWriter().writeTimestamp(bsonTimestamp));
        super.writeTimestamp(bsonTimestamp);
    }

    @Override
    public void writeUndefined(String string) {
        this.setCurrentFieldName(string);
        this.addBsonValue(BsonUndefined::new, () -> this.getIdBsonWriter().writeUndefined(string));
        super.writeUndefined(string);
    }

    @Override
    public void writeUndefined() {
        this.addBsonValue(BsonUndefined::new, this.getIdBsonWriter()::writeUndefined);
        super.writeUndefined();
    }

    @Override
    public void pipe(BsonReader bsonReader) {
        super.pipe(bsonReader);
    }

    @Override
    public void flush() {
        super.flush();
    }

    @Nullable
    public BsonValue getId() {
        return this.id;
    }

    private void setCurrentFieldName(String string) {
        this.currentFieldName = string;
    }

    private boolean isWritingId() {
        return this.getIdBsonWriterCurrentLevel() > -1 || this.getCurrentLevel() == 0 && this.currentFieldName != null && this.currentFieldName.equals(ID_FIELD_NAME);
    }

    private void addBsonValue(Supplier<BsonValue> supplier, Runnable runnable) {
        if (this.isWritingId()) {
            if (this.getIdBsonWriterCurrentLevel() > -1) {
                runnable.run();
            } else {
                this.id = supplier.get();
            }
        }
    }

    private int getIdBsonWriterCurrentLevel() {
        return this.idBsonBinaryWriter == null ? -1 : this.idBsonBinaryWriter.getCurrentLevel();
    }

    private LevelCountingBsonWriter getIdBsonWriter() {
        if (this.idBsonBinaryWriter == null) {
            this.outputBuffer = new BasicOutputBuffer(128);
            this.idBsonBinaryWriter = new LevelCountingBsonWriter(new BsonBinaryWriter(this.outputBuffer)){};
        }
        return this.idBsonBinaryWriter;
    }

    private byte[] getBytes() {
        return this.outputBuffer.getInternalBuffer();
    }
}

