/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInternalException;
import com.mongodb.assertions.Assertions;
import java.util.HashMap;
import java.util.Map;

public abstract class IndexMap {
    public static IndexMap create() {
        return new RangeBased();
    }

    public static IndexMap create(int n, int n2) {
        return new RangeBased(n, n2);
    }

    public abstract IndexMap add(int var1, int var2);

    public abstract int map(int var1);

    private static class RangeBased
    extends IndexMap {
        private int startIndex;
        private int count;

        RangeBased() {
        }

        RangeBased(int n, int n2) {
            Assertions.isTrueArgument("startIndex", n >= 0);
            Assertions.isTrueArgument("count", n2 > 0);
            this.startIndex = n;
            this.count = n2;
        }

        @Override
        public IndexMap add(int n, int n2) {
            if (this.count == 0) {
                this.startIndex = n2;
                this.count = 1;
                return this;
            }
            if (n2 == this.startIndex + this.count) {
                ++this.count;
                return this;
            }
            HashBased hashBased = new HashBased(this.startIndex, this.count);
            ((IndexMap)hashBased).add(n, n2);
            return hashBased;
        }

        @Override
        public int map(int n) {
            if (n < 0) {
                throw new MongoInternalException("no mapping found for index " + n);
            }
            if (n >= this.count) {
                throw new MongoInternalException("index should not be greater than or equal to count");
            }
            return this.startIndex + n;
        }
    }

    private static class HashBased
    extends IndexMap {
        private final Map<Integer, Integer> indexMap = new HashMap<Integer, Integer>();

        HashBased(int n, int n2) {
            for (int i = n; i < n + n2; ++i) {
                this.indexMap.put(i - n, i);
            }
        }

        @Override
        public IndexMap add(int n, int n2) {
            this.indexMap.put(n, n2);
            return this;
        }

        @Override
        public int map(int n) {
            Integer n2 = this.indexMap.get(n);
            if (n2 == null) {
                throw new MongoInternalException("no mapping found for index " + n);
            }
            return n2;
        }
    }
}

