/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.lang.Nullable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

final class InetAddressUtils {
    private static final int IPV4_PART_COUNT = 4;
    private static final int IPV6_PART_COUNT = 8;
    private static final char IPV4_DELIMITER = '.';
    private static final char IPV6_DELIMITER = ':';

    private InetAddressUtils() {
    }

    static InetAddress forString(String string) {
        byte[] byArray = InetAddressUtils.ipStringToBytes(string);
        if (byArray == null) {
            throw new IllegalArgumentException(string + " IP address is incorrect");
        }
        return InetAddressUtils.bytesToInetAddress(byArray);
    }

    static boolean isInetAddress(String string) {
        return InetAddressUtils.ipStringToBytes(string) != null;
    }

    @Nullable
    static byte[] ipStringToBytes(String string) {
        String string2 = string;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '.') {
                bl2 = true;
                continue;
            }
            if (c == ':') {
                if (bl2) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == '%') {
                n = i;
                break;
            }
            if (Character.digit(c, 16) != -1) continue;
            return null;
        }
        if (bl) {
            if (bl2 && (string2 = InetAddressUtils.convertDottedQuadToHex(string2)) == null) {
                return null;
            }
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            return InetAddressUtils.textToNumericFormatV6(string2);
        }
        if (bl2) {
            if (n != -1) {
                return null;
            }
            return InetAddressUtils.textToNumericFormatV4(string2);
        }
        return null;
    }

    private static boolean hasCorrectNumberOfOctets(String string) {
        int n = 3;
        int n2 = 0;
        while (n-- > 0) {
            if ((n2 = string.indexOf(46, n2)) == -1) {
                return false;
            }
            ++n2;
        }
        return string.indexOf(46, n2) == -1;
    }

    private static int countIn(CharSequence charSequence, char c) {
        int n = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    @Nullable
    private static byte[] textToNumericFormatV4(String string) {
        if (!InetAddressUtils.hasCorrectNumberOfOctets(string)) {
            return null;
        }
        byte[] byArray = new byte[4];
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = string.indexOf(46, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            try {
                byArray[i] = InetAddressUtils.parseOctet(string, n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            n = n2 + 1;
        }
        return byArray;
    }

    @Nullable
    private static byte[] textToNumericFormatV6(String string) {
        int n = InetAddressUtils.countIn(string, ':');
        if (n < 2 || n > 8) {
            return null;
        }
        int n2 = 8 - (n + 1);
        boolean bl = false;
        for (int i = 0; i < string.length() - 1; ++i) {
            if (string.charAt(i) != ':' || string.charAt(i + 1) != ':') continue;
            if (bl) {
                return null;
            }
            bl = true;
            ++n2;
            if (i == 0) {
                ++n2;
            }
            if (i != string.length() - 2) continue;
            ++n2;
        }
        if (string.charAt(0) == ':' && string.charAt(1) != ':') {
            return null;
        }
        if (string.charAt(string.length() - 1) == ':' && string.charAt(string.length() - 2) != ':') {
            return null;
        }
        if (bl && n2 <= 0) {
            return null;
        }
        if (!bl && n + 1 != 8) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        try {
            int n3 = 0;
            if (string.charAt(0) == ':') {
                n3 = 1;
            }
            while (n3 < string.length()) {
                int n4 = string.indexOf(58, n3);
                if (n4 == -1) {
                    n4 = string.length();
                }
                if (string.charAt(n3) == ':') {
                    for (int i = 0; i < n2; ++i) {
                        byteBuffer.putShort((short)0);
                    }
                } else {
                    byteBuffer.putShort(InetAddressUtils.parseHextet(string, n3, n4));
                }
                n3 = n4 + 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byteBuffer.array();
    }

    @Nullable
    private static String convertDottedQuadToHex(String string) {
        int n = string.lastIndexOf(58);
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1);
        byte[] byArray = InetAddressUtils.textToNumericFormatV4(string3);
        if (byArray == null) {
            return null;
        }
        String string4 = Integer.toHexString((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        String string5 = Integer.toHexString((byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF);
        return string2 + string4 + ":" + string5;
    }

    private static byte parseOctet(String string, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 0 || n3 > 3) {
            throw new NumberFormatException();
        }
        if (n3 > 1 && string.charAt(n) == '0') {
            throw new NumberFormatException("IP address octal representation is not supported");
        }
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            n4 *= 10;
            int n5 = Character.digit(string.charAt(i), 10);
            if (n5 < 0) {
                throw new NumberFormatException();
            }
            n4 += n5;
        }
        if (n4 > 255) {
            throw new NumberFormatException();
        }
        return (byte)n4;
    }

    private static short parseHextet(String string, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 0 || n3 > 4) {
            throw new NumberFormatException();
        }
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            n4 <<= 4;
            n4 |= Character.digit(string.charAt(i), 16);
        }
        return (short)n4;
    }

    private static InetAddress bytesToInetAddress(byte[] byArray) {
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError((Object)unknownHostException);
        }
    }
}

