/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;
import java.util.Objects;

@Immutable
public final class InternalConnectionPoolSettings {
    private final boolean prestartAsyncWorkManager;

    private InternalConnectionPoolSettings(Builder builder) {
        this.prestartAsyncWorkManager = builder.prestartAsyncWorkManager;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isPrestartAsyncWorkManager() {
        return this.prestartAsyncWorkManager;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InternalConnectionPoolSettings internalConnectionPoolSettings = (InternalConnectionPoolSettings)object;
        return this.prestartAsyncWorkManager == internalConnectionPoolSettings.prestartAsyncWorkManager;
    }

    public int hashCode() {
        return Objects.hash(this.prestartAsyncWorkManager);
    }

    public String toString() {
        return "InternalConnectionPoolSettings{prestartAsyncWorkManager=" + this.prestartAsyncWorkManager + '}';
    }

    @NotThreadSafe
    public static final class Builder {
        private boolean prestartAsyncWorkManager = false;

        private Builder() {
        }

        public Builder prestartAsyncWorkManager(boolean bl) {
            this.prestartAsyncWorkManager = bl;
            return this;
        }

        public InternalConnectionPoolSettings build() {
            return new InternalConnectionPoolSettings(this);
        }
    }
}

