/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.LoggerSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoOperationTimeoutException;
import com.mongodb.MongoSocketClosedException;
import com.mongodb.MongoSocketReadException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.MongoSocketWriteException;
import com.mongodb.MongoSocketWriteTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerType;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.ResourceUtil;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.async.AsyncSupplier;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.CommandEventSender;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.CompressedHeader;
import com.mongodb.internal.connection.CompressedMessage;
import com.mongodb.internal.connection.Compressor;
import com.mongodb.internal.connection.ConnectionGenerationSupplier;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.InternalConnectionInitializationDescription;
import com.mongodb.internal.connection.InternalConnectionInitializer;
import com.mongodb.internal.connection.LoggingCommandEventSender;
import com.mongodb.internal.connection.MessageHeader;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.NoOpCommandEventSender;
import com.mongodb.internal.connection.OpCode;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.connection.ReplyHeader;
import com.mongodb.internal.connection.ReplyMessage;
import com.mongodb.internal.connection.ResponseBuffers;
import com.mongodb.internal.connection.SnappyCompressor;
import com.mongodb.internal.connection.Stream;
import com.mongodb.internal.connection.StreamFactory;
import com.mongodb.internal.connection.ZlibCompressor;
import com.mongodb.internal.connection.ZstdCompressor;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.logging.LogMessage;
import com.mongodb.internal.logging.StructuredLogger;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.ByteBuf;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.io.ByteBufferBsonInput;

@NotThreadSafe
public class InternalStreamConnection
implements InternalConnection {
    private static volatile boolean recordEverything = false;
    private static final Set<String> SECURITY_SENSITIVE_COMMANDS = new HashSet<String>(Arrays.asList("authenticate", "saslStart", "saslContinue", "getnonce", "createUser", "updateUser", "copydbgetnonce", "copydbsaslstart", "copydb"));
    private static final Set<String> SECURITY_SENSITIVE_HELLO_COMMANDS = new HashSet<String>(Arrays.asList("hello", "isMaster", CommandHelper.LEGACY_HELLO_LOWER));
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final ClusterConnectionMode clusterConnectionMode;
    @Nullable
    private final Authenticator authenticator;
    private final boolean isMonitoringConnection;
    private final ServerId serverId;
    private final ConnectionGenerationSupplier connectionGenerationSupplier;
    private final StreamFactory streamFactory;
    private final InternalConnectionInitializer connectionInitializer;
    private volatile ConnectionDescription description;
    private volatile ServerDescription initialServerDescription;
    private volatile Stream stream;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicBoolean opened = new AtomicBoolean();
    private final AtomicBoolean authenticated = new AtomicBoolean();
    private final List<MongoCompressor> compressorList;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    @Nullable
    private volatile Compressor sendCompressor;
    private final Map<Byte, Compressor> compressorMap;
    private volatile boolean hasMoreToCome;
    private volatile int responseTo;
    private int generation = -1;
    private static final StructuredLogger COMMAND_PROTOCOL_LOGGER = new StructuredLogger("protocol.command");

    public static void setRecordEverything(boolean bl) {
        recordEverything = bl;
    }

    static Set<String> getSecuritySensitiveCommands() {
        return Collections.unmodifiableSet(SECURITY_SENSITIVE_COMMANDS);
    }

    static Set<String> getSecuritySensitiveHelloCommands() {
        return Collections.unmodifiableSet(SECURITY_SENSITIVE_HELLO_COMMANDS);
    }

    public InternalStreamConnection(ClusterConnectionMode clusterConnectionMode, ServerId serverId, ConnectionGenerationSupplier connectionGenerationSupplier, StreamFactory streamFactory, List<MongoCompressor> list, CommandListener commandListener, InternalConnectionInitializer internalConnectionInitializer) {
        this(clusterConnectionMode, null, false, serverId, connectionGenerationSupplier, streamFactory, list, LoggerSettings.builder().build(), commandListener, internalConnectionInitializer);
    }

    public InternalStreamConnection(ClusterConnectionMode clusterConnectionMode, @Nullable Authenticator authenticator, boolean bl, ServerId serverId, ConnectionGenerationSupplier connectionGenerationSupplier, StreamFactory streamFactory, List<MongoCompressor> list, LoggerSettings loggerSettings, CommandListener commandListener, InternalConnectionInitializer internalConnectionInitializer) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.authenticator = authenticator;
        this.isMonitoringConnection = bl;
        this.serverId = Assertions.notNull("serverId", serverId);
        this.connectionGenerationSupplier = Assertions.notNull("connectionGeneration", connectionGenerationSupplier);
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", list);
        this.compressorMap = this.createCompressorMap(list);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.connectionInitializer = Assertions.notNull("connectionInitializer", internalConnectionInitializer);
        this.description = new ConnectionDescription(serverId);
        this.initialServerDescription = ServerDescription.builder().address(serverId.getAddress()).type(ServerType.UNKNOWN).state(ServerConnectionState.CONNECTING).build();
        if (clusterConnectionMode != ClusterConnectionMode.LOAD_BALANCED) {
            this.generation = connectionGenerationSupplier.getGeneration();
        }
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.description;
    }

    @Override
    public ServerDescription getInitialServerDescription() {
        return this.initialServerDescription;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void open(OperationContext operationContext) {
        Assertions.isTrue("Open already called", this.stream == null);
        this.stream = this.streamFactory.create(this.serverId.getAddress());
        try {
            OperationContext operationContext2 = operationContext.withTimeoutContext(operationContext.getTimeoutContext().withComputedServerSelectionTimeoutContext());
            this.stream.open(operationContext2);
            InternalConnectionInitializationDescription internalConnectionInitializationDescription = this.connectionInitializer.startHandshake(this, operationContext2);
            this.initAfterHandshakeStart(internalConnectionInitializationDescription);
            internalConnectionInitializationDescription = this.connectionInitializer.finishHandshake(this, internalConnectionInitializationDescription, operationContext2);
            this.initAfterHandshakeFinish(internalConnectionInitializationDescription);
        }
        catch (Throwable throwable) {
            this.close();
            if (throwable instanceof MongoException) {
                throw (MongoException)throwable;
            }
            throw new MongoException(throwable.toString(), throwable);
        }
    }

    @Override
    public void openAsync(OperationContext operationContext, final SingleResultCallback<Void> singleResultCallback) {
        Assertions.assertNull(this.stream);
        try {
            final OperationContext operationContext2 = operationContext.withTimeoutContext(operationContext.getTimeoutContext().withComputedServerSelectionTimeoutContext());
            this.stream = this.streamFactory.create(this.serverId.getAddress());
            this.stream.openAsync(operationContext2, new AsyncCompletionHandler<Void>(){

                @Override
                public void completed(@Nullable Void void_) {
                    InternalStreamConnection.this.connectionInitializer.startHandshakeAsync(InternalStreamConnection.this, operationContext2, (internalConnectionInitializationDescription2, throwable2) -> {
                        if (throwable2 != null) {
                            InternalStreamConnection.this.close();
                            singleResultCallback.onResult(null, throwable2);
                        } else {
                            Assertions.assertNotNull(internalConnectionInitializationDescription2);
                            InternalStreamConnection.this.initAfterHandshakeStart(internalConnectionInitializationDescription2);
                            InternalStreamConnection.this.connectionInitializer.finishHandshakeAsync(InternalStreamConnection.this, (InternalConnectionInitializationDescription)internalConnectionInitializationDescription2, operationContext2, (internalConnectionInitializationDescription, throwable) -> {
                                if (throwable != null) {
                                    InternalStreamConnection.this.close();
                                    singleResultCallback.onResult(null, throwable);
                                } else {
                                    Assertions.assertNotNull(internalConnectionInitializationDescription);
                                    InternalStreamConnection.this.initAfterHandshakeFinish(internalConnectionInitializationDescription);
                                    singleResultCallback.onResult(null, null);
                                }
                            });
                        }
                    });
                }

                @Override
                public void failed(Throwable throwable) {
                    InternalStreamConnection.this.close();
                    singleResultCallback.onResult(null, throwable);
                }
            });
        }
        catch (Throwable throwable) {
            this.close();
            singleResultCallback.onResult(null, throwable);
        }
    }

    private void initAfterHandshakeStart(InternalConnectionInitializationDescription internalConnectionInitializationDescription) {
        this.description = internalConnectionInitializationDescription.getConnectionDescription();
        this.initialServerDescription = internalConnectionInitializationDescription.getServerDescription();
        if (this.clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED) {
            this.generation = this.connectionGenerationSupplier.getGeneration(Assertions.assertNotNull(this.description.getServiceId()));
        }
    }

    private void initAfterHandshakeFinish(InternalConnectionInitializationDescription internalConnectionInitializationDescription) {
        this.description = internalConnectionInitializationDescription.getConnectionDescription();
        this.initialServerDescription = internalConnectionInitializationDescription.getServerDescription();
        this.opened.set(true);
        this.authenticated.set(true);
        this.sendCompressor = this.findSendCompressor(this.description);
    }

    private Map<Byte, Compressor> createCompressorMap(List<MongoCompressor> list) {
        HashMap<Byte, Compressor> hashMap = new HashMap<Byte, Compressor>(this.compressorList.size());
        for (MongoCompressor mongoCompressor : list) {
            Compressor compressor = this.createCompressor(mongoCompressor);
            hashMap.put(compressor.getId(), compressor);
        }
        return hashMap;
    }

    @Nullable
    private Compressor findSendCompressor(ConnectionDescription connectionDescription) {
        if (connectionDescription.getCompressors().isEmpty()) {
            return null;
        }
        String string = connectionDescription.getCompressors().get(0);
        for (Compressor compressor : this.compressorMap.values()) {
            if (!compressor.getName().equals(string)) continue;
            return compressor;
        }
        throw new MongoInternalException("Unexpected compressor negotiated: " + string);
    }

    private Compressor createCompressor(MongoCompressor mongoCompressor) {
        switch (mongoCompressor.getName()) {
            case "zlib": {
                return new ZlibCompressor(mongoCompressor);
            }
            case "snappy": {
                return new SnappyCompressor();
            }
            case "zstd": {
                return new ZstdCompressor();
            }
        }
        throw new MongoClientException("Unsupported compressor " + mongoCompressor.getName());
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true) && this.stream != null) {
            this.stream.close();
        }
    }

    @Override
    public boolean opened() {
        return this.opened.get();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    @Nullable
    public <T> T sendAndReceive(CommandMessage commandMessage, Decoder<T> decoder, OperationContext operationContext) {
        Supplier<Object> supplier = () -> this.sendAndReceiveInternal(commandMessage, decoder, operationContext);
        try {
            return (T)supplier.get();
        }
        catch (MongoCommandException mongoCommandException) {
            if (this.reauthenticationIsTriggered(mongoCommandException)) {
                return (T)this.reauthenticateAndRetry(supplier, operationContext);
            }
            throw mongoCommandException;
        }
    }

    @Override
    public <T> void sendAndReceiveAsync(CommandMessage commandMessage, Decoder<T> decoder, OperationContext operationContext, SingleResultCallback<T> singleResultCallback2) {
        AsyncSupplier asyncSupplier = singleResultCallback -> this.sendAndReceiveAsyncInternal(commandMessage, decoder, operationContext, singleResultCallback);
        AsyncRunnable.beginAsync().thenSupply(singleResultCallback -> asyncSupplier.getAsync(singleResultCallback)).onErrorIf(throwable -> this.reauthenticationIsTriggered((Throwable)throwable), (throwable, singleResultCallback) -> this.reauthenticateAndRetryAsync(asyncSupplier, operationContext, singleResultCallback)).finish(singleResultCallback2);
    }

    private <T> T reauthenticateAndRetry(Supplier<T> supplier, OperationContext operationContext) {
        this.authenticated.set(false);
        Assertions.assertNotNull(this.authenticator).reauthenticate(this, operationContext);
        this.authenticated.set(true);
        return supplier.get();
    }

    private <T> void reauthenticateAndRetryAsync(AsyncSupplier<T> asyncSupplier, OperationContext operationContext, SingleResultCallback<T> singleResultCallback2) {
        AsyncRunnable.beginAsync().thenRun(singleResultCallback -> {
            this.authenticated.set(false);
            Assertions.assertNotNull(this.authenticator).reauthenticateAsync(this, operationContext, singleResultCallback);
        }).thenSupply(singleResultCallback -> {
            this.authenticated.set(true);
            asyncSupplier.getAsync(singleResultCallback);
        }).finish(singleResultCallback2);
    }

    public boolean reauthenticationIsTriggered(@Nullable Throwable throwable) {
        if (!Authenticator.shouldAuthenticate(this.authenticator, this.description)) {
            return false;
        }
        if (throwable instanceof MongoCommandException) {
            MongoCommandException mongoCommandException = (MongoCommandException)throwable;
            return mongoCommandException.getErrorCode() == 391;
        }
        return false;
    }

    @Nullable
    private <T> T sendAndReceiveInternal(CommandMessage commandMessage, Decoder<T> decoder, OperationContext operationContext) {
        CommandEventSender commandEventSender;
        try (ByteBufferBsonOutput byteBufferBsonOutput = new ByteBufferBsonOutput(this);){
            commandMessage.encode(byteBufferBsonOutput, operationContext);
            commandEventSender = this.createCommandEventSender(commandMessage, byteBufferBsonOutput, operationContext);
            commandEventSender.sendStartedEvent();
            try {
                this.sendCommandMessage(commandMessage, byteBufferBsonOutput, operationContext);
            }
            catch (Exception exception) {
                commandEventSender.sendFailedEvent(exception);
                throw exception;
            }
        }
        if (commandMessage.isResponseExpected()) {
            return this.receiveCommandMessageResponse(decoder, commandEventSender, operationContext);
        }
        commandEventSender.sendSucceededEventForOneWayCommand();
        return null;
    }

    @Override
    public <T> void send(CommandMessage commandMessage, Decoder<T> decoder, OperationContext operationContext) {
        try (ByteBufferBsonOutput byteBufferBsonOutput = new ByteBufferBsonOutput(this);){
            commandMessage.encode(byteBufferBsonOutput, operationContext);
            this.sendCommandMessage(commandMessage, byteBufferBsonOutput, operationContext);
            if (commandMessage.isResponseExpected()) {
                this.hasMoreToCome = true;
            }
        }
    }

    @Override
    public <T> T receive(Decoder<T> decoder, OperationContext operationContext) {
        Assertions.isTrue("Response is expected", this.hasMoreToCome);
        return this.receiveCommandMessageResponse(decoder, new NoOpCommandEventSender(), operationContext);
    }

    @Override
    public boolean hasMoreToCome() {
        return this.hasMoreToCome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommandMessage(CommandMessage commandMessage, ByteBufferBsonOutput byteBufferBsonOutput, OperationContext operationContext) {
        Compressor compressor = this.sendCompressor;
        if (compressor == null || SECURITY_SENSITIVE_COMMANDS.contains(commandMessage.getCommandDocument(byteBufferBsonOutput).getFirstKey())) {
            this.trySendMessage(commandMessage, byteBufferBsonOutput, operationContext);
        } else {
            ByteBufferBsonOutput byteBufferBsonOutput2;
            List<ByteBuf> list = byteBufferBsonOutput.getByteBuffers();
            try {
                CompressedMessage compressedMessage = new CompressedMessage(commandMessage.getOpCode(), list, compressor, ProtocolHelper.getMessageSettings(this.description, this.initialServerDescription));
                byteBufferBsonOutput2 = new ByteBufferBsonOutput(this);
                compressedMessage.encode(byteBufferBsonOutput2, operationContext);
            }
            finally {
                ResourceUtil.release(list);
                byteBufferBsonOutput.close();
            }
            this.trySendMessage(commandMessage, byteBufferBsonOutput2, operationContext);
        }
        this.responseTo = commandMessage.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySendMessage(CommandMessage commandMessage, ByteBufferBsonOutput byteBufferBsonOutput, OperationContext operationContext) {
        Timeout.onExistsAndExpired(operationContext.getTimeoutContext().timeoutIncludingRoundTrip(), () -> {
            throw TimeoutContext.createMongoRoundTripTimeoutException();
        });
        List<ByteBuf> list = byteBufferBsonOutput.getByteBuffers();
        try {
            this.sendMessage(list, commandMessage.getId(), operationContext);
        }
        finally {
            ResourceUtil.release(list);
            byteBufferBsonOutput.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T receiveCommandMessageResponse(Decoder<T> decoder, CommandEventSender commandEventSender, OperationContext operationContext) {
        boolean bl = false;
        try (ResponseBuffers responseBuffers = this.receiveResponseBuffers(operationContext);){
            this.updateSessionContext(operationContext.getSessionContext(), responseBuffers);
            if (!ProtocolHelper.isCommandOk(responseBuffers)) {
                throw ProtocolHelper.getCommandFailureException(responseBuffers.getResponseDocument(this.responseTo, new BsonDocumentCodec()), this.description.getServerAddress(), operationContext.getTimeoutContext());
            }
            bl = true;
            commandEventSender.sendSucceededEvent(responseBuffers);
            T t2 = this.getCommandResult(decoder, responseBuffers, this.responseTo, operationContext.getTimeoutContext());
            this.hasMoreToCome = responseBuffers.getReplyHeader().hasMoreToCome();
            this.responseTo = this.hasMoreToCome ? responseBuffers.getReplyHeader().getRequestId() : 0;
            T t = t2;
            return t;
        }
        catch (Exception exception) {
            if (bl) throw exception;
            commandEventSender.sendFailedEvent(exception);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void sendAndReceiveAsyncInternal(CommandMessage commandMessage, Decoder<T> decoder, OperationContext operationContext, SingleResultCallback<T> singleResultCallback) {
        block7: {
            if (this.isClosed()) {
                singleResultCallback.onResult(null, new MongoSocketClosedException("Can not read from a closed socket", this.getServerAddress()));
                return;
            }
            ByteBufferBsonOutput byteBufferBsonOutput = new ByteBufferBsonOutput(this);
            ByteBufferBsonOutput byteBufferBsonOutput2 = new ByteBufferBsonOutput(this);
            try {
                commandMessage.encode(byteBufferBsonOutput, operationContext);
                CommandEventSender commandEventSender = this.createCommandEventSender(commandMessage, byteBufferBsonOutput, operationContext);
                commandEventSender.sendStartedEvent();
                Compressor compressor = this.sendCompressor;
                if (compressor == null || SECURITY_SENSITIVE_COMMANDS.contains(commandMessage.getCommandDocument(byteBufferBsonOutput).getFirstKey())) {
                    this.sendCommandMessageAsync(commandMessage.getId(), decoder, operationContext, singleResultCallback, byteBufferBsonOutput, commandEventSender, commandMessage.isResponseExpected());
                    break block7;
                }
                List<ByteBuf> list = byteBufferBsonOutput.getByteBuffers();
                try {
                    CompressedMessage compressedMessage = new CompressedMessage(commandMessage.getOpCode(), list, compressor, ProtocolHelper.getMessageSettings(this.description, this.initialServerDescription));
                    compressedMessage.encode(byteBufferBsonOutput2, operationContext);
                }
                finally {
                    ResourceUtil.release(list);
                    byteBufferBsonOutput.close();
                }
                this.sendCommandMessageAsync(commandMessage.getId(), decoder, operationContext, singleResultCallback, byteBufferBsonOutput2, commandEventSender, commandMessage.isResponseExpected());
            }
            catch (Throwable throwable) {
                byteBufferBsonOutput.close();
                byteBufferBsonOutput2.close();
                singleResultCallback.onResult(null, throwable);
            }
        }
    }

    private <T> void sendCommandMessageAsync(int n, Decoder<T> decoder, OperationContext operationContext, SingleResultCallback<T> singleResultCallback, ByteBufferBsonOutput byteBufferBsonOutput, CommandEventSender commandEventSender, boolean bl) {
        boolean[] blArray = new boolean[]{false};
        Timeout.onExistsAndExpired(operationContext.getTimeoutContext().timeoutIncludingRoundTrip(), () -> {
            byteBufferBsonOutput.close();
            MongoOperationTimeoutException mongoOperationTimeoutException = TimeoutContext.createMongoRoundTripTimeoutException();
            commandEventSender.sendFailedEvent(mongoOperationTimeoutException);
            singleResultCallback.onResult(null, mongoOperationTimeoutException);
            blArray[0] = true;
        });
        if (blArray[0]) {
            return;
        }
        List<ByteBuf> list = byteBufferBsonOutput.getByteBuffers();
        this.sendMessageAsync(list, n, operationContext, (void_, throwable2) -> {
            ResourceUtil.release(list);
            byteBufferBsonOutput.close();
            if (throwable2 != null) {
                commandEventSender.sendFailedEvent(throwable2);
                singleResultCallback.onResult(null, throwable2);
            } else if (!bl) {
                commandEventSender.sendSucceededEventForOneWayCommand();
                singleResultCallback.onResult(null, null);
            } else {
                this.readAsync(16, operationContext, new MessageHeaderCallback(operationContext, (responseBuffers, throwable) -> {
                    Object t;
                    if (throwable != null) {
                        commandEventSender.sendFailedEvent(throwable);
                        singleResultCallback.onResult(null, throwable);
                        return;
                    }
                    Assertions.assertNotNull(responseBuffers);
                    try {
                        this.updateSessionContext(operationContext.getSessionContext(), (ResponseBuffers)responseBuffers);
                        boolean bl = ProtocolHelper.isCommandOk(new BsonBinaryReader(new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer())));
                        responseBuffers.reset();
                        if (!bl) {
                            MongoException mongoException = ProtocolHelper.getCommandFailureException(responseBuffers.getResponseDocument(n, new BsonDocumentCodec()), this.description.getServerAddress(), operationContext.getTimeoutContext());
                            commandEventSender.sendFailedEvent(mongoException);
                            throw mongoException;
                        }
                        commandEventSender.sendSucceededEvent((ResponseBuffers)responseBuffers);
                        t = this.getCommandResult(decoder, (ResponseBuffers)responseBuffers, n, operationContext.getTimeoutContext());
                    }
                    catch (Throwable throwable2) {
                        singleResultCallback.onResult(null, throwable2);
                        return;
                    }
                    finally {
                        responseBuffers.close();
                    }
                    singleResultCallback.onResult(t, null);
                }));
            }
        });
    }

    private <T> T getCommandResult(Decoder<T> decoder, ResponseBuffers responseBuffers, int n, TimeoutContext timeoutContext) {
        T t = new ReplyMessage<T>(responseBuffers, decoder, n).getDocument();
        MongoException mongoException = ProtocolHelper.createSpecialWriteConcernException(responseBuffers, this.description.getServerAddress(), timeoutContext);
        if (mongoException instanceof MongoOperationTimeoutException) {
            throw mongoException;
        }
        if (mongoException != null) {
            throw new MongoWriteConcernWithResponseException(mongoException, t);
        }
        return t;
    }

    @Override
    public void sendMessage(List<ByteBuf> list, int n, OperationContext operationContext) {
        Assertions.notNull("stream is open", this.stream);
        if (this.isClosed()) {
            throw new MongoSocketClosedException("Cannot write to a closed stream", this.getServerAddress());
        }
        try {
            this.stream.write(list, operationContext);
        }
        catch (Exception exception) {
            this.close();
            this.throwTranslatedWriteException(exception, operationContext);
        }
    }

    @Override
    public void sendMessageAsync(List<ByteBuf> list, int n, OperationContext operationContext, SingleResultCallback<Void> singleResultCallback2) {
        AsyncRunnable.beginAsync().thenRun(singleResultCallback -> {
            Assertions.notNull("stream is open", this.stream);
            if (this.isClosed()) {
                throw new MongoSocketClosedException("Cannot write to a closed stream", this.getServerAddress());
            }
            singleResultCallback.complete(singleResultCallback);
        }).thenRunTryCatchAsyncBlocks(singleResultCallback -> this.stream.writeAsync(list, operationContext, singleResultCallback.asHandler()), Exception.class, (throwable, singleResultCallback) -> {
            try {
                this.close();
                this.throwTranslatedWriteException((Throwable)throwable, operationContext);
            }
            catch (Throwable throwable2) {
                singleResultCallback.completeExceptionally(throwable2);
            }
        }).finish(ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback2, LOGGER));
    }

    @Override
    public ResponseBuffers receiveMessage(int n, OperationContext operationContext) {
        Assertions.assertNotNull(this.stream);
        if (this.isClosed()) {
            throw new MongoSocketClosedException("Cannot read from a closed stream", this.getServerAddress());
        }
        return this.receiveResponseBuffers(operationContext);
    }

    @Override
    public void receiveMessageAsync(int n, OperationContext operationContext, SingleResultCallback<ResponseBuffers> singleResultCallback) {
        Assertions.assertNotNull(this.stream);
        if (this.isClosed()) {
            singleResultCallback.onResult(null, new MongoSocketClosedException("Can not read from a closed socket", this.getServerAddress()));
            return;
        }
        this.readAsync(16, operationContext, new MessageHeaderCallback(operationContext, (responseBuffers, throwable) -> {
            if (throwable != null) {
                this.close();
                singleResultCallback.onResult(null, throwable);
            } else {
                singleResultCallback.onResult((ResponseBuffers)responseBuffers, null);
            }
        }));
    }

    private void readAsync(int n, final OperationContext operationContext, final SingleResultCallback<ByteBuf> singleResultCallback) {
        if (this.isClosed()) {
            singleResultCallback.onResult(null, new MongoSocketClosedException("Cannot read from a closed stream", this.getServerAddress()));
            return;
        }
        try {
            this.stream.readAsync(n, operationContext, new AsyncCompletionHandler<ByteBuf>(){

                @Override
                public void completed(@Nullable ByteBuf byteBuf) {
                    singleResultCallback.onResult(byteBuf, null);
                }

                @Override
                public void failed(Throwable throwable) {
                    InternalStreamConnection.this.close();
                    singleResultCallback.onResult(null, InternalStreamConnection.this.translateReadException(throwable, operationContext));
                }
            });
        }
        catch (Exception exception) {
            this.close();
            singleResultCallback.onResult(null, this.translateReadException(exception, operationContext));
        }
    }

    private ConnectionId getId() {
        return this.description.getConnectionId();
    }

    private ServerAddress getServerAddress() {
        return this.description.getServerAddress();
    }

    private void updateSessionContext(SessionContext sessionContext, ResponseBuffers responseBuffers) {
        BsonDocument bsonDocument;
        sessionContext.advanceOperationTime(ProtocolHelper.getOperationTime(responseBuffers));
        sessionContext.advanceClusterTime(ProtocolHelper.getClusterTime(responseBuffers));
        sessionContext.setSnapshotTimestamp(ProtocolHelper.getSnapshotTimestamp(responseBuffers));
        if (sessionContext.hasActiveTransaction() && (bsonDocument = ProtocolHelper.getRecoveryToken(responseBuffers)) != null) {
            sessionContext.setRecoveryToken(bsonDocument);
        }
    }

    private void throwTranslatedWriteException(Throwable throwable, OperationContext operationContext) {
        if (throwable instanceof MongoSocketWriteTimeoutException && operationContext.getTimeoutContext().hasTimeoutMS()) {
            throw TimeoutContext.createMongoTimeoutException(throwable);
        }
        if (throwable instanceof MongoException) {
            throw (MongoException)throwable;
        }
        Optional<MongoInterruptedException> optional = InterruptionUtil.translateInterruptedException(throwable, "Interrupted while sending message");
        if (optional.isPresent()) {
            throw optional.get();
        }
        if (throwable instanceof IOException) {
            throw new MongoSocketWriteException("Exception sending message", this.getServerAddress(), throwable);
        }
        throw new MongoInternalException("Unexpected exception", throwable);
    }

    private MongoException translateReadException(Throwable throwable, OperationContext operationContext) {
        if (operationContext.getTimeoutContext().hasTimeoutMS()) {
            if (throwable instanceof SocketTimeoutException) {
                return TimeoutContext.createMongoTimeoutException(this.createReadTimeoutException((SocketTimeoutException)throwable));
            }
            if (throwable instanceof MongoSocketReadTimeoutException) {
                return TimeoutContext.createMongoTimeoutException(throwable);
            }
        }
        if (throwable instanceof MongoException) {
            return (MongoException)throwable;
        }
        Optional<MongoInterruptedException> optional = InterruptionUtil.translateInterruptedException(throwable, "Interrupted while receiving message");
        if (optional.isPresent()) {
            return optional.get();
        }
        if (throwable instanceof SocketTimeoutException) {
            return this.createReadTimeoutException((SocketTimeoutException)throwable);
        }
        if (throwable instanceof IOException) {
            return new MongoSocketReadException("Exception receiving message", this.getServerAddress(), throwable);
        }
        if (throwable instanceof RuntimeException) {
            return new MongoInternalException("Unexpected runtime exception", throwable);
        }
        return new MongoInternalException("Unexpected exception", throwable);
    }

    private MongoSocketReadTimeoutException createReadTimeoutException(SocketTimeoutException socketTimeoutException) {
        return new MongoSocketReadTimeoutException("Timeout while receiving message", this.getServerAddress(), (Throwable)socketTimeoutException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResponseBuffers receiveResponseBuffers(OperationContext operationContext) {
        try {
            MessageHeader messageHeader;
            ByteBuf byteBuf2 = this.stream.read(16, operationContext);
            try {
                messageHeader = new MessageHeader(byteBuf2, this.description.getMaxMessageSize());
            }
            finally {
                byteBuf2.release();
            }
            ByteBuf byteBuf = this.stream.read(messageHeader.getMessageLength() - 16, operationContext);
            boolean bl = true;
            try {
                if (messageHeader.getOpCode() == OpCode.OP_COMPRESSED.getValue()) {
                    CompressedHeader compressedHeader = new CompressedHeader(byteBuf, messageHeader);
                    Compressor compressor = this.getCompressor(compressedHeader);
                    ByteBuf byteBuf3 = this.getBuffer(compressedHeader.getUncompressedSize());
                    compressor.uncompress(byteBuf, byteBuf3);
                    byteBuf3.flip();
                    ResponseBuffers responseBuffers = new ResponseBuffers(new ReplyHeader(byteBuf3, compressedHeader), byteBuf3);
                    return responseBuffers;
                }
                ResponseBuffers responseBuffers = new ResponseBuffers(new ReplyHeader(byteBuf, messageHeader), byteBuf);
                bl = false;
                ResponseBuffers responseBuffers2 = responseBuffers;
                return responseBuffers2;
            }
            finally {
                if (bl) {
                    byteBuf.release();
                }
            }
        }
        catch (Throwable throwable2) {
            this.close();
            throw this.translateReadException(throwable2, operationContext);
        }
    }

    private Compressor getCompressor(CompressedHeader compressedHeader) {
        Compressor compressor = this.compressorMap.get(compressedHeader.getCompressorId());
        if (compressor == null) {
            throw new MongoClientException("Unsupported compressor with identifier " + compressedHeader.getCompressorId());
        }
        return compressor;
    }

    @Override
    public ByteBuf getBuffer(int n) {
        Assertions.notNull("open", this.stream);
        return this.stream.getBuffer(n);
    }

    private CommandEventSender createCommandEventSender(CommandMessage commandMessage, ByteBufferBsonOutput byteBufferBsonOutput, OperationContext operationContext) {
        boolean bl;
        boolean bl2 = bl = this.commandListener != null || COMMAND_PROTOCOL_LOGGER.isRequired(LogMessage.Level.DEBUG, this.getClusterId());
        if (!(recordEverything || !this.isMonitoringConnection && this.opened() && this.authenticated.get() && bl)) {
            return new NoOpCommandEventSender();
        }
        return new LoggingCommandEventSender(SECURITY_SENSITIVE_COMMANDS, SECURITY_SENSITIVE_HELLO_COMMANDS, this.description, this.commandListener, operationContext, commandMessage, byteBufferBsonOutput, COMMAND_PROTOCOL_LOGGER, this.loggerSettings);
    }

    private ClusterId getClusterId() {
        return this.description.getConnectionId().getServerId().getClusterId();
    }

    private class MessageHeaderCallback
    implements SingleResultCallback<ByteBuf> {
        private final OperationContext operationContext;
        private final SingleResultCallback<ResponseBuffers> callback;

        MessageHeaderCallback(OperationContext operationContext, SingleResultCallback<ResponseBuffers> singleResultCallback) {
            this.operationContext = operationContext;
            this.callback = singleResultCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResult(@Nullable ByteBuf byteBuf, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.callback.onResult(null, throwable);
                return;
            }
            try {
                Assertions.assertNotNull(byteBuf);
                MessageHeader messageHeader = new MessageHeader(byteBuf, InternalStreamConnection.this.description.getMaxMessageSize());
                InternalStreamConnection.this.readAsync(messageHeader.getMessageLength() - 16, this.operationContext, new MessageCallback(messageHeader));
            }
            catch (Throwable throwable2) {
                this.callback.onResult(null, throwable2);
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
        }

        private class MessageCallback
        implements SingleResultCallback<ByteBuf> {
            private final MessageHeader messageHeader;

            MessageCallback(MessageHeader messageHeader) {
                this.messageHeader = messageHeader;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(@Nullable ByteBuf byteBuf, @Nullable Throwable throwable) {
                if (throwable != null) {
                    MessageHeaderCallback.this.callback.onResult(null, throwable);
                    return;
                }
                boolean bl = true;
                Assertions.assertNotNull(byteBuf);
                try {
                    ByteBuf byteBuf2;
                    ReplyHeader replyHeader;
                    if (this.messageHeader.getOpCode() == OpCode.OP_COMPRESSED.getValue()) {
                        try {
                            CompressedHeader compressedHeader = new CompressedHeader(byteBuf, this.messageHeader);
                            Compressor compressor = InternalStreamConnection.this.getCompressor(compressedHeader);
                            ByteBuf byteBuf3 = InternalStreamConnection.this.getBuffer(compressedHeader.getUncompressedSize());
                            compressor.uncompress(byteBuf, byteBuf3);
                            byteBuf3.flip();
                            replyHeader = new ReplyHeader(byteBuf3, compressedHeader);
                            byteBuf2 = byteBuf3;
                        }
                        finally {
                            bl = false;
                            byteBuf.release();
                        }
                    } else {
                        replyHeader = new ReplyHeader(byteBuf, this.messageHeader);
                        byteBuf2 = byteBuf;
                        bl = false;
                    }
                    MessageHeaderCallback.this.callback.onResult(new ResponseBuffers(replyHeader, byteBuf2), null);
                }
                catch (Throwable throwable2) {
                    MessageHeaderCallback.this.callback.onResult(null, throwable2);
                }
                finally {
                    if (bl) {
                        byteBuf.release();
                    }
                }
            }
        }
    }
}

