/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.DefaultAuthenticator;
import com.mongodb.internal.connection.DescriptionHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.InternalConnectionInitializationDescription;
import com.mongodb.internal.connection.InternalConnectionInitializer;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.SpeculativeAuthenticator;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;

public class InternalStreamConnectionInitializer
implements InternalConnectionInitializer {
    private static final int INITIAL_MIN_RTT = 0;
    private final ClusterConnectionMode clusterConnectionMode;
    private final Authenticator authenticator;
    private final BsonDocument clientMetadataDocument;
    private final List<MongoCompressor> requestedCompressors;
    private final boolean checkSaslSupportedMechs;
    private final ServerApi serverApi;

    public InternalStreamConnectionInitializer(ClusterConnectionMode clusterConnectionMode, @Nullable Authenticator authenticator, @Nullable BsonDocument bsonDocument, List<MongoCompressor> list, @Nullable ServerApi serverApi) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.authenticator = authenticator;
        this.clientMetadataDocument = bsonDocument;
        this.requestedCompressors = Assertions.notNull("requestedCompressors", list);
        this.checkSaslSupportedMechs = authenticator instanceof DefaultAuthenticator;
        this.serverApi = serverApi;
    }

    @Override
    public InternalConnectionInitializationDescription startHandshake(InternalConnection internalConnection, OperationContext operationContext) {
        Assertions.notNull("internalConnection", internalConnection);
        return this.initializeConnectionDescription(internalConnection, operationContext);
    }

    @Override
    public InternalConnectionInitializationDescription finishHandshake(InternalConnection internalConnection, InternalConnectionInitializationDescription internalConnectionInitializationDescription, OperationContext operationContext) {
        Assertions.notNull("internalConnection", internalConnection);
        Assertions.notNull("description", internalConnectionInitializationDescription);
        ConnectionDescription connectionDescription = internalConnectionInitializationDescription.getConnectionDescription();
        if (Authenticator.shouldAuthenticate(this.authenticator, connectionDescription)) {
            this.authenticator.authenticate(internalConnection, connectionDescription, operationContext);
        }
        return this.completeConnectionDescriptionInitialization(internalConnection, internalConnectionInitializationDescription, operationContext);
    }

    @Override
    public void startHandshakeAsync(InternalConnection internalConnection, OperationContext operationContext, SingleResultCallback<InternalConnectionInitializationDescription> singleResultCallback) {
        long l = System.nanoTime();
        CommandHelper.executeCommandAsync("admin", this.createHelloCommand(this.authenticator, internalConnection), this.clusterConnectionMode, this.serverApi, internalConnection, operationContext, (bsonDocument, throwable) -> {
            if (throwable != null) {
                singleResultCallback.onResult(null, throwable instanceof MongoException ? this.mapHelloException((MongoException)throwable) : throwable);
            } else {
                InternalConnectionInitializationDescription internalConnectionInitializationDescription;
                this.setSpeculativeAuthenticateResponse((BsonDocument)bsonDocument);
                try {
                    internalConnectionInitializationDescription = this.createInitializationDescription((BsonDocument)bsonDocument, internalConnection, l);
                }
                catch (Throwable throwable2) {
                    singleResultCallback.onResult(null, throwable2);
                    return;
                }
                singleResultCallback.onResult(internalConnectionInitializationDescription, null);
            }
        });
    }

    @Override
    public void finishHandshakeAsync(InternalConnection internalConnection, InternalConnectionInitializationDescription internalConnectionInitializationDescription, OperationContext operationContext, SingleResultCallback<InternalConnectionInitializationDescription> singleResultCallback) {
        ConnectionDescription connectionDescription = internalConnectionInitializationDescription.getConnectionDescription();
        if (!Authenticator.shouldAuthenticate(this.authenticator, connectionDescription)) {
            this.completeConnectionDescriptionInitializationAsync(internalConnection, internalConnectionInitializationDescription, operationContext, singleResultCallback);
        } else {
            this.authenticator.authenticateAsync(internalConnection, connectionDescription, operationContext, (void_, throwable) -> {
                if (throwable != null) {
                    singleResultCallback.onResult(null, throwable);
                } else {
                    this.completeConnectionDescriptionInitializationAsync(internalConnection, internalConnectionInitializationDescription, operationContext, singleResultCallback);
                }
            });
        }
    }

    private InternalConnectionInitializationDescription initializeConnectionDescription(InternalConnection internalConnection, OperationContext operationContext) {
        BsonDocument bsonDocument;
        BsonDocument bsonDocument2 = this.createHelloCommand(this.authenticator, internalConnection);
        long l = System.nanoTime();
        try {
            bsonDocument = CommandHelper.executeCommand("admin", bsonDocument2, this.clusterConnectionMode, this.serverApi, internalConnection, operationContext);
        }
        catch (MongoException mongoException) {
            throw this.mapHelloException(mongoException);
        }
        finally {
            operationContext.getTimeoutContext().resetMaintenanceTimeout();
        }
        this.setSpeculativeAuthenticateResponse(bsonDocument);
        return this.createInitializationDescription(bsonDocument, internalConnection, l);
    }

    private MongoException mapHelloException(MongoException mongoException) {
        if (this.checkSaslSupportedMechs && mongoException.getCode() == 11) {
            MongoCredential mongoCredential = this.authenticator.getMongoCredential();
            return new MongoSecurityException(mongoCredential, String.format("Exception authenticating %s", mongoCredential), (Throwable)mongoException);
        }
        return mongoException;
    }

    private InternalConnectionInitializationDescription createInitializationDescription(BsonDocument bsonDocument, InternalConnection internalConnection, long l) {
        ConnectionId connectionId = internalConnection.getDescription().getConnectionId();
        ConnectionDescription connectionDescription = DescriptionHelper.createConnectionDescription(this.clusterConnectionMode, connectionId, bsonDocument);
        ServerDescription serverDescription = DescriptionHelper.createServerDescription(internalConnection.getDescription().getServerAddress(), bsonDocument, System.nanoTime() - l, 0L);
        return new InternalConnectionInitializationDescription(connectionDescription, serverDescription);
    }

    private BsonDocument createHelloCommand(Authenticator authenticator, InternalConnection internalConnection) {
        Object object;
        BsonDocument bsonDocument = new BsonDocument(this.getHandshakeCommandName(), new BsonInt32(1)).append("helloOk", BsonBoolean.TRUE);
        if (this.clientMetadataDocument != null) {
            bsonDocument.append("client", this.clientMetadataDocument);
        }
        if (this.clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED) {
            bsonDocument.append("loadBalanced", BsonBoolean.TRUE);
        }
        if (!this.requestedCompressors.isEmpty()) {
            object = new BsonArray(this.requestedCompressors.size());
            for (MongoCompressor mongoCompressor : this.requestedCompressors) {
                ((BsonArray)object).add(new BsonString(mongoCompressor.getName()));
            }
            bsonDocument.append("compression", (BsonValue)object);
        }
        if (this.checkSaslSupportedMechs) {
            object = authenticator.getMongoCredential();
            bsonDocument.append("saslSupportedMechs", new BsonString(((MongoCredential)object).getSource() + "." + ((MongoCredential)object).getUserName()));
        }
        if (authenticator instanceof SpeculativeAuthenticator && (object = ((SpeculativeAuthenticator)((Object)authenticator)).createSpeculativeAuthenticateCommand(internalConnection)) != null) {
            bsonDocument.append("speculativeAuthenticate", (BsonValue)object);
        }
        return bsonDocument;
    }

    private InternalConnectionInitializationDescription completeConnectionDescriptionInitialization(InternalConnection internalConnection, InternalConnectionInitializationDescription internalConnectionInitializationDescription, OperationContext operationContext) {
        if (internalConnectionInitializationDescription.getConnectionDescription().getConnectionId().getServerValue() != null) {
            return internalConnectionInitializationDescription;
        }
        return this.applyGetLastErrorResult(CommandHelper.executeCommandWithoutCheckingForFailure("admin", new BsonDocument("getlasterror", new BsonInt32(1)), this.clusterConnectionMode, this.serverApi, internalConnection, operationContext), internalConnectionInitializationDescription);
    }

    private void setSpeculativeAuthenticateResponse(BsonDocument bsonDocument) {
        if (this.authenticator instanceof SpeculativeAuthenticator) {
            ((SpeculativeAuthenticator)((Object)this.authenticator)).setSpeculativeAuthenticateResponse(bsonDocument.getDocument("speculativeAuthenticate", null));
        }
    }

    private void completeConnectionDescriptionInitializationAsync(InternalConnection internalConnection, InternalConnectionInitializationDescription internalConnectionInitializationDescription, OperationContext operationContext, SingleResultCallback<InternalConnectionInitializationDescription> singleResultCallback) {
        if (internalConnectionInitializationDescription.getConnectionDescription().getConnectionId().getServerValue() != null) {
            singleResultCallback.onResult(internalConnectionInitializationDescription, null);
            return;
        }
        CommandHelper.executeCommandAsync("admin", new BsonDocument("getlasterror", new BsonInt32(1)), this.clusterConnectionMode, this.serverApi, internalConnection, operationContext, (bsonDocument, throwable) -> {
            if (throwable != null) {
                singleResultCallback.onResult(internalConnectionInitializationDescription, null);
            } else {
                singleResultCallback.onResult(this.applyGetLastErrorResult((BsonDocument)bsonDocument, internalConnectionInitializationDescription), null);
            }
        });
    }

    private InternalConnectionInitializationDescription applyGetLastErrorResult(BsonDocument bsonDocument, InternalConnectionInitializationDescription internalConnectionInitializationDescription) {
        ConnectionDescription connectionDescription = internalConnectionInitializationDescription.getConnectionDescription();
        ConnectionId connectionId = bsonDocument.containsKey("connectionId") ? connectionDescription.getConnectionId().withServerValue(bsonDocument.getNumber("connectionId").longValue()) : connectionDescription.getConnectionId();
        return internalConnectionInitializationDescription.withConnectionDescription(connectionDescription.withConnectionId(connectionId));
    }

    private String getHandshakeCommandName() {
        return this.serverApi == null ? "isMaster" : "hello";
    }
}

