/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.internal.connection.BsonWriterDecorator;
import org.bson.BsonWriter;

abstract class LevelCountingBsonWriter
extends BsonWriterDecorator {
    static final int DEFAULT_INITIAL_LEVEL = -1;
    private int level;

    LevelCountingBsonWriter(BsonWriter bsonWriter) {
        this(bsonWriter, -1);
    }

    LevelCountingBsonWriter(BsonWriter bsonWriter, int n) {
        super(bsonWriter);
        this.level = n;
    }

    int getCurrentLevel() {
        return this.level;
    }

    @Override
    public void writeStartDocument(String string) {
        ++this.level;
        super.writeStartDocument(string);
    }

    @Override
    public void writeStartDocument() {
        ++this.level;
        super.writeStartDocument();
    }

    @Override
    public void writeEndDocument() {
        --this.level;
        super.writeEndDocument();
    }

    @Override
    public void writeStartArray() {
        ++this.level;
        super.writeStartArray();
    }

    @Override
    public void writeStartArray(String string) {
        ++this.level;
        super.writeStartArray(string);
    }

    @Override
    public void writeEndArray() {
        --this.level;
        super.writeEndArray();
    }
}

